/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.blocks;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.blocks.metal.BlockMetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockWoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;
import twistedgate.immersiveposts.common.blocks.IPOBlockBase;
import twistedgate.immersiveposts.enums.EnumPostMaterial;
import twistedgate.immersiveposts.enums.EnumPostType;
import twistedgate.immersiveposts.utils.BlockUtilities;

public class BlockPost
extends IPOBlockBase
implements IPostBlock,
ITileEntityProvider {
    public static final AxisAlignedBB POST_SHAPE = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
    public static final PropertyBool LPARM_NORTH = PropertyBool.func_177716_a((String)"parm_north");
    public static final PropertyBool LPARM_EAST = PropertyBool.func_177716_a((String)"parm_east");
    public static final PropertyBool LPARM_SOUTH = PropertyBool.func_177716_a((String)"parm_south");
    public static final PropertyBool LPARM_WEST = PropertyBool.func_177716_a((String)"parm_west");
    public static final PropertyDirection DIRECTION = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool FLIP = PropertyBool.func_177716_a((String)"flip");
    public static final PropertyEnum<EnumPostType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumPostType.class);
    protected EnumPostMaterial postMaterial;

    public BlockPost(Material blockMaterial, EnumPostMaterial postMaterial) {
        super(blockMaterial, postMaterial.func_176610_l());
        this.postMaterial = postMaterial;
        this.func_149752_b(5.0f);
        this.func_149711_c(3.0f);
        if (this.postMaterial == EnumPostMaterial.URANIUM) {
            this.func_149715_a(8.0f);
        }
        if (this.postMaterial == EnumPostMaterial.WOOD) {
            this.setHarvestLevel("axe", 0);
        } else {
            this.setHarvestLevel("pickaxe", 1);
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)FLIP, (Comparable)Boolean.valueOf(false)).func_177226_a(TYPE, (Comparable)((Object)EnumPostType.POST)).func_177226_a((IProperty)LPARM_NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LPARM_EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LPARM_SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LPARM_WEST, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public final EnumPostMaterial getPostMaterial() {
        return this.postMaterial;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, new IProperty[]{DIRECTION, FLIP, TYPE, LPARM_NORTH, LPARM_EAST, LPARM_SOUTH, LPARM_WEST}){

            protected BlockStateContainer.StateImplementation createState(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
                return new PostState(block, properties);
            }
        };
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(TYPE) != EnumPostType.ARM) {
            drops.add((Object)this.postMaterial.getFenceItem());
        }
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumPostType)((Object)state.func_177229_b(TYPE))) {
            case POST: {
                return 0;
            }
            case POST_TOP: {
                return 1;
            }
            case ARM: {
                int rot;
                switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                    case EAST: {
                        rot = 1;
                        break;
                    }
                    case SOUTH: {
                        rot = 2;
                        break;
                    }
                    case WEST: {
                        rot = 3;
                        break;
                    }
                    default: {
                        rot = 0;
                    }
                }
                return ((Boolean)state.func_177229_b((IProperty)FLIP) != false ? 6 : 2) + rot;
            }
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta > 0) {
            state = meta > 1 ? state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM)) : state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.POST_TOP));
            if (meta >= 6 && meta <= 9) {
                state = state.func_177226_a((IProperty)FLIP, (Comparable)Boolean.valueOf(true));
            }
            if (meta == 2 || meta == 6) {
                state = state.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH);
            }
            if (meta == 3 || meta == 7) {
                state = state.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST);
            }
            if (meta == 4 || meta == 8) {
                state = state.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH);
            }
            if (meta == 5 || meta == 9) {
                state = state.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST);
            }
        }
        return state;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.postMaterial == EnumPostMaterial.URANIUM && stateIn.func_177229_b(TYPE) != EnumPostType.ARM && rand.nextDouble() < 0.125) {
            double x = (double)pos.func_177958_n() + 0.375 + 0.25 * rand.nextDouble();
            double y = (double)pos.func_177956_o() + rand.nextDouble();
            double z = (double)pos.func_177952_p() + 0.375 + 0.25 * rand.nextDouble();
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, -1.0, 1.0, 0.25, new int[0]);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.postMaterial.getFenceItem();
    }

    public boolean canConnectTransformer(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177229_b(TYPE) != EnumPostType.ARM;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        List<AxisAlignedBB> list = this.getSelectionBounds(state, worldIn, pos);
        if (!list.isEmpty()) {
            for (AxisAlignedBB aabb : list) {
                if (!entityBox.func_72326_a(aabb.func_186670_a(pos))) continue;
                collidingBoxes.add(aabb);
            }
        }
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    public RayTraceResult func_180636_a(IBlockState state, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        List<AxisAlignedBB> bounds = this.getSelectionBounds(state, worldIn, pos);
        if (!bounds.isEmpty()) {
            RayTraceResult min = null;
            double minDist = Double.POSITIVE_INFINITY;
            for (AxisAlignedBB aabb : bounds) {
                double dist;
                RayTraceResult res;
                if (aabb == null || (res = this.func_185503_a(pos, start, end, aabb)) == null || !((dist = res.field_72307_f.func_72436_e(start)) < minDist)) continue;
                min = res;
                minDist = dist;
            }
            return min;
        }
        return this.func_185503_a(pos, start, end, state.func_185900_c((IBlockAccess)worldIn, pos));
    }

    private List<AxisAlignedBB> getSelectionBounds(IBlockState state, World world, BlockPos pos) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        ArrayList<AxisAlignedBB> bounds = new ArrayList<AxisAlignedBB>();
        if (((Boolean)state.func_177229_b((IProperty)LPARM_NORTH)).booleanValue()) {
            bounds.add(new AxisAlignedBB(0.3125, 0.25, 0.0, 0.6875, 0.75, 0.3125));
        }
        if (((Boolean)state.func_177229_b((IProperty)LPARM_SOUTH)).booleanValue()) {
            bounds.add(new AxisAlignedBB(0.3125, 0.25, 0.6875, 0.6875, 0.75, 1.0));
        }
        if (((Boolean)state.func_177229_b((IProperty)LPARM_EAST)).booleanValue()) {
            bounds.add(new AxisAlignedBB(0.6875, 0.25, 0.3125, 1.0, 0.75, 0.6875));
        }
        if (((Boolean)state.func_177229_b((IProperty)LPARM_WEST)).booleanValue()) {
            bounds.add(new AxisAlignedBB(0.0, 0.25, 0.3125, 0.3125, 0.75, 0.6875));
        }
        if (state.func_177229_b(TYPE) != EnumPostType.ARM) {
            bounds.add(POST_SHAPE);
        }
        return bounds;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack held = playerIn.func_184614_ca();
            if (EnumPostMaterial.isFenceItem(held)) {
                if (!held.func_77969_a(this.postMaterial.getFenceItem())) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString("Expected: " + this.postMaterial.getFenceItem().func_82833_r() + "."), true);
                    return true;
                }
                for (int y = 0; y < worldIn.func_72940_L() - pos.func_177956_o(); ++y) {
                    BlockPos nPos = pos.func_177982_a(0, y, 0);
                    if (BlockUtilities.getBlockFrom((IBlockAccess)worldIn, nPos) instanceof BlockPost) {
                        IBlockState s = worldIn.func_180495_p(nPos);
                        if (s.func_177229_b(TYPE) == EnumPostType.ARM && ((Boolean)s.func_177229_b((IProperty)FLIP)).booleanValue()) {
                            return true;
                        }
                        BlockPos up = nPos.func_177972_a(EnumFacing.UP);
                        if (BlockUtilities.getBlockFrom((IBlockAccess)worldIn, up) instanceof BlockPost && (s = worldIn.func_180495_p(up)).func_177229_b(TYPE) == EnumPostType.ARM) {
                            return true;
                        }
                    }
                    if (worldIn.func_175623_d(nPos)) {
                        IBlockState fb = EnumPostMaterial.getPostStateFrom(held);
                        if (fb != null && !playerIn.func_180425_c().equals((Object)nPos) && worldIn.func_175656_a(nPos, fb) && !playerIn.field_71075_bZ.field_75098_d) {
                            held.func_190918_g(1);
                        }
                        return true;
                    }
                    if (worldIn.func_180495_p(nPos).func_177230_c() instanceof BlockPost) continue;
                    return true;
                }
            } else if (Utils.isHammer((ItemStack)held)) {
                switch ((EnumPostType)((Object)state.func_177229_b(TYPE))) {
                    case POST: 
                    case POST_TOP: {
                        IBlockState defaultState = this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM));
                        switch (facing) {
                            case EAST: 
                            case SOUTH: 
                            case WEST: 
                            case NORTH: {
                                BlockPos nPos = pos.func_177972_a(facing);
                                if (worldIn.func_175623_d(nPos)) {
                                    defaultState = defaultState.func_177226_a((IProperty)DIRECTION, (Comparable)facing);
                                    worldIn.func_180501_a(nPos, defaultState, 3);
                                    defaultState.func_189546_a(worldIn, nPos, null, null);
                                    break;
                                }
                                if (BlockUtilities.getBlockFrom((IBlockAccess)worldIn, nPos) != this || worldIn.func_180495_p(nPos).func_177229_b(TYPE) != EnumPostType.ARM) break;
                                worldIn.func_175698_g(nPos);
                            }
                        }
                        return true;
                    }
                    case ARM: {
                        worldIn.func_175698_g(pos);
                        return true;
                    }
                }
            }
        }
        return Utils.isHammer((ItemStack)playerIn.func_184614_ca()) || EnumPostMaterial.isFenceItem(playerIn.func_184614_ca());
    }

    public static boolean canConnect(IBlockAccess worldIn, BlockPos posIn, EnumFacing facingIn) {
        boolean b;
        BlockPos nPos = posIn.func_177972_a(facingIn);
        IBlockState otherState = worldIn.func_180495_p(nPos);
        Block otherBlock = otherState.func_177230_c();
        if (otherBlock == Blocks.field_150350_a) {
            return false;
        }
        if (otherBlock instanceof BlockPost || otherState.func_193401_d(worldIn, nPos, facingIn) == BlockFaceShape.MIDDLE_POLE) {
            return false;
        }
        AxisAlignedBB box = otherState.func_185900_c(worldIn, nPos);
        switch (facingIn) {
            case NORTH: {
                b = box.field_72334_f == 1.0;
                break;
            }
            case SOUTH: {
                b = box.field_72339_c == 0.0;
                break;
            }
            case WEST: {
                b = box.field_72336_d == 1.0;
                break;
            }
            case EAST: {
                b = box.field_72340_a == 0.0;
                break;
            }
            default: {
                b = false;
            }
        }
        if (b && (facingIn.func_176740_k() == EnumFacing.Axis.Z && box.field_72340_a > 0.0 && box.field_72336_d < 1.0 || facingIn.func_176740_k() == EnumFacing.Axis.X && box.field_72339_c > 0.0 && box.field_72334_f < 1.0)) {
            return true;
        }
        switch (facingIn) {
            case DOWN: {
                return box.field_72337_e == 1.0;
            }
            case UP: {
                return box.field_72338_b == 0.0;
            }
        }
        return false;
    }

    public static class PostState
    extends BlockStateContainer.StateImplementation {
        public PostState(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties) {
            super(block, properties);
        }

        public IBlockState func_185899_b(IBlockAccess blockAccess, BlockPos pos) {
            if (this.func_177229_b((IProperty)TYPE) == EnumPostType.ARM) {
                return this.func_177226_a((IProperty)LPARM_NORTH, Boolean.valueOf(false)).func_177226_a((IProperty)LPARM_EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LPARM_SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LPARM_WEST, (Comparable)Boolean.valueOf(false));
            }
            boolean b0 = BlockPost.canConnect(blockAccess, pos, EnumFacing.NORTH);
            boolean b1 = BlockPost.canConnect(blockAccess, pos, EnumFacing.EAST);
            boolean b2 = BlockPost.canConnect(blockAccess, pos, EnumFacing.SOUTH);
            boolean b3 = BlockPost.canConnect(blockAccess, pos, EnumFacing.WEST);
            return this.func_177226_a((IProperty)LPARM_NORTH, Boolean.valueOf(b0)).func_177226_a((IProperty)LPARM_EAST, (Comparable)Boolean.valueOf(b1)).func_177226_a((IProperty)LPARM_SOUTH, (Comparable)Boolean.valueOf(b2)).func_177226_a((IProperty)LPARM_WEST, (Comparable)Boolean.valueOf(b3));
        }

        public BlockFaceShape func_193401_d(IBlockAccess worldIn, BlockPos pos, EnumFacing face) {
            int tmp;
            IBlockState state = worldIn.func_180495_p(pos.func_177972_a(face));
            Block block = state.func_177230_c();
            if (block instanceof BlockFence || block instanceof BlockWall) {
                return BlockFaceShape.UNDEFINED;
            }
            boolean f = false;
            if (block instanceof BlockWoodenDecoration && block.func_176201_c(state) == BlockTypes_WoodenDecoration.FENCE.getMeta()) {
                f = true;
            }
            if (block instanceof BlockMetalDecoration1 && ((tmp = block.func_176201_c(state)) == BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta() || tmp == BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta())) {
                f = true;
            }
            return f ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
        }

        public AxisAlignedBB func_185900_c(IBlockAccess blockAccess, BlockPos pos) {
            return PostState.stateBounds((IBlockState)this);
        }

        public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
            return false;
        }

        public boolean func_185915_l() {
            return false;
        }

        public boolean func_185914_p() {
            return false;
        }

        public boolean func_185917_h() {
            return false;
        }

        public void func_189546_a(World world, BlockPos pos, Block block, BlockPos fromPos) {
            BlockPos d;
            EnumPostType thisType = (EnumPostType)((Object)this.func_177229_b((IProperty)TYPE));
            if (thisType != EnumPostType.ARM && BlockUtilities.getBlockFrom((IBlockAccess)world, d = pos.func_177972_a(EnumFacing.DOWN)) == Blocks.field_150350_a) {
                block.func_176226_b(world, pos, (IBlockState)this, 0);
                world.func_175698_g(pos);
                return;
            }
            IBlockState aboveState = world.func_180495_p(pos.func_177972_a(EnumFacing.UP));
            Block aboveBlock = aboveState.func_177230_c();
            switch (thisType) {
                case POST: {
                    if (!(aboveBlock instanceof BlockPost)) {
                        world.func_175656_a(pos, this.func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumPostType.POST_TOP)));
                    }
                    return;
                }
                case POST_TOP: {
                    if (aboveBlock instanceof BlockPost && aboveState.func_177229_b(TYPE) != EnumPostType.ARM) {
                        world.func_175656_a(pos, this.func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumPostType.POST)));
                    }
                    return;
                }
                case ARM: {
                    EnumFacing f = ((EnumFacing)this.func_177229_b((IProperty)DIRECTION)).func_176734_d();
                    IBlockState state = world.func_180495_p(pos.func_177972_a(f));
                    if (state != null && !(state.func_177230_c() instanceof BlockPost)) {
                        world.func_175698_g(pos);
                        return;
                    }
                    if (BlockPost.canConnect((IBlockAccess)world, pos, EnumFacing.UP)) {
                        world.func_180501_a(pos, this.func_177226_a((IProperty)FLIP, Boolean.valueOf(false)), 3);
                    }
                    boolean bool = BlockPost.canConnect((IBlockAccess)world, pos, EnumFacing.DOWN);
                    world.func_180501_a(pos, this.func_177226_a((IProperty)FLIP, Boolean.valueOf(bool)), 3);
                    return;
                }
            }
        }

        static AxisAlignedBB stateBounds(IBlockState state) {
            switch ((EnumPostType)((Object)state.func_177229_b(TYPE))) {
                case ARM: {
                    EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)DIRECTION);
                    boolean flipped = (Boolean)state.func_177229_b((IProperty)FLIP);
                    double minY = flipped ? 0.0 : 0.34375;
                    double maxY = flipped ? 0.65625 : 1.0;
                    double minX = facing == EnumFacing.EAST ? 0.0 : 0.3125;
                    double maxX = facing == EnumFacing.WEST ? 1.0 : 0.6875;
                    double minZ = facing == EnumFacing.SOUTH ? 0.0 : 0.3125;
                    double maxZ = facing == EnumFacing.NORTH ? 1.0 : 0.6875;
                    return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
                }
            }
            return POST_SHAPE;
        }
    }
}

