/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import twistedgate.immersiveposts.common.blocks.BlockMetalFence;
import twistedgate.immersiveposts.common.blocks.BlockPost;
import twistedgate.immersiveposts.common.blocks.BlockPostBase;
import twistedgate.immersiveposts.common.items.IPOItemBase;
import twistedgate.immersiveposts.enums.EnumPostMaterial;
import twistedgate.immersiveposts.utils.StringUtils;

@Mod.EventBusSubscriber(modid="immersiveposts")
public class IPOStuff {
    public static final ArrayList<Block> BLOCKS = new ArrayList();
    public static final ArrayList<Item> ITEMS = new ArrayList();
    public static final BlockFence ironFence;
    public static final BlockFence goldFence;
    public static final BlockFence copperFence;
    public static final BlockFence leadFence;
    public static final BlockFence silverFence;
    public static final BlockFence nickelFence;
    public static final BlockFence constantanFence;
    public static final BlockFence electrumFence;
    public static final BlockFence uraniumFence;
    public static final BlockPostBase postBase;
    public static final BlockPost woodPost;
    public static final BlockPost ironPost;
    public static final BlockPost goldPost;
    public static final BlockPost copperPost;
    public static final BlockPost leadPost;
    public static final BlockPost silverPost;
    public static final BlockPost nickelPost;
    public static final BlockPost constantanPost;
    public static final BlockPost electrumPost;
    public static final BlockPost uraniumPost;
    public static final BlockPost netherPost;
    public static final BlockPost aluPost;
    public static final BlockPost steelPost;
    public static final IPOItemBase stickGold;
    public static final IPOItemBase stickCopper;
    public static final IPOItemBase stickLead;
    public static final IPOItemBase stickSilver;
    public static final IPOItemBase stickNickel;
    public static final IPOItemBase stickConstantan;
    public static final IPOItemBase stickElectrum;
    public static final IPOItemBase stickUranium;

    private static BlockPost createMetalPost(EnumPostMaterial postMat) {
        return new BlockPost(Material.field_151573_f, postMat);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : BLOCKS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : ITEMS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        IPOStuff.registerFenceOres();
        IPOStuff.registerStickOres();
    }

    private static void registerStickOres() {
        String prefix = "stick";
        String rep = "stick_";
        for (Item item : ITEMS) {
            String name;
            if (!(item instanceof IPOItemBase) || !(name = ((IPOItemBase)item).getRegistryName().func_110623_a()).contains(rep)) continue;
            String oreName = prefix + StringUtils.upperCaseFirst(name.substring(rep.length()));
            OreDictionary.registerOre((String)oreName, (Item)item);
        }
    }

    private static void registerFenceOres() {
        String prefix = "fence";
        block3: for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            switch (mat) {
                case WOOD: 
                case NETHERBRICK: 
                case IRON: 
                case ALUMINIUM: 
                case STEEL: {
                    continue block3;
                }
                default: {
                    OreDictionary.registerOre((String)(prefix + StringUtils.upperCaseFirst(mat.toString())), (Block)mat.getFenceBlock());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void regModels(ModelRegistryEvent event) {
        for (Block block : BLOCKS) {
            if (block instanceof BlockPost) continue;
            Item item = Item.func_150898_a((Block)block);
            ModelResourceLocation loc = new ModelResourceLocation(block.getRegistryName(), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)loc);
        }
        for (Item item : ITEMS) {
            if (item instanceof ItemBlock) continue;
            ModelResourceLocation loc = new ModelResourceLocation(item.getRegistryName(), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)loc);
        }
    }

    static {
        postBase = new BlockPostBase();
        ironFence = new BlockMetalFence("fence_iron");
        goldFence = new BlockMetalFence("fence_gold");
        copperFence = new BlockMetalFence("fence_copper");
        leadFence = new BlockMetalFence("fence_lead");
        silverFence = new BlockMetalFence("fence_silver");
        nickelFence = new BlockMetalFence("fence_nickel");
        constantanFence = new BlockMetalFence("fence_constantan");
        electrumFence = new BlockMetalFence("fence_electrum");
        uraniumFence = new BlockMetalFence("fence_uranium");
        woodPost = new BlockPost(Material.field_151575_d, EnumPostMaterial.WOOD);
        ironPost = IPOStuff.createMetalPost(EnumPostMaterial.IRON);
        goldPost = IPOStuff.createMetalPost(EnumPostMaterial.GOLD);
        copperPost = IPOStuff.createMetalPost(EnumPostMaterial.COPPER);
        leadPost = IPOStuff.createMetalPost(EnumPostMaterial.LEAD);
        silverPost = IPOStuff.createMetalPost(EnumPostMaterial.SILVER);
        nickelPost = IPOStuff.createMetalPost(EnumPostMaterial.NICKEL);
        constantanPost = IPOStuff.createMetalPost(EnumPostMaterial.CONSTANTAN);
        electrumPost = IPOStuff.createMetalPost(EnumPostMaterial.ELECTRUM);
        uraniumPost = IPOStuff.createMetalPost(EnumPostMaterial.URANIUM);
        netherPost = IPOStuff.createMetalPost(EnumPostMaterial.NETHERBRICK);
        aluPost = IPOStuff.createMetalPost(EnumPostMaterial.ALUMINIUM);
        steelPost = IPOStuff.createMetalPost(EnumPostMaterial.STEEL);
        stickGold = new IPOItemBase("stick_gold");
        stickCopper = new IPOItemBase("stick_copper");
        stickLead = new IPOItemBase("stick_lead");
        stickSilver = new IPOItemBase("stick_silver");
        stickNickel = new IPOItemBase("stick_nickel");
        stickConstantan = new IPOItemBase("stick_constantan");
        stickElectrum = new IPOItemBase("stick_electrum");
        stickUranium = new IPOItemBase("stick_uranium");
    }
}

