/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.network.packet;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.component.OpenGlassesHostComponent;
import com.bymarcin.openglasses.item.GlassesNBT;
import com.bymarcin.openglasses.item.OpenGlassesNBT.OpenGlassesHostsNBT;
import com.bymarcin.openglasses.item.OpenGlassesNBT.OpenGlassesNotificationsNBT;
import com.bymarcin.openglasses.item.upgrades.UpgradeGeolyzer;
import com.bymarcin.openglasses.item.upgrades.UpgradeNightvision;
import com.bymarcin.openglasses.item.upgrades.UpgradeThermalVision;
import com.bymarcin.openglasses.network.Packet;
import com.bymarcin.openglasses.surface.OCServerSurface;
import com.bymarcin.openglasses.utils.PlayerStatsOC;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GlassesEventPacket
extends Packet<GlassesEventPacket, IMessage> {
    private EventType eventType;
    private UUID hostUUID;
    private BlockPos eventPos;
    private EnumFacing facing;
    private ItemStack glasses = ItemStack.field_190927_a;
    private int x;
    private int y;
    private double mb;

    public GlassesEventPacket(UUID host, EventType eventType) {
        this.eventType = eventType;
        this.hostUUID = host;
    }

    public GlassesEventPacket(UUID host, EventType eventType, BlockPos eventPosition, EnumFacing face) {
        this(host, eventType);
        this.eventPos = eventPosition;
        this.facing = face;
    }

    public GlassesEventPacket(UUID host, EventType eventType, int x, int y, int mb) {
        this(host, eventType);
        this.x = x;
        this.y = y;
        this.mb = mb;
    }

    public GlassesEventPacket() {
    }

    @Override
    protected void read() throws IOException {
        if (this.readBoolean()) {
            this.hostUUID = this.readUUID();
        }
        this.eventType = EventType.values()[this.readInt()];
        switch (this.eventType) {
            case INTERACT_OVERLAY: 
            case GLASSES_SCREEN_SIZE: {
                this.x = this.readInt();
                this.y = this.readInt();
                this.mb = this.readDouble();
                return;
            }
            case INTERACT_WORLD_BLOCK_LEFT: 
            case INTERACT_WORLD_BLOCK_RIGHT: {
                this.eventPos = new BlockPos(this.readVec3i());
                this.facing = EnumFacing.values()[this.readInt()];
                return;
            }
        }
    }

    @Override
    protected void write() throws IOException {
        this.writeBoolean(this.hostUUID != null);
        if (this.hostUUID != null) {
            this.writeUUID(this.hostUUID);
        }
        this.writeInt(this.eventType.ordinal());
        switch (this.eventType) {
            case INTERACT_OVERLAY: 
            case GLASSES_SCREEN_SIZE: {
                this.writeInt(this.x);
                this.writeInt(this.y);
                this.writeDouble(this.mb);
                break;
            }
            case INTERACT_WORLD_BLOCK_LEFT: 
            case INTERACT_WORLD_BLOCK_RIGHT: {
                this.writeVec3i((Vec3i)this.eventPos);
                this.writeInt(this.facing.ordinal());
            }
        }
    }

    @Override
    protected IMessage executeOnClient() {
        return null;
    }

    private ItemStack getGlasses(EntityPlayer player) {
        return this.glasses.func_190926_b() ? (this.glasses = OpenGlasses.getGlassesStack(player)) : this.glasses;
    }

    @Override
    protected IMessage executeOnServer(EntityPlayerMP playerMP) {
        Vec3d look = new Vec3d(0.0, 0.0, 0.0);
        double eyeHeight = 0.0;
        double playerRotation = 0.0;
        double playerPitch = 0.0;
        if (playerMP == null) {
            return null;
        }
        Vec3d playerPos = new Vec3d(playerMP.field_70165_t, playerMP.field_70163_u, playerMP.field_70161_v);
        if (UpgradeGeolyzer.hasUpgrade(this.getGlasses((EntityPlayer)playerMP))) {
            Vec3d lookVector = playerMP.func_70040_Z();
            look = new Vec3d((double)Math.round(lookVector.field_72450_a * 1000.0) / 1000.0, (double)Math.round(lookVector.field_72448_b * 1000.0) / 1000.0, (double)Math.round(lookVector.field_72449_c * 1000.0) / 1000.0);
            eyeHeight = (double)Math.round(playerMP.func_70047_e() * 1000.0f) / 1000.0;
            playerRotation = (double)Math.round(playerMP.field_70177_z * 1000.0f) / 1000.0;
            playerPitch = (double)Math.round(playerMP.field_70125_A * 1000.0f) / 1000.0;
        }
        switch (this.eventType) {
            case INTERACT_WORLD_BLOCK_LEFT: 
            case INTERACT_WORLD_BLOCK_RIGHT: {
                OpenGlassesHostComponent host = OCServerSurface.getHost(this.hostUUID);
                if (host != null) {
                    host.sendInteractEventWorldBlock(this.eventType.name(), playerMP.func_70005_c_(), playerPos, look, eyeHeight, this.eventPos, this.facing, playerRotation, playerPitch);
                }
                return null;
            }
            case INTERACT_WORLD_LEFT: 
            case INTERACT_WORLD_RIGHT: {
                OpenGlassesHostComponent host = OCServerSurface.getHost(this.hostUUID);
                if (host != null) {
                    host.sendInteractEventWorld(this.eventType.name(), playerMP.func_70005_c_(), playerPos, look, eyeHeight, playerRotation, playerPitch);
                }
                return null;
            }
            case INTERACT_OVERLAY: {
                OpenGlassesHostComponent host = OCServerSurface.getHost(this.hostUUID);
                if (host != null) {
                    host.sendInteractEventOverlay(this.eventType.name(), playerMP.func_70005_c_(), this.mb, this.x, this.y, look, eyeHeight, playerRotation, playerPitch);
                }
                return null;
            }
            case GLASSES_SCREEN_SIZE: {
                PlayerStatsOC stats = (PlayerStatsOC)((Object)OCServerSurface.instances.playerStats.get(playerMP.func_110124_au()));
                OpenGlassesHostComponent host = OCServerSurface.getHost(this.hostUUID);
                if (stats != null) {
                    stats.setScreen(this.x, this.y, this.mb);
                }
                if (host != null) {
                    host.sendChangeSizeEvent(this.eventType.name(), playerMP.func_70005_c_(), this.x, this.y, this.mb);
                }
                return null;
            }
            case TOGGLE_NIGHTVISION: {
                UpgradeNightvision.toggleNightvisionMode((EntityPlayer)playerMP);
                return null;
            }
            case TOGGLE_INFRARED: {
                UpgradeThermalVision.toggleInfraredMode((EntityPlayer)playerMP);
                return null;
            }
            case ACTIVATE_OVERLAY: 
            case DEACTIVATE_OVERLAY: {
                PlayerStatsOC stats = OCServerSurface.getStats(playerMP);
                if (stats != null) {
                    if (this.eventType.equals((Object)EventType.ACTIVATE_OVERLAY)) {
                        stats.conditions.setOverlay(true);
                    }
                    if (this.eventType.equals((Object)EventType.DEACTIVATE_OVERLAY)) {
                        stats.conditions.setOverlay(false);
                    }
                }
                return null;
            }
            case ACCEPT_LINK: 
            case DENY_LINK: {
                ItemStack glasses = this.getGlasses((EntityPlayer)playerMP);
                if (!glasses.func_190926_b()) {
                    for (NBTTagCompound notification : OpenGlassesNotificationsNBT.getNotifications(this.getGlasses((EntityPlayer)playerMP))) {
                        switch (OpenGlassesNotificationsNBT.NotifiactionType.values()[notification.func_74762_e("type")]) {
                            case LINKREQUEST: {
                                if (!notification.func_186857_a("host").equals(this.hostUUID)) break;
                                if (this.eventType.equals((Object)EventType.ACCEPT_LINK)) {
                                    OpenGlassesHostsNBT.link(glasses, this.hostUUID, (EntityPlayer)playerMP);
                                }
                                OpenGlassesNotificationsNBT.removeLinkRequest(glasses, this.hostUUID);
                                GlassesNBT.syncStackNBT(glasses, playerMP);
                                OCServerSurface.instance().subscribePlayer(playerMP, this.hostUUID);
                                return null;
                            }
                        }
                    }
                }
                return null;
            }
            case CLEAR_LINK: {
                OpenGlassesHostsNBT.unlink(this.hostUUID, this.getGlasses((EntityPlayer)playerMP), (EntityPlayer)playerMP);
                return null;
            }
            case ENABLE_NOTIFICATIONS: 
            case DISABLE_NOTIFICATIONS: {
                GlassesNBT.setConfigFlag("nopopups", this.eventType.equals((Object)EventType.ENABLE_NOTIFICATIONS), this.getGlasses((EntityPlayer)playerMP), playerMP);
                return null;
            }
            case ENABLE_WORLD_RENDER: 
            case DISABLE_WORLD_RENDER: 
            case ENABLE_OVERLAY_RENDER: 
            case DISABLE_OVERLAY_RENDER: 
            case DISABLE_OVERLAY_EVENTS: 
            case DISABLE_WORLD_EVENTS: 
            case ENABLE_OVERLAY_EVENTS: 
            case ENABLE_WORLD_EVENTS: {
                ItemStack glasses = this.getGlasses((EntityPlayer)playerMP);
                NBTTagCompound hostNBT = OpenGlassesHostsNBT.getHostFromNBT(this.hostUUID, glasses);
                switch (this.eventType) {
                    case ENABLE_WORLD_RENDER: {
                        hostNBT.func_82580_o("noWorld");
                        break;
                    }
                    case DISABLE_WORLD_RENDER: {
                        hostNBT.func_74757_a("noWorld", true);
                        break;
                    }
                    case ENABLE_OVERLAY_RENDER: {
                        hostNBT.func_82580_o("noOverlay");
                        break;
                    }
                    case DISABLE_OVERLAY_RENDER: {
                        hostNBT.func_74757_a("noOverlay", true);
                        break;
                    }
                    case DISABLE_OVERLAY_EVENTS: {
                        hostNBT.func_74757_a("noOverlayEvents", true);
                        break;
                    }
                    case DISABLE_WORLD_EVENTS: {
                        hostNBT.func_74757_a("noWorldEvents", true);
                        break;
                    }
                    case ENABLE_OVERLAY_EVENTS: {
                        hostNBT.func_82580_o("noOverlayEvents");
                        break;
                    }
                    case ENABLE_WORLD_EVENTS: {
                        hostNBT.func_82580_o("noWorldEvents");
                    }
                }
                OpenGlassesHostsNBT.writeHostToNBT(glasses, hostNBT);
                GlassesNBT.syncStackNBT(glasses, playerMP);
                return null;
            }
        }
        return null;
    }

    public static enum EventType {
        TOGGLE_NIGHTVISION,
        TOGGLE_INFRARED,
        ACTIVATE_OVERLAY,
        DEACTIVATE_OVERLAY,
        INTERACT_WORLD_RIGHT,
        INTERACT_WORLD_LEFT,
        INTERACT_WORLD_BLOCK_RIGHT,
        INTERACT_WORLD_BLOCK_LEFT,
        INTERACT_OVERLAY,
        GLASSES_SCREEN_SIZE,
        ACCEPT_LINK,
        DENY_LINK,
        CLEAR_LINK,
        ENABLE_NOTIFICATIONS,
        DISABLE_NOTIFICATIONS,
        ENABLE_WORLD_RENDER,
        DISABLE_WORLD_RENDER,
        ENABLE_OVERLAY_RENDER,
        DISABLE_OVERLAY_RENDER,
        DISABLE_WORLD_EVENTS,
        ENABLE_WORLD_EVENTS,
        DISABLE_OVERLAY_EVENTS,
        ENABLE_OVERLAY_EVENTS;

    }
}

