/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.component;

import ben_mkiv.rendertoolkit.common.widgets.Widget;
import ben_mkiv.rendertoolkit.network.messages.WidgetUpdatePacket;
import com.bymarcin.openglasses.component.OpenGlassesHostComponent;
import com.bymarcin.openglasses.component.WidgetList;
import com.bymarcin.openglasses.surface.OCServerSurface;

public class WidgetServer
extends WidgetList {
    private OpenGlassesHostComponent host;

    public WidgetServer(OpenGlassesHostComponent hostComponent) {
        this.host = hostComponent;
    }

    @Override
    public int add(Widget widget) {
        int id = super.add(widget);
        OCServerSurface.instances.sendToUUID(new WidgetUpdatePacket(this.host.getUUID(), id, widget), this.host.getUUID());
        return id;
    }

    public boolean remove(int id) {
        if (super.removeWidget(id)) {
            OCServerSurface.instances.sendToUUID(new WidgetUpdatePacket(this.host.getUUID(), id), this.host.getUUID());
            return true;
        }
        return false;
    }

    public void update(int widgetID) {
        Widget w = (Widget)this.list.get(widgetID);
        if (w == null) {
            return;
        }
        OCServerSurface.instances.sendToUUID(new WidgetUpdatePacket(this.host.getUUID(), widgetID, w), this.host.getUUID());
    }

    public void clear() {
        this.list.clear();
        if (this.host != null) {
            OCServerSurface.instances.sendToUUID(new WidgetUpdatePacket(this.host.getUUID()), this.host.getUUID());
        }
    }

    public int size() {
        return this.list.size();
    }
}

