/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumicenergistics.util.ItemHandlerUtil;

public class ForgeUtil {
    public static boolean isClient() {
        return ForgeUtil.getSide().isClient();
    }

    public static boolean isServer() {
        return ForgeUtil.getSide().isServer();
    }

    public static Side getSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    public static <K extends IForgeRegistryEntry<K>> IForgeRegistry<K> getRegistry(Class<K> reg) {
        return GameRegistry.findRegistry(reg);
    }

    public static <K extends IForgeRegistryEntry<K>> IForgeRegistryEntry getRegistryEntry(Class<K> reg, ResourceLocation resourceLocation) {
        return ForgeUtil.getRegistry(reg).getValue(resourceLocation);
    }

    public static ItemStack addStackToPlayerInventory(EntityPlayer player, ItemStack stack, boolean simulate) {
        if (stack == null || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return ItemHandlerUtil.insert((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), stack, simulate);
    }

    public static boolean areItemStacksEqual(ItemStack a, ItemStack b) {
        return a != null && b != null && ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) && ForgeUtil.areNBTTagsEqual((NBTBase)a.func_77978_p(), (NBTBase)b.func_77978_p());
    }

    public static boolean areNBTTagsEqual(NBTBase a, NBTBase b) {
        return a == b || a.func_82582_d() && b.func_82582_d() || a.func_82582_d() != b.func_82582_d() || a.equals((Object)b);
    }

    public static NBTTagList mergeTagLists(NBTTagList a, NBTTagList b) {
        b.forEach(arg_0 -> ((NBTTagList)a).func_74742_a(arg_0));
        return a;
    }

    public static List<NBTBase> toArrayList(NBTTagList tags) {
        return ForgeUtil.toList(tags, new ArrayList<NBTBase>());
    }

    public static List<NBTBase> toList(NBTTagList tags, List<NBTBase> list) {
        tags.forEach(list::add);
        return list;
    }
}

