/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.inventory;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class PlayerSlot {
    private final int slot;
    private final EnumInvCategory category;

    public PlayerSlot(int slot, EnumInvCategory category) {
        this.slot = slot;
        this.category = category;
    }

    public void toBuff(ByteBuf buf) {
        buf.writeByte(this.category.getIndex());
        buf.writeByte(this.slot);
    }

    public static PlayerSlot fromBuff(ByteBuf buf) {
        EnumInvCategory category = EnumInvCategory.fromIndex(buf.readByte());
        byte slot = buf.readByte();
        return new PlayerSlot(slot, category);
    }

    public int getSlotIndex() {
        return this.slot;
    }

    public int getCatIndex() {
        return this.category.getIndex();
    }

    public static PlayerSlot fromIndexes(int slotIndex, int catIndex) {
        EnumInvCategory category = EnumInvCategory.fromIndex(catIndex);
        return new PlayerSlot(slotIndex, category);
    }

    public String toString() {
        return this.category.getIndex() + ":" + this.slot;
    }

    public static PlayerSlot fromString(String slot) {
        try {
            return new PlayerSlot(Integer.parseInt(slot.substring(slot.indexOf(":") + 1)), EnumInvCategory.fromIndex(Integer.parseInt(slot.substring(0, slot.indexOf(":")))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new PlayerSlot(0, EnumInvCategory.MAIN);
        }
    }

    public void setStackInSlot(EntityPlayer player, ItemStack stack) {
        if (this.category == EnumInvCategory.ARMOR) {
            if (this.slot < 0 || this.slot >= player.field_71071_by.field_70460_b.size()) {
                return;
            }
            player.field_71071_by.field_70460_b.set(this.slot, (Object)stack);
        } else if (this.category == EnumInvCategory.MAIN) {
            if (this.slot < 0 || this.slot >= player.field_71071_by.field_70462_a.size()) {
                return;
            }
            player.field_71071_by.field_70462_a.set(this.slot, (Object)stack);
        } else if (this.category == EnumInvCategory.OFF_HAND) {
            if (this.slot < 0 || this.slot >= player.field_71071_by.field_184439_c.size()) {
                return;
            }
            player.field_71071_by.field_184439_c.set(this.slot, (Object)stack);
        }
    }

    public ItemStack getStackInSlot(EntityPlayer player) {
        if (this.category == EnumInvCategory.ARMOR) {
            return (ItemStack)player.field_71071_by.field_70460_b.get(this.slot);
        }
        if (this.category == EnumInvCategory.MAIN) {
            return (ItemStack)player.field_71071_by.field_70462_a.get(this.slot);
        }
        if (this.category == EnumInvCategory.OFF_HAND) {
            return (ItemStack)player.field_71071_by.field_184439_c.get(this.slot);
        }
        return ItemStack.field_190927_a;
    }

    public static PlayerSlot getHand(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            return new PlayerSlot(player.field_71071_by.field_70461_c, EnumInvCategory.MAIN);
        }
        return new PlayerSlot(0, EnumInvCategory.OFF_HAND);
    }

    public static enum EnumInvCategory {
        MAIN(0),
        ARMOR(1),
        OFF_HAND(2);

        private int index;
        private static EnumInvCategory[] indexMap;

        private EnumInvCategory(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static EnumInvCategory fromIndex(int index) {
            if (index > 2 || index < 0) {
                return indexMap[0];
            }
            return indexMap[index];
        }

        static {
            indexMap = new EnumInvCategory[3];
            EnumInvCategory.indexMap[0] = MAIN;
            EnumInvCategory.indexMap[1] = ARMOR;
            EnumInvCategory.indexMap[2] = OFF_HAND;
        }
    }
}

