/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.init.ModNetworking;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.inventory.slot.SlotDankNullDock;
import p455w0rd.danknull.inventory.slot.SlotHotbar;
import p455w0rd.danknull.network.PacketSyncDankNullDock;
import p455w0rd.danknull.util.DankNullUtils;

public class ContainerDankNullDock
extends Container {
    private final TileDankNullDock tile;

    public ContainerDankNullDock(EntityPlayer player, TileDankNullDock tile) {
        int i;
        this.tile = tile;
        InventoryPlayer playerInv = player.field_71071_by;
        ItemStack dankNull = tile.getDankNull();
        int lockedSlot = -1;
        int numRows = DankNullUtils.getMeta(dankNull) + 1;
        if (DankNullUtils.isCreativeDankNull(dankNull)) {
            --numRows;
        }
        for (i = 0; i < playerInv.func_70302_i_(); ++i) {
            ItemStack currStack = playerInv.func_70301_a(i);
            if (currStack.func_190926_b() || currStack != dankNull) continue;
            lockedSlot = i;
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotHotbar((IInventory)playerInv, i, i * 20 + 9 + i, 90 + numRows - 1 + numRows * 20 + 6, lockedSlot == i));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, j * 20 + 9 + j, 149 + numRows - 1 + i - (6 - numRows) * 20 + i * 20));
            }
        }
        for (i = 0; i < numRows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotDankNullDock(this, j + i * 9, j * 20 + 9 + j, 19 + i + i * 20));
            }
        }
    }

    public TileDankNullDock getTile() {
        return this.tile;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return DankNullUtils.getNewDankNullInventory(this.getDankNull()).isValid();
    }

    public ItemStack getDankNull() {
        return this.getTile().getDankNull();
    }

    public boolean addStack(InventoryDankNull inventory, ItemStack stack) {
        boolean ret = false;
        if (DankNullUtils.isDankNull(stack)) {
            return false;
        }
        if (DankNullUtils.isFiltered(inventory, stack)) {
            ret = DankNullUtils.addFilteredStackToDankNull(inventory, stack);
        } else {
            ret = DankNullUtils.addFilteredStackToDankNull(inventory, stack);
            if (!ret && DankNullUtils.getNextAvailableSlot(inventory) >= 0) {
                int nextSlot = DankNullUtils.getNextAvailableSlot(inventory);
                inventory.func_70299_a(nextSlot, stack);
                ((Slot)this.field_75151_b.get(36 + nextSlot)).func_75215_d(stack);
                ret = true;
            }
            if (DankNullUtils.getSelectedStackIndex(inventory) == -1) {
                DankNullUtils.setSelectedIndexApplicable(inventory);
            }
        }
        DankNullUtils.reArrangeStacks(inventory);
        return ret;
    }

    private boolean isDankNullSlot(Slot slot) {
        return slot instanceof SlotDankNullDock;
    }

    private boolean isInHotbar(int index) {
        return index >= 0 && index <= 8;
    }

    private boolean isInInventory(int index) {
        return index >= 9 && index <= 36;
    }

    public void func_75142_b() {
    }

    public Slot func_75139_a(int slotId) {
        if (slotId < this.field_75151_b.size() && slotId >= 0) {
            return (Slot)this.field_75151_b.get(slotId);
        }
        return null;
    }

    public ItemStack func_184996_a(int index, int dragType, ClickType clickType, EntityPlayer player) {
        Slot s = this.func_75139_a(index);
        if (index < 36 && clickType != ClickType.QUICK_MOVE || clickType == ClickType.CLONE) {
            return super.func_184996_a(index, dragType, clickType, player);
        }
        if (clickType == ClickType.QUICK_MOVE) {
            InventoryDankNull tmpInv = DankNullUtils.getNewDankNullInventory(this.getDankNull());
            this.shiftClick(tmpInv, index, player);
            return ItemStack.field_190927_a;
        }
        InventoryDankNull tmpInv = DankNullUtils.getNewDankNullInventory(this.getDankNull());
        InventoryPlayer inventoryplayer = player.field_71071_by;
        ItemStack heldStack = inventoryplayer.func_70445_o();
        if (s instanceof SlotDankNullDock && clickType == ClickType.PICKUP) {
            if (DankNullUtils.isDankNull(heldStack)) {
                return ItemStack.field_190927_a;
            }
            ItemStack thisStack = s.func_75211_c();
            if (!thisStack.func_190926_b() && DankNullUtils.isDankNull(thisStack)) {
                return ItemStack.field_190927_a;
            }
            if (!heldStack.func_190926_b()) {
                if (!(player instanceof EntityPlayerMP)) {
                    if (this.addStack(tmpInv, heldStack)) {
                        DankNullUtils.setSelectedIndexApplicable(tmpInv);
                        tmpInv.func_70296_d();
                    }
                    this.sync(this.getDankNull());
                }
                if (player instanceof EntityPlayerMP) {
                    player.field_71071_by.func_70299_a(index, ItemStack.field_190927_a);
                    player.field_71071_by.func_70296_d();
                }
                inventoryplayer.func_70437_b(ItemStack.field_190927_a);
            } else if (!thisStack.func_190926_b()) {
                ItemStack newStack = thisStack.func_77946_l();
                int realMaxStackSize = newStack.func_77976_d();
                newStack.func_190920_e(realMaxStackSize);
                if (!(player instanceof EntityPlayerMP)) {
                    DankNullUtils.decrDankNullStackSize(tmpInv, thisStack, realMaxStackSize);
                }
                inventoryplayer.func_70437_b(newStack);
            }
        }
        return ItemStack.field_190927_a;
    }

    private void sync(ItemStack dankNull) {
        ModNetworking.getInstance().sendToServer((IMessage)new PacketSyncDankNullDock(this.getTile(), dankNull));
    }

    private ItemStack shiftClick(InventoryDankNull inventory, int index, EntityPlayer player) {
        Slot clickSlot = (Slot)this.field_75151_b.get(index);
        if (clickSlot.func_75216_d()) {
            if (!this.isDankNullSlot(clickSlot)) {
                if (!(player instanceof EntityPlayerMP)) {
                    if (this.addStack(inventory, clickSlot.func_75211_c())) {
                        clickSlot.func_75215_d(ItemStack.field_190927_a);
                        DankNullUtils.setSelectedIndexApplicable(inventory);
                        inventory.func_70296_d();
                    } else {
                        this.moveStackWithinInventory(clickSlot.func_75211_c(), index);
                    }
                    this.sync(this.getDankNull());
                }
                if (player instanceof EntityPlayerMP) {
                    player.field_71071_by.func_70299_a(index, ItemStack.field_190927_a);
                    player.field_71071_by.func_70296_d();
                }
                return ItemStack.field_190927_a;
            }
            ItemStack newStack = clickSlot.func_75211_c().func_77946_l();
            int realMaxStackSize = newStack.func_77976_d();
            int currentStackSize = newStack.func_190916_E();
            if (!DankNullUtils.isCreativeDankNull(this.getDankNull()) && currentStackSize > realMaxStackSize) {
                newStack.func_190920_e(realMaxStackSize);
                if (this.moveStackToInventory(newStack) && !(player instanceof EntityPlayerMP)) {
                    DankNullUtils.decrDankNullStackSize(inventory, clickSlot.func_75211_c(), realMaxStackSize);
                    this.sync(inventory.getDankNull());
                }
                if (player instanceof EntityPlayerMP) {
                    player.field_71071_by.func_70299_a(index, newStack);
                    player.field_71071_by.func_70296_d();
                }
            } else {
                newStack.func_190920_e(DankNullUtils.isCreativeDankNull(this.getDankNull()) ? newStack.func_77976_d() : currentStackSize);
                if (!(player instanceof EntityPlayerMP)) {
                    if (this.moveStackToInventory(newStack) && !(player instanceof EntityPlayerMP)) {
                        DankNullUtils.decrDankNullStackSize(inventory, clickSlot.func_75211_c(), currentStackSize);
                        if (DankNullUtils.isCreativeDankNull(this.getDankNull()) && !DankNullUtils.isCreativeDankNullLocked(this.getDankNull())) {
                            clickSlot.func_75215_d(ItemStack.field_190927_a);
                        }
                    }
                    this.sync(this.getDankNull());
                }
                if (player instanceof EntityPlayerMP) {
                    player.field_71071_by.func_70299_a(index, newStack);
                    player.field_71071_by.func_70296_d();
                }
                DankNullUtils.reArrangeStacks(inventory);
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        return ItemStack.field_190927_a;
    }

    private boolean moveStackWithinInventory(ItemStack itemStackIn, int index) {
        block5: {
            block4: {
                if (!this.isInHotbar(index)) break block4;
                if (this.func_75135_a(itemStackIn, 9, 37, false)) {
                    return true;
                }
                for (int i = 9; i <= 36; ++i) {
                    Slot possiblyOpenSlot = (Slot)this.field_75151_b.get(i);
                    if (possiblyOpenSlot.func_75216_d()) continue;
                    possiblyOpenSlot.func_75215_d(itemStackIn);
                    ((Slot)this.field_75151_b.get(index)).func_75215_d(ItemStack.field_190927_a);
                    return true;
                }
                break block5;
            }
            if (!this.isInInventory(index)) break block5;
            if (this.func_75135_a(itemStackIn, 0, 9, false)) {
                return true;
            }
            for (int i = 0; i <= 8; ++i) {
                Slot possiblyOpenSlot = (Slot)this.field_75151_b.get(i);
                if (possiblyOpenSlot.func_75216_d()) continue;
                possiblyOpenSlot.func_75215_d(itemStackIn);
                ((Slot)this.field_75151_b.get(index)).func_75215_d(ItemStack.field_190927_a);
                return true;
            }
        }
        return false;
    }

    private boolean moveStackToInventory(ItemStack itemStackIn) {
        for (int i = 0; i < 36; ++i) {
            Slot possiblyOpenSlot = (Slot)this.field_75151_b.get(i);
            if (possiblyOpenSlot.func_75216_d()) continue;
            possiblyOpenSlot.func_75215_d(itemStackIn);
            return true;
        }
        return false;
    }
}

