/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.ie;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TwilightForestMod;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.model.item.ShaderGrabbagStackRenderer;
import twilightforest.compat.ie.IEShaderRegister;
import twilightforest.compat.ie.ItemTFShader;
import twilightforest.item.TFItems;

public class ItemTFShaderGrabbag
extends Item
implements ModelRegisterCallback {
    private static final String TAG_SHADER = "shader_rarity";
    public static final ItemTFShaderGrabbag shader_bag = new ItemTFShaderGrabbag();

    public ItemTFShaderGrabbag() {
        this.func_77627_a(true);
        this.func_77637_a(TFItems.creativeTab);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TFItems.creativeTab) {
            for (int i = ShaderRegistry.sortedRarityMap.size() - 1; i >= 0; --i) {
                ItemStack stack = new ItemStack((Item)this, 1, 0);
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74778_a(TAG_SHADER, ((EnumRarity)ShaderRegistry.sortedRarityMap.get(i)).toString());
                stack.func_77982_d(compound);
                items.add((Object)stack);
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            stack.func_77982_d(new NBTTagCompound());
            compound = stack.func_77978_p();
        }
        String rarityString = compound.func_74779_i(TAG_SHADER);
        for (EnumRarity rarity : EnumRarity.values()) {
            if (!rarity.toString().equalsIgnoreCase(rarityString)) continue;
            return rarity;
        }
        return EnumRarity.COMMON;
    }

    public String func_77653_i(ItemStack stack) {
        String name = this.func_77613_e((ItemStack)stack).field_77934_f;
        return I18n.func_74837_a((String)this.func_77667_c(stack), (Object[])new Object[]{name});
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            EnumRarity rarity = stack.func_77953_t();
            if (rarity == TwilightForestMod.getRarity()) {
                List<ShaderRegistry.ShaderRegistryEntry> list = IEShaderRegister.getAllNonbossShaders();
                return ItemTFShaderGrabbag.randomShader(list.get((int)playerIn.func_70681_au().nextInt((int)list.size())).name, stack, playerIn);
            }
            if (ShaderRegistry.totalWeight.containsKey(rarity)) {
                return ItemTFShaderGrabbag.randomShader(ShaderRegistry.getRandomShader((String)playerIn.func_70005_c_(), (Random)playerIn.func_70681_au(), (EnumRarity)rarity, (boolean)true), stack, playerIn);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private static ActionResult<ItemStack> randomShader(@Nullable String shader, ItemStack stack, EntityPlayer playerIn) {
        if (shader == null || shader.isEmpty()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        ItemStack shaderItem = new ItemStack((Item)ItemTFShader.shader);
        NBTTagCompound compound = shaderItem.func_77978_p();
        if (compound == null) {
            shaderItem.func_77982_d(new NBTTagCompound());
            compound = shaderItem.func_77978_p();
        }
        compound.func_74778_a("shader_type", shader);
        stack.func_190918_g(1);
        if (stack.func_190916_E() <= 0) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)shaderItem);
        }
        if (!playerIn.field_71071_by.func_70441_a(shaderItem)) {
            playerIn.func_146097_a(shaderItem, false, true);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("twilightforest:grabbag_tesr", "inventory"));
        ShaderGrabbagStackRenderer tesr = new ShaderGrabbagStackRenderer();
        ClientRegistry.bindTileEntitySpecialRenderer(ShaderGrabbagStackRenderer.DummyTile.class, (TileEntitySpecialRenderer)tesr);
        ClientEventHandler.dummyModel = tesr.baked;
        ForgeHooksClient.registerTESRItemStack((Item)this, (int)0, ShaderGrabbagStackRenderer.DummyTile.class);
    }

    public static final class ClientEventHandler {
        static ShaderGrabbagStackRenderer.BakedModel dummyModel;

        @SubscribeEvent
        public static void onModelBake(ModelBakeEvent event) {
            TwilightForestMod.LOGGER.debug("Registering fancy item model for TF Shader Grabbag!");
            event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("twilightforest:grabbag_tesr", "inventory"), (Object)dummyModel);
        }
    }
}

