/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.network.packet;

import com.bymarcin.openglasses.component.OpenGlassesHostComponent;
import com.bymarcin.openglasses.network.Packet;
import com.bymarcin.openglasses.surface.OCClientSurface;
import com.bymarcin.openglasses.tileentity.OpenGlassesTerminalTileEntity;
import com.bymarcin.openglasses.utils.OpenGlassesHostClient;
import java.io.IOException;
import java.util.UUID;
import li.cil.oc.api.internal.Case;
import li.cil.oc.api.internal.Microcontroller;
import li.cil.oc.api.internal.Robot;
import li.cil.oc.api.internal.Tablet;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.common.entity.Drone;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HostInfoPacket
extends Packet<HostInfoPacket, IMessage> {
    private Vec3d position;
    private int entityID = -1;
    private UUID hostUUID;
    private UUID entityUUID;
    private int entityDimension;
    private String name;
    private boolean renderAbsolute = false;
    private HostType hostType = HostType.TERMINAL;

    public HostInfoPacket(OpenGlassesHostComponent host) {
        this.name = host.getName();
        this.hostUUID = host.getUUID();
        this.renderAbsolute = host.renderAbsolute();
        EnvironmentHost realHost = host.getHost();
        this.position = host.getRenderPosition();
        if (realHost instanceof OpenGlassesTerminalTileEntity) {
            this.hostType = HostType.TERMINAL;
        } else if (realHost instanceof Robot) {
            this.hostType = HostType.ROBOT;
        } else if (realHost instanceof Case) {
            this.hostType = HostType.CASE;
        } else if (realHost instanceof Microcontroller) {
            this.hostType = HostType.MICROCONTROLLER;
        } else if (realHost instanceof Drone) {
            Drone drone = (Drone)realHost;
            this.entityID = drone.func_145782_y();
            this.entityUUID = drone.func_110124_au();
            this.entityDimension = drone.func_130014_f_().field_73011_w.getDimension();
            this.hostType = HostType.DRONE;
        } else if (realHost instanceof Tablet) {
            Tablet tablet = (Tablet)realHost;
            this.entityID = tablet.player().func_145782_y();
            this.entityUUID = tablet.player().func_110124_au();
            this.entityDimension = tablet.player().func_130014_f_().field_73011_w.getDimension();
            this.hostType = HostType.TABLET;
        }
    }

    public HostInfoPacket() {
    }

    @Override
    protected void read() throws IOException {
        this.hostUUID = this.readUUID();
        this.name = this.readString();
        this.renderAbsolute = this.readBoolean();
        this.hostType = HostType.values()[this.readInt()];
        this.position = this.readVec3d();
        switch (this.hostType) {
            case ROBOT: {
                this.entityDimension = this.readInt();
                break;
            }
            case DRONE: 
            case TABLET: {
                this.entityID = this.readInt();
                this.entityDimension = this.readInt();
                this.entityUUID = this.readUUID();
                break;
            }
        }
    }

    @Override
    protected void write() throws IOException {
        this.writeUUID(this.hostUUID);
        this.writeString(this.name);
        this.writeBoolean(this.renderAbsolute);
        this.writeInt(this.hostType.ordinal());
        this.writeVec3d(this.position);
        switch (this.hostType) {
            case ROBOT: {
                this.writeInt(this.entityDimension);
                break;
            }
            case DRONE: 
            case TABLET: {
                this.writeInt(this.entityID);
                this.writeInt(this.entityDimension);
                this.writeUUID(this.entityUUID);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IMessage executeOnClient() {
        OpenGlassesHostClient clientHost = OCClientSurface.instance().getHost(this.hostUUID);
        clientHost.terminalName = this.name;
        clientHost.renderEntity = null;
        clientHost.absoluteRenderPosition = this.renderAbsolute;
        clientHost.hostType = this.hostType;
        clientHost.renderPosition = this.position;
        switch (clientHost.hostType) {
            case ROBOT: {
                clientHost.renderEntityDimension = this.entityDimension;
                clientHost.renderEntityRobot = clientHost.getRobotEntity();
                break;
            }
            case DRONE: 
            case TABLET: {
                clientHost.renderEntityID = this.entityID;
                clientHost.renderEntityDimension = this.entityDimension;
                clientHost.renderEntityUUID = this.entityUUID;
                break;
            }
            case MICROCONTROLLER: 
            case CASE: {
                clientHost.renderPosition = clientHost.renderPosition.func_178788_d(OpenGlassesHostClient.renderOffsetRobotCaseMicroController);
            }
        }
        return null;
    }

    @Override
    protected IMessage executeOnServer(EntityPlayerMP player) {
        return null;
    }

    public static enum HostType {
        TERMINAL,
        ROBOT,
        DRONE,
        TABLET,
        CASE,
        MICROCONTROLLER;

    }
}

