/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.page.security;

import engineers.workshop.client.page.security.PermissionNode;
import engineers.workshop.client.page.security.PlayerSecurity;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Security {
    private HashMap<String, PlayerSecurity> psecs = new HashMap();

    public String getOwner() {
        for (String i : this.psecs.keySet()) {
            if (this.psecs.get(i).getPermission(PermissionNode.SECURITY_EDITING_LEVEL) != 3) continue;
            return i;
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("players")) {
            NBTTagList players = tag.func_150295_c("players", 9);
            for (int i = 0; i < players.func_74745_c(); ++i) {
                NBTTagCompound player = players.func_150305_b(i);
                PlayerSecurity psec = new PlayerSecurity(player.func_74779_i("name"));
                for (PermissionNode node : PermissionNode.values()) {
                    if (!player.func_74764_b(node.key)) continue;
                    psec.setNode(node, player.func_74762_e(node.key));
                }
                this.psecs.put(player.func_74779_i("name"), psec);
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound comp) {
        NBTTagList players = new NBTTagList();
        for (String player : this.psecs.keySet()) {
            NBTTagCompound playerComp = new NBTTagCompound();
            for (PermissionNode node : PermissionNode.values()) {
                playerComp.func_74768_a(node.key, this.psecs.get(player).getPermission(node));
            }
            players.func_74742_a((NBTBase)playerComp);
        }
        comp.func_74782_a("players", (NBTBase)players);
        return comp;
    }
}

