/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.client.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import pcl.opensecurity.common.tileentity.TileEntityKeypad;

public class RenderKeypad
extends TileEntitySpecialRenderer<TileEntityKeypad> {
    static float texPixel = 0.0625f;
    static TileEntityKeypad.ButtonState[] itemButtonStates;
    static String[] default_labels;
    static byte[] default_colors;
    static ButtonPosition[] buttons;
    static ButtonPosition display;

    public static void renderButtonGeometry(BufferBuilder vertexbuffer, float depth, ButtonPosition pos) {
        float tx = texPixel * 2.0f;
        float ty = texPixel * 2.0f;
        float x = pos.x * texPixel;
        float y = pos.y * texPixel;
        float z = depth;
        float w = pos.w * texPixel;
        float h = pos.h * texPixel;
        vertexbuffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)tx, (double)ty).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)(y + h), (double)z).func_187315_a((double)tx, (double)(ty + 2.0f * texPixel)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)(y + h), (double)z).func_187315_a((double)(tx + 2.0f * texPixel), (double)(ty + 2.0f * texPixel)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)y, (double)z).func_187315_a((double)(tx + 2.0f * texPixel), (double)ty).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)tx, (double)ty).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, (double)(z + 1.0f)).func_187315_a((double)(tx + 2.0f * texPixel), (double)ty).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)(y + h), (double)(z + 1.0f)).func_187315_a((double)(tx + 2.0f * texPixel), (double)(ty + 2.0f * texPixel)).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)(y + h), (double)z).func_187315_a((double)tx, (double)(ty + 2.0f * texPixel)).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)y, (double)(z + 1.0f)).func_187315_a((double)(tx + 2.0f * texPixel), (double)ty).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)y, (double)z).func_187315_a((double)tx, (double)ty).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)(y + h), (double)z).func_187315_a((double)tx, (double)(ty + 2.0f * texPixel)).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)(y + h), (double)(z + 1.0f)).func_187315_a((double)(tx + 2.0f * texPixel), (double)(ty + 2.0f * texPixel)).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)tx, (double)ty).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)y, (double)z).func_187315_a((double)(tx + 2.0f * texPixel), (double)ty).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)y, (double)(z + 1.0f)).func_187315_a((double)(tx + 2.0f * texPixel), (double)(ty + 2.0f * texPixel)).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, (double)(z + 1.0f)).func_187315_a((double)tx, (double)(ty + 2.0f * texPixel)).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)(y + h), (double)(z + 1.0f)).func_187315_a((double)(tx + 2.0f * texPixel), (double)ty).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)(y + h), (double)(z + 1.0f)).func_187315_a((double)(tx + 2.0f * texPixel), (double)(ty + 2.0f * texPixel)).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + w), (double)(y + h), (double)z).func_187315_a((double)tx, (double)(ty + 2.0f * texPixel)).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)(y + h), (double)z).func_187315_a((double)tx, (double)ty).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public static void writeButtonLabel(FontRenderer font, float depth, ButtonPosition pos, int color, String label) {
        float x = pos.x * texPixel;
        float y = pos.y * texPixel;
        float w = pos.w * texPixel;
        float h = pos.h * texPixel;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)(x + w / 2.0f), (float)(y + h / 2.0f), (float)(depth + texPixel * -0.07f));
        int labelW = font.func_78256_a(label);
        float scale = Math.min(h / 10.0f, 0.8f * w / (float)labelW);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
        GL11.glDepthMask((boolean)false);
        int argb = -16777216;
        if ((color & 4) != 0) {
            argb |= 0xFF0000;
        }
        if ((color & 2) != 0) {
            argb |= 0xFF00;
        }
        if ((color & 1) != 0) {
            argb |= 0xFF;
        }
        font.func_78276_b(label, -labelW / 2, -4, argb);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public void render(TileEntityKeypad tileEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)0.5f);
        GlStateManager.func_179114_b((float)tileEntity.getAngle(), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
        IBlockState state = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v());
        EnumFacing facing = EnumFacing.func_176731_b((int)state.func_177230_c().func_176201_c(state));
        int li = tileEntity.func_145831_w().func_175626_b(tileEntity.func_174877_v().func_177972_a(facing.func_176734_d()), 0);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(li % 65536), (float)(li / 65536));
        long time = tileEntity.func_145831_w().func_82737_E();
        this.func_147499_a(new ResourceLocation("opensecurity", "textures/blocks/machine_side.png"));
        GlStateManager.func_179139_a((double)1.001, (double)1.001, (double)1.001);
        this.drawKeypadBlock(tileEntity, time);
        GlStateManager.func_179121_F();
    }

    public void drawKeypadBlock(TileEntityKeypad keylock, long time) {
        int i;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        vertexbuffer.func_181662_b((double)texPixel, (double)texPixel, (double)texPixel).func_187315_a((double)texPixel, (double)(1.0f - texPixel)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)(1.0f - texPixel), (double)texPixel).func_187315_a((double)texPixel, (double)texPixel).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)(1.0f - texPixel), (double)texPixel).func_187315_a((double)(1.0f - texPixel), (double)texPixel).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)texPixel, (double)texPixel).func_187315_a((double)(1.0f - texPixel), (double)(1.0f - texPixel)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)texPixel, 0.0).func_187315_a((double)texPixel, (double)texPixel).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)texPixel, 0.0).func_187315_a((double)(1.0f - texPixel), (double)texPixel).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)(1.0f - texPixel), 0.0).func_187315_a((double)texPixel, (double)(1.0f - texPixel)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)(1.0f - texPixel), 0.0).func_187315_a((double)(1.0f - texPixel), (double)(1.0f - texPixel)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)(1.0f - texPixel), 0.0).func_187315_a((double)texPixel, (double)(1.0f - texPixel)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)texPixel, 0.0).func_187315_a((double)texPixel, (double)texPixel).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)texPixel, 0.0).func_187315_a((double)(1.0f - texPixel), (double)texPixel).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)(1.0f - texPixel), 0.0).func_187315_a((double)(1.0f - texPixel), (double)(1.0f - texPixel)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)texPixel, 0.0).func_187315_a((double)texPixel, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)texPixel, (double)texPixel).func_187315_a((double)texPixel, (double)(1.0f - texPixel)).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)texPixel, (double)texPixel).func_187315_a((double)(1.0f - texPixel), (double)(1.0f - texPixel)).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)texPixel, 0.0).func_187315_a((double)(1.0f - texPixel), 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)(1.0f - texPixel), (double)texPixel).func_187315_a((double)texPixel, (double)texPixel).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)(1.0f - texPixel), 0.0).func_187315_a((double)texPixel, 0.0).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)(1.0f - texPixel), 0.0).func_187315_a((double)(1.0f - texPixel), 0.0).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)(1.0f - texPixel), (double)texPixel).func_187315_a((double)(1.0f - texPixel), (double)texPixel).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)texPixel, 0.0).func_187315_a((double)(1.0f - texPixel), (double)texPixel).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)(1.0f - texPixel), 0.0).func_187315_a((double)(1.0f - texPixel), (double)(1.0f - texPixel)).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)(1.0f - texPixel), (double)texPixel).func_187315_a(1.0, (double)(1.0f - texPixel)).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)texPixel, (double)texPixel, (double)texPixel).func_187315_a(1.0, (double)texPixel).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)texPixel, (double)texPixel).func_187315_a(1.0, (double)texPixel).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)(1.0f - texPixel), (double)texPixel).func_187315_a(1.0, (double)(1.0f - texPixel)).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)(1.0f - texPixel), 0.0).func_187315_a((double)(1.0f - texPixel), (double)(1.0f - texPixel)).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)(1.0f - texPixel), (double)texPixel, 0.0).func_187315_a((double)(1.0f - texPixel), (double)texPixel).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        boolean[] pressed = new boolean[12];
        for (i = 0; i < pressed.length; ++i) {
            pressed[i] = keylock != null && keylock.buttonStates[i].isPressed(time);
        }
        for (i = 0; i < 12; ++i) {
            RenderKeypad.renderButtonGeometry(vertexbuffer, pressed[i] ? texPixel * 0.75f : 0.0f, buttons[i]);
        }
        RenderKeypad.renderButtonGeometry(vertexbuffer, 0.0f, display);
        tessellator.func_78381_a();
        FontRenderer font = this.func_147498_b();
        if (font != null) {
            String[] btnLabels = keylock != null ? keylock.buttonLabels : default_labels;
            byte[] btnColors = keylock != null ? keylock.buttonColors : default_colors;
            String fbText = keylock != null ? keylock.displayText : "";
            int fbColor = keylock != null ? (int)keylock.displayColor : 7;
            for (int i2 = 0; i2 < 12; ++i2) {
                String lbl = btnLabels[i2];
                if (lbl == null) {
                    lbl = default_labels[i2];
                }
                if (lbl.length() <= 0) continue;
                RenderKeypad.writeButtonLabel(font, pressed[i2] ? texPixel * 0.75f : 0.0f, buttons[i2], btnColors[i2], lbl);
            }
            if (fbText != null && fbText.length() > 0) {
                RenderKeypad.writeButtonLabel(font, 0.0f, display, fbColor, fbText);
            }
        }
    }

    static {
        default_labels = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#"};
        default_colors = new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
        buttons = null;
        display = null;
        itemButtonStates = new TileEntityKeypad.ButtonState[12];
        for (int i = 0; i < 12; ++i) {
            RenderKeypad.itemButtonStates[i] = new TileEntityKeypad.ButtonState();
        }
        buttons = new ButtonPosition[12];
        RenderKeypad.buttons[0] = new ButtonPosition(10.0f, 9.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[1] = new ButtonPosition(7.0f, 9.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[2] = new ButtonPosition(4.0f, 9.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[3] = new ButtonPosition(10.0f, 7.0f, 2.0f, 2.0f);
        RenderKeypad.buttons[4] = new ButtonPosition(7.0f, 7.0f, 2.0f, 2.0f);
        RenderKeypad.buttons[5] = new ButtonPosition(4.0f, 7.0f, 2.0f, 2.0f);
        RenderKeypad.buttons[6] = new ButtonPosition(10.0f, 4.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[7] = new ButtonPosition(7.0f, 4.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[8] = new ButtonPosition(4.0f, 4.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[9] = new ButtonPosition(10.0f, 2.0f, 2.0f, 2.0f);
        RenderKeypad.buttons[10] = new ButtonPosition(7.0f, 2.0f, 2.0f, 2.0f);
        RenderKeypad.buttons[11] = new ButtonPosition(4.0f, 2.0f, 2.0f, 2.0f);
        display = new ButtonPosition(4.0f, 12.0f, 8.0f, 2.0f);
    }

    static class ButtonPosition {
        public float x;
        public float y;
        public float w;
        public float h;

        ButtonPosition(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

