/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicterminal.container;

import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.me.SlotME;
import appeng.container.ContainerNull;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.core.AEConfig;
import appeng.core.localization.ButtonToolTips;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.helpers.InventoryAction;
import ftblag.thaumicterminal.container.ContainerArcaneTerminal;
import ftblag.thaumicterminal.container.inventory.InventoryCraftingArcane;
import ftblag.thaumicterminal.container.slot.SlotCraftingArcane;
import ftblag.thaumicterminal.container.slot.SlotTestCrystal;
import ftblag.thaumicterminal.part.PartArcaneTerminal;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.common.blocks.world.ore.ShardType;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class GuiArcaneTerminal
extends GuiMEMonitorable {
    private GuiImgButton clearBtn;
    private InventoryPlayer ip;
    private PartArcaneTerminal ct;

    public GuiArcaneTerminal(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(inventoryPlayer, te, (ContainerMEMonitorable)new ContainerArcaneTerminal(inventoryPlayer, te));
        this.setReservedSpaceTest(73);
        this.ip = inventoryPlayer;
        this.ct = (PartArcaneTerminal)te;
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        Slot s = this.getSlot(x, y);
        if (s instanceof SlotME && !stack.func_190926_b()) {
            String local;
            int bigNumber = AEConfig.instance().useTerminalUseLargeFont() ? 999 : 9999;
            IAEItemStack myStack = null;
            List currentToolTip = this.func_191927_a(stack);
            try {
                SlotME theSlotField = (SlotME)s;
                myStack = theSlotField.getAEStack();
            }
            catch (Throwable theSlotField) {
                // empty catch block
            }
            if (myStack != null) {
                String format;
                String formattedAmount;
                if (myStack.getStackSize() > (long)bigNumber || myStack.getStackSize() > 1L && stack.func_77951_h()) {
                    local = ButtonToolTips.ItemsStored.getLocal();
                    formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(myStack.getStackSize());
                    format = String.format(local, formattedAmount);
                    currentToolTip.add(TextFormatting.GRAY + format);
                }
                if (myStack.getCountRequestable() > 0L) {
                    local = ButtonToolTips.ItemsRequestable.getLocal();
                    formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(myStack.getCountRequestable());
                    format = String.format(local, formattedAmount);
                    currentToolTip.add(format);
                }
                this.drawHoveringText(currentToolTip, x, y, this.field_146289_q);
            } else if (stack.func_190916_E() > bigNumber) {
                local = ButtonToolTips.ItemsStored.getLocal();
                String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(stack.func_190916_E());
                String format = String.format(local, formattedAmount);
                currentToolTip.add(TextFormatting.GRAY + format);
                this.drawHoveringText(currentToolTip, x, y, this.field_146289_q);
            }
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        this.drawHoveringText(this.func_191927_a(stack), x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (this.clearBtn == btn) {
            Slot s = null;
            Container c = this.field_147002_h;
            for (Slot j : c.field_75151_b) {
                if (!(j instanceof SlotCraftingMatrix) || j instanceof SlotTestCrystal) continue;
                s = j;
            }
            if (s != null) {
                PacketInventoryAction p = new PacketInventoryAction(InventoryAction.MOVE_REGION, s.field_75222_d, 0L);
                NetworkHandler.instance().sendToServer((AppEngPacket)p);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.clearBtn = new GuiImgButton(this.field_147003_i + 97, this.field_147009_r + this.field_147000_g - 166, (Enum)Settings.ACTIONS, (Enum)ActionItems.STASH);
        this.field_146292_n.add(this.clearBtn);
        this.clearBtn.setHalfSize(true);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(offsetX, offsetY, mouseX, mouseY);
        this.field_146289_q.func_78276_b("Arcane Terminal", 8, this.field_147000_g - 96 + 1 - this.getReservedSpaceTest(), 0x404040);
        int cost = 0;
        int discount = 0;
        InventoryCraftingArcane ic = new InventoryCraftingArcane(this.ct, (Container)new ContainerNull());
        for (int x = 0; x < 15; ++x) {
            ic.func_70299_a(x, ((ContainerArcaneTerminal)this.field_147002_h).craftingSlots[x].func_75211_c());
        }
        IArcaneRecipe result = ThaumcraftCraftingManager.findMatchingArcaneRecipe((InventoryCrafting)ic, (EntityPlayer)this.ip.field_70458_d);
        AspectList crystals = null;
        float df = CasterManager.getTotalVisDiscount((EntityPlayer)this.ip.field_70458_d);
        if (result != null) {
            cost = result.getVis();
            cost = (int)((float)cost * (1.0f - df));
            discount = (int)(df * 100.0f);
            crystals = result.getCrystals();
        }
        int y = this.field_147000_g - 96 + 1 - this.getReservedSpaceTest() + 18;
        GL11.glEnable((int)3042);
        if (crystals != null) {
            this.bindTexture("test/guis/crystals.png");
            GlStateManager.func_179112_b((int)770, (int)1);
            for (Aspect a : crystals.getAspects()) {
                int id = ShardType.getMetaByAspect((Aspect)a);
                Color col = new Color(a.getColor());
                GL11.glColor4f((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)0.33f);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)ContainerArcaneTerminal.xx[id] + 7.5f), (float)((float)(y + ContainerArcaneTerminal.yy[id]) + 8.0f + 68.0f), (float)0.0f);
                GL11.glRotatef((float)((float)(id * 60 + this.field_146297_k.func_175606_aa().field_70173_aa % 360) + Minecraft.func_71410_x().func_193989_ak()), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.0f);
                this.func_73729_b(-32, -32, 192, 0, 64, 64);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179112_b((int)770, (int)771);
        }
        GL11.glDisable((int)3042);
        String text = this.ct.auraVisClient + " available";
        int ll = this.field_146289_q.func_78256_a(text) / 2;
        this.field_146289_q.func_78276_b(text, 139 - ll, y, this.ct.auraVisClient < cost ? 0xEE6E6E : 0x6E6EEE);
        if (cost > 0) {
            if (this.ct.auraVisClient < cost) {
                this.field_146296_j.func_180450_b(result.func_77572_b((InventoryCrafting)ic), 146, y + 13);
            }
            if (discount > 0) {
                text = "" + discount + "% discount";
                ll = this.field_146289_q.func_78256_a(text) / 2;
                this.field_146289_q.func_78276_b(text, 139 - ll, y -= 9, 0);
            }
            text = cost + " vis";
            ll = this.field_146289_q.func_78256_a(text) / 2;
            this.field_146289_q.func_78276_b(text, 139 - ll, y -= 9, 0);
        }
    }

    protected void func_184098_a(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof SlotCraftingArcane) {
            if (mouseButton == 6) {
                return;
            }
            InventoryAction action = null;
            action = GuiArcaneTerminal.func_146272_n() ? InventoryAction.CRAFT_SHIFT : (mouseButton == 1 ? InventoryAction.CRAFT_STACK : InventoryAction.CRAFT_ITEM);
            PacketInventoryAction p = new PacketInventoryAction(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer((AppEngPacket)p);
            return;
        }
        super.func_184098_a(slot, slotIdx, mouseButton, clickType);
    }

    protected String getBackground() {
        return "test/guis/crafting.png";
    }

    public void bindTexture(String file) {
        if (file.startsWith("test/")) {
            ResourceLocation loc = new ResourceLocation("thaumicterminal", "textures/" + file.substring(5));
            this.field_146297_k.func_110434_K().func_110577_a(loc);
        } else {
            super.bindTexture(file);
        }
    }

    public int getReservedSpaceTest() {
        return (Integer)ReflectionHelper.getPrivateValue(GuiMEMonitorable.class, (Object)((Object)this), (String[])new String[]{"reservedSpace"});
    }

    public void setReservedSpaceTest(int reservedSpace) {
        ReflectionHelper.setPrivateValue(GuiMEMonitorable.class, (Object)((Object)this), (Object)reservedSpace, (String[])new String[]{"reservedSpace"});
    }
}

