/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.biome;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoana;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.entity.grottol.EntityGrottol;
import com.bobmowzie.mowziesmobs.server.entity.lantern.EntityLantern;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.google.common.collect.HashMultimap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public enum BiomeDictionaryHandler {
    INSTANCE;


    public void onInit() {
        HashMultimap biomesAndTypes = HashMultimap.create();
        for (Object b : Biome.field_185377_q) {
            Set types = BiomeDictionary.getTypes((Biome)b);
            for (BiomeDictionary.Type t : types) {
                biomesAndTypes.put((Object)t, b);
            }
        }
        ObjectArraySet frostmawBiomes = new ObjectArraySet();
        for (Object b : Biome.field_185377_q) {
            Set types = BiomeDictionary.getTypes((Biome)b);
            if (!types.contains(BiomeDictionary.Type.SNOWY) || types.contains(BiomeDictionary.Type.BEACH) || types.contains(BiomeDictionary.Type.OCEAN) || types.contains(BiomeDictionary.Type.RIVER)) continue;
            frostmawBiomes.add(b);
        }
        ObjectArraySet overworldBiomes = new ObjectArraySet();
        for (Object b : Biome.field_185377_q) {
            Set types = BiomeDictionary.getTypes((Biome)b);
            if (types.contains(BiomeDictionary.Type.VOID) || types.contains(BiomeDictionary.Type.NETHER) || types.contains(BiomeDictionary.Type.END)) continue;
            overworldBiomes.add(b);
        }
        ObjectArraySet lanternBiomes = new ObjectArraySet();
        for (Biome b : Biome.field_185377_q) {
            Set types = BiomeDictionary.getTypes((Biome)b);
            if (!types.contains(BiomeDictionary.Type.FOREST) || !types.contains(BiomeDictionary.Type.MAGICAL)) continue;
            lanternBiomes.add(b);
        }
        lanternBiomes.add(Biomes.field_150585_R);
        lanternBiomes.add(Biomes.field_185430_ab);
        ObjectArraySet nagaBiomes = new ObjectArraySet();
        for (Biome b : Biome.field_185377_q) {
            Set types = BiomeDictionary.getTypes((Biome)b);
            if (!types.contains(BiomeDictionary.Type.BEACH) || !types.contains(BiomeDictionary.Type.HILLS) && !types.contains(BiomeDictionary.Type.MOUNTAIN)) continue;
            nagaBiomes.add(b);
        }
        nagaBiomes.add(Biomes.field_150576_N);
        EntityRegistry.addSpawn(EntityFoliaath.class, (int)MowziesMobs.CONFIG.spawnrateFoliaath, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomesAndTypes.get((Object)BiomeDictionary.Type.JUNGLE).toArray(new Biome[biomesAndTypes.get((Object)BiomeDictionary.Type.JUNGLE).size()]));
        EntityRegistry.addSpawn(EntityBarakoana.class, (int)MowziesMobs.CONFIG.spawnrateBarakoa, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomesAndTypes.get((Object)BiomeDictionary.Type.SAVANNA).toArray(new Biome[biomesAndTypes.get((Object)BiomeDictionary.Type.SAVANNA).size()]));
        EntityRegistry.addSpawn(EntityFrostmaw.class, (int)MowziesMobs.CONFIG.spawnrateFrostmaw, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])frostmawBiomes.toArray(new Biome[frostmawBiomes.size()]));
        EntityRegistry.addSpawn(EntityGrottol.class, (int)MowziesMobs.CONFIG.spawnrateGrottol, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])overworldBiomes.toArray(new Biome[overworldBiomes.size()]));
        EntityRegistry.addSpawn(EntityLantern.class, (int)MowziesMobs.CONFIG.spawnrateLantern, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])lanternBiomes.toArray(new Biome[lanternBiomes.size()]));
        EntityRegistry.addSpawn(EntityNaga.class, (int)MowziesMobs.CONFIG.spawnrateNaga, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])nagaBiomes.toArray(new Biome[nagaBiomes.size()]));
    }
}

