/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.integration;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import p455w0rd.danknull.init.ModConfig;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.util.DankNullUtils;
import p455w0rdslib.api.client.shader.Light;
import p455w0rdslib.capabilities.CapabilityLightEmitter;
import p455w0rdslib.handlers.BrightnessHandler;
import p455w0rdslib.util.RenderUtils;

public class PwLib {
    public static <T> T getStackCapability(final ItemStack stack) {
        return (T)CapabilityLightEmitter.LIGHT_EMITTER_CAPABILITY.cast((Object)new CapabilityLightEmitter.StackLightEmitter(stack){

            public List<Light> emitLight(List<Light> lights, Entity entity) {
                if (ModConfig.Options.enableColoredLightShaderSupport && DankNullUtils.isDankNullPanel(stack) || DankNullUtils.isDankNull(stack)) {
                    ItemStack lightStack = stack.func_77946_l();
                    if (!lightStack.func_190926_b() && DankNullUtils.getTier(lightStack) != ModGlobals.DankNullTier.NONE) {
                        Vec3i c = RenderUtils.hexToRGB((int)DankNullUtils.getTier(lightStack).getHexColor(false));
                        lights.add(Light.builder().pos(entity).color((float)c.func_177958_n(), (float)c.func_177956_o(), (float)c.func_177952_p(), (float)BrightnessHandler.getBrightness((Entity)entity).value() * 0.001f).radius(2.0f).intensity(2.5f).build());
                    } else {
                        BrightnessHandler.getBrightness((Entity)entity).reset();
                    }
                }
                return lights;
            }
        });
    }

    public static <T> T getTileCapability(TileEntity tile) {
        return (T)CapabilityLightEmitter.LIGHT_EMITTER_CAPABILITY.cast((Object)new CapabilityLightEmitter.TileLightEmitter(tile){

            public List<Light> emitLight(List<Light> lights, TileEntity tile) {
                if (ModConfig.Options.enableColoredLightShaderSupport && DankNullUtils.isDankNullDock(tile)) {
                    ItemStack lightStack = DankNullUtils.getDockedDankNull(tile);
                    if (!lightStack.func_190926_b() && DankNullUtils.getTier(lightStack) != ModGlobals.DankNullTier.NONE) {
                        Vec3i c = RenderUtils.hexToRGB((int)DankNullUtils.getTier(lightStack).getHexColor(false));
                        lights.add(Light.builder().pos(tile.func_174877_v()).color((float)c.func_177958_n(), (float)c.func_177956_o(), (float)c.func_177952_p(), (float)((double)BrightnessHandler.getBrightness((TileEntity)tile).value() * 0.001)).radius(2.0f).intensity(5.0f).build());
                    } else {
                        BrightnessHandler.getBrightness((TileEntity)tile).reset();
                    }
                }
                return lights;
            }
        });
    }

    public static boolean checkCap(Capability<?> capability) {
        return CapabilityLightEmitter.checkCap(capability) && ModConfig.Options.enableColoredLightShaderSupport;
    }
}

