/*
 * Decompiled with CFR 0.152.
 */
package treechopper.common.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import treechopper.common.config.ConfigurationHandler;
import treechopper.common.tree.Tree;

public class TreeHandler {
    private static Map<UUID, Tree> m_Trees = new HashMap<UUID, Tree>();
    private Tree tree;

    private static <T> T getLastElement(Iterable<T> elements) {
        Iterator<T> itr = elements.iterator();
        T lastElement = itr.next();
        while (itr.hasNext()) {
            lastElement = itr.next();
        }
        return lastElement;
    }

    public int AnalyzeTree(World world, BlockPos blockPos, EntityPlayer entityPlayer) {
        LinkedList<Object> queuedBlocks = new LinkedList<Object>();
        HashSet<BlockPos> tmpBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
        Block logBlock = world.func_180495_p(blockPos).func_177230_c();
        this.tree = new Tree();
        queuedBlocks.add(blockPos);
        this.tree.InsertWood(blockPos);
        while (!queuedBlocks.isEmpty()) {
            BlockPos currentPos = (BlockPos)queuedBlocks.remove();
            checkedBlocks.add(currentPos);
            tmpBlocks.addAll(this.LookAroundBlock(logBlock, currentPos, world, checkedBlocks));
            queuedBlocks.addAll(tmpBlocks);
            checkedBlocks.addAll(tmpBlocks);
            tmpBlocks.clear();
        }
        HashSet<BlockPos> tmpLeaves = new HashSet<BlockPos>();
        tmpLeaves.addAll(this.tree.GetM_Leaves());
        for (BlockPos blockPos1 : tmpLeaves) {
            checkedBlocks.add(blockPos1);
            this.LookAroundBlock(null, blockPos1, world, checkedBlocks);
        }
        this.tree.setM_Position(blockPos);
        m_Trees.put(entityPlayer.getPersistentID(), this.tree);
        return this.tree.GetLogCount();
    }

    private Queue<BlockPos> LookAroundBlock(Block logBlock, BlockPos currentPos, World world, Set<BlockPos> checkedBlocks) {
        LinkedList<BlockPos> queuedBlocks = new LinkedList<BlockPos>();
        for (int i = -1; i <= 1; ++i) {
            BlockPos tmpPos = new BlockPos(currentPos.func_177958_n() + 1, currentPos.func_177956_o() + i, currentPos.func_177952_p());
            if (this.CheckBlock(world, tmpPos, checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n(), currentPos.func_177956_o() + i, currentPos.func_177952_p() + 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n() - 1, currentPos.func_177956_o() + i, currentPos.func_177952_p()), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n(), currentPos.func_177956_o() + i, currentPos.func_177952_p() - 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n() + 1, currentPos.func_177956_o() + i, currentPos.func_177952_p() + 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n() - 1, currentPos.func_177956_o() + i, currentPos.func_177952_p() - 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n() - 1, currentPos.func_177956_o() + i, currentPos.func_177952_p() + 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n() + 1, currentPos.func_177956_o() + i, currentPos.func_177952_p() - 1), checkedBlocks, logBlock)) {
                queuedBlocks.add(tmpPos);
            }
            if (!this.CheckBlock(world, tmpPos = new BlockPos(currentPos.func_177958_n(), currentPos.func_177956_o() + i, currentPos.func_177952_p()), checkedBlocks, logBlock)) continue;
            queuedBlocks.add(tmpPos);
        }
        return queuedBlocks;
    }

    private boolean CheckBlock(World world, BlockPos blockPos, Set<BlockPos> checkedBlocks, Block originBlock) {
        if (checkedBlocks.contains(blockPos)) {
            return false;
        }
        if (world.func_180495_p(blockPos).func_177230_c() != originBlock) {
            if (ConfigurationHandler.plantSapling && world.func_180495_p(blockPos).func_177230_c().isLeaves(world.func_180495_p(blockPos), (IBlockAccess)world, blockPos) && this.tree.GetM_Leaves().isEmpty()) {
                this.tree.InsertLeaf(blockPos);
            }
            if (ConfigurationHandler.decayLeaves && ConfigurationHandler.leafWhiteList.contains(world.func_180495_p(blockPos).func_177230_c().func_149739_a())) {
                this.tree.InsertLeaf(blockPos);
                return false;
            }
            if (ConfigurationHandler.decayLeaves && world.func_180495_p(blockPos).func_177230_c().isLeaves(world.func_180495_p(blockPos), (IBlockAccess)world, blockPos)) {
                this.tree.InsertLeaf(blockPos);
                return false;
            }
            return false;
        }
        this.tree.InsertWood(blockPos);
        return true;
    }

    public void DestroyTree(World world, EntityPlayer entityPlayer) {
        int soundReduced = 0;
        if (m_Trees.containsKey(entityPlayer.getPersistentID())) {
            Tree tmpTree = m_Trees.get(entityPlayer.getPersistentID());
            for (BlockPos blockPos : tmpTree.GetM_Wood()) {
                if (soundReduced <= 1) {
                    world.func_175655_b(blockPos, true);
                } else {
                    world.func_180495_p(blockPos).func_177230_c().func_176226_b(world, blockPos, world.func_180495_p(blockPos), 1);
                }
                world.func_175698_g(blockPos);
                ++soundReduced;
            }
            if (ConfigurationHandler.plantSapling && !tmpTree.GetM_Leaves().isEmpty()) {
                BlockPos tmpPosition = TreeHandler.getLastElement(tmpTree.GetM_Leaves());
                this.PlantSapling(world, tmpPosition, tmpTree.getM_Position());
            }
            soundReduced = 0;
            if (ConfigurationHandler.decayLeaves) {
                for (BlockPos blockPos : tmpTree.GetM_Leaves()) {
                    if (soundReduced <= 1) {
                        world.func_175655_b(blockPos, true);
                    } else {
                        world.func_180495_p(blockPos).func_177230_c().func_176226_b(world, blockPos, world.func_180495_p(blockPos), 1);
                    }
                    world.func_175698_g(blockPos);
                    ++soundReduced;
                }
            }
        }
    }

    private void PlantSapling(World world, BlockPos blockPos, BlockPos originPos) {
        HashSet leafDrop = new HashSet();
        BlockPos plantPos1 = new BlockPos(originPos.func_177958_n() - 1, originPos.func_177956_o(), originPos.func_177952_p() - 1);
        for (int counter = 0; leafDrop.isEmpty() && counter <= 100; ++counter) {
            NonNullList tmpList = NonNullList.func_191196_a();
            world.func_180495_p(blockPos).func_177230_c().getDrops(tmpList, (IBlockAccess)world, blockPos, world.func_180495_p(blockPos), 3);
            leafDrop.addAll(tmpList);
        }
        if (leafDrop.isEmpty()) {
            return;
        }
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
        fakePlayer.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)leafDrop.iterator().next());
        for (ItemStack itemStack : leafDrop) {
            itemStack.func_179546_a((EntityPlayer)fakePlayer, world, plantPos1, EnumHand.MAIN_HAND, EnumFacing.NORTH, 0.0f, 0.0f, 0.0f);
        }
    }
}

