/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.core.ChiselsAndBits;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ClipboardStorage
extends Configuration {
    public ClipboardStorage(File file) {
        super(file);
    }

    public void write(List<NBTTagCompound> myitems) {
        if (!ChiselsAndBits.getConfig().persistCreativeClipboard) {
            return;
        }
        for (String name : this.getCategoryNames()) {
            this.removeCategory(this.getCategory(name));
        }
        int idx = 0;
        for (NBTTagCompound nbt : myitems) {
            PacketBuffer b = new PacketBuffer(Unpooled.buffer());
            b.func_150786_a(nbt);
            int[] o = new int[b.writerIndex()];
            for (int x = 0; x < b.writerIndex(); ++x) {
                o[x] = b.getByte(x);
            }
            this.get("clipboard", "" + idx++, o).set(o);
        }
        this.save();
    }

    public List<NBTTagCompound> read() {
        ArrayList<NBTTagCompound> myItems = new ArrayList<NBTTagCompound>();
        if (!ChiselsAndBits.getConfig().persistCreativeClipboard) {
            return myItems;
        }
        for (Property p : this.getCategory("clipboard").values()) {
            int[] bytes = p.getIntList();
            byte[] o = new byte[bytes.length];
            for (int x = 0; x < bytes.length; ++x) {
                o[x] = (byte)bytes[x];
            }
            try {
                PacketBuffer b = new PacketBuffer(Unpooled.wrappedBuffer((byte[])o));
                NBTTagCompound c = b.func_150793_b();
                myItems.add(c);
            }
            catch (EncoderException encoderException) {
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {}
        }
        return myItems;
    }
}

