/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory.cell;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import extracells.integration.Capabilities;
import extracells.inventory.cell.IHandlerPartBase;
import extracells.part.fluid.PartFluidStorage;
import extracells.util.AEUtils;
import extracells.util.MachineSource;
import extracells.util.StorageChannels;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class HandlerPartStorageFluid
implements IHandlerPartBase<IAEFluidStack> {
    protected PartFluidStorage node;
    protected IFluidHandler tank;
    protected AccessRestriction access = AccessRestriction.READ_WRITE;
    protected List<Fluid> prioritizedFluids = new ArrayList<Fluid>();
    protected boolean inverted;
    private IStorageMonitorableAccessor externalHandler = null;
    protected TileEntity tile = null;
    public IStorageMonitorableAccessor externalSystem;

    public HandlerPartStorageFluid(PartFluidStorage _node) {
        this.node = _node;
    }

    public boolean canAccept(IAEFluidStack input) {
        IFluidTankProperties info;
        if (!this.node.isActive()) {
            return false;
        }
        if (this.tank == null && this.externalSystem == null && this.externalHandler == null || this.access != AccessRestriction.WRITE && this.access != AccessRestriction.READ_WRITE || input == null) {
            return false;
        }
        if (this.externalSystem != null) {
            IStorageMonitorable monitor = this.externalSystem.getInventory((IActionSource)new MachineSource(this.node));
            if (monitor == null) {
                return false;
            }
            IMEMonitor fluidInventory = monitor.getInventory((IStorageChannel)StorageChannels.FLUID());
            return fluidInventory != null && fluidInventory.canAccept((IAEStack)input);
        }
        if (this.externalHandler != null) {
            IMEMonitor inventory = this.externalHandler.getInventory((IActionSource)new MachineSource(this.node)).getInventory((IStorageChannel)StorageChannels.FLUID());
            return inventory != null;
        }
        IFluidTankProperties[] infoArray = this.tank.getTankProperties();
        if (infoArray != null && infoArray.length > 0 && ((info = infoArray[0]).getContents() == null || info.getContents().amount == 0 || info.getContents().getFluid().getName().equals(input.getFluidStack().getFluid().getName()))) {
            if (this.inverted) {
                return !this.prioritizedFluids.isEmpty() || !this.isPrioritized(input);
            }
            return this.prioritizedFluids.isEmpty() || this.isPrioritized(input);
        }
        return false;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, IActionSource src) {
        FluidStack drain;
        if (!this.node.isActive() || this.access != AccessRestriction.READ && this.access != AccessRestriction.READ_WRITE) {
            return null;
        }
        if (this.externalSystem != null && request != null) {
            IStorageMonitorable monitor = this.externalSystem.getInventory(src);
            if (monitor == null) {
                return null;
            }
            IMEMonitor fluidInventory = monitor.getInventory((IStorageChannel)StorageChannels.FLUID());
            if (fluidInventory == null) {
                return null;
            }
            return (IAEFluidStack)fluidInventory.extractItems((IAEStack)request, mode, src);
        }
        if (this.externalHandler != null && request != null) {
            IMEMonitor inventory = this.externalHandler.getInventory((IActionSource)new MachineSource(this.node)).getInventory((IStorageChannel)StorageChannels.FLUID());
            if (inventory == null) {
                return null;
            }
            return (IAEFluidStack)inventory.extractItems((IAEStack)request, mode, (IActionSource)new MachineSource(this.node));
        }
        if (this.tank == null || request == null || this.access == AccessRestriction.WRITE || this.access == AccessRestriction.NO_ACCESS) {
            return null;
        }
        FluidStack toDrain = request.getFluidStack();
        int drained = 0;
        int drained2 = 0;
        while (toDrain.amount != (drained += (drained2 = (drain = this.tank.drain(new FluidStack(toDrain.getFluid(), toDrain.amount - drained), mode == Actionable.MODULATE)) == null ? 0 : drain.amount)) && drained2 != 0) {
        }
        if (drained == 0) {
            return null;
        }
        IItemList<IAEFluidStack> fluids = this.getAvailableItems((IItemList<IAEFluidStack>)StorageChannels.FLUID().createList());
        for (IAEFluidStack fluid : fluids) {
            if (fluid.getFluid() != request.getFluid()) continue;
            drained = (int)Math.min((long)drained, fluid.getStackSize());
        }
        if (drained == toDrain.amount) {
            return request;
        }
        return AEUtils.createFluidStack(toDrain.getFluid().getName(), (long)drained);
    }

    public AccessRestriction getAccess() {
        return this.access;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        block8: {
            IFluidTankProperties[] infoArray;
            block9: {
                block7: {
                    if (!this.node.isActive() || this.access != AccessRestriction.READ && this.access != AccessRestriction.READ_WRITE) {
                        return out;
                    }
                    if (this.externalSystem == null) break block7;
                    IStorageMonitorable monitor = this.externalSystem.getInventory((IActionSource)new MachineSource(this.node));
                    if (monitor == null) {
                        return out;
                    }
                    IMEMonitor fluidInventory = monitor.getInventory((IStorageChannel)StorageChannels.FLUID());
                    if (fluidInventory == null) {
                        return out;
                    }
                    IItemList list = this.externalSystem.getInventory((IActionSource)new MachineSource(this.node)).getInventory((IStorageChannel)StorageChannels.FLUID()).getStorageList();
                    for (IAEFluidStack stack : list) {
                        out.add((IAEStack)stack);
                    }
                    break block8;
                }
                if (this.externalHandler == null) break block9;
                IMEMonitor inventory = this.externalHandler.getInventory((IActionSource)new MachineSource(this.node)).getInventory((IStorageChannel)StorageChannels.FLUID());
                if (inventory == null) {
                    return out;
                }
                IItemList list = inventory.getAvailableItems(StorageChannels.FLUID().createList());
                for (IAEFluidStack stack : list) {
                    out.add((IAEStack)stack);
                }
                break block8;
            }
            if (this.tank == null || (infoArray = this.tank.getTankProperties()) == null || infoArray.length <= 0) break block8;
            for (IFluidTankProperties info : infoArray) {
                if (info.getContents() == null) continue;
                out.add(StorageChannels.FLUID().createStack((Object)info.getContents()));
            }
        }
        return out;
    }

    public IStorageChannel getChannel() {
        return StorageChannels.FLUID();
    }

    public int getPriority() {
        return this.node.getPriority();
    }

    public int getSlot() {
        return 0;
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, IActionSource src) {
        int maxFill;
        if (this.access != AccessRestriction.WRITE && this.access != AccessRestriction.READ_WRITE) {
            return null;
        }
        if (this.externalSystem != null && input != null) {
            IStorageMonitorable monitor = this.externalSystem.getInventory(src);
            if (monitor == null) {
                return input;
            }
            IMEMonitor fluidInventory = monitor.getInventory((IStorageChannel)StorageChannels.FLUID());
            if (fluidInventory == null) {
                return input;
            }
            return (IAEFluidStack)fluidInventory.injectItems((IAEStack)input, mode, src);
        }
        if (this.externalHandler != null && input != null) {
            IMEMonitor inventory = this.externalHandler.getInventory((IActionSource)new MachineSource(this.node)).getInventory((IStorageChannel)StorageChannels.FLUID());
            if (inventory == null) {
                return input;
            }
            return (IAEFluidStack)inventory.injectItems((IAEStack)input, mode, (IActionSource)new MachineSource(this.node));
        }
        if (this.tank == null || input == null || !this.canAccept(input)) {
            return input;
        }
        FluidStack toFill = input.getFluidStack();
        int filled = 0;
        int filled2 = 0;
        while ((filled2 = this.tank.fill(new FluidStack(toFill.getFluid(), toFill.amount - filled), mode == Actionable.MODULATE)) != 0 && (filled += filled2) != toFill.amount) {
        }
        IFluidTankProperties[] infos = this.tank.getTankProperties();
        int n = maxFill = mode == Actionable.MODULATE ? filled : 0;
        if (mode == Actionable.SIMULATE) {
            for (IFluidTankProperties info : infos) {
                if (info.getContents() == null) {
                    maxFill += info.getCapacity();
                    continue;
                }
                if (info.getContents().getFluid() != toFill.getFluid()) continue;
                maxFill += info.getCapacity() - info.getContents().amount;
            }
        }
        if ((filled = Math.min(filled, maxFill)) == toFill.amount) {
            return null;
        }
        return AEUtils.createFluidStack(toFill.getFluid().getName(), (long)(toFill.amount - filled));
    }

    public boolean isPrioritized(IAEFluidStack input) {
        if (input == null) {
            return false;
        }
        for (Fluid fluid : this.prioritizedFluids) {
            if (fluid != input.getFluid()) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void onListUpdate() {
    }

    @Override
    public void onNeighborChange() {
        TileEntity tileEntity;
        IMEMonitor fluidInventory;
        IStorageMonitorable monitor;
        if (this.externalSystem != null && (monitor = this.externalSystem.getInventory((IActionSource)new MachineSource(this.node))) != null && (fluidInventory = monitor.getInventory((IStorageChannel)StorageChannels.FLUID())) != null) {
            fluidInventory.removeListener((IMEMonitorHandlerReceiver)this);
        }
        this.tank = null;
        TileEntity hostTile = this.node.getHostTile();
        if (hostTile == null) {
            return;
        }
        EnumFacing orientation = this.node.getFacing();
        if (hostTile.func_145831_w() == null) {
            return;
        }
        this.tile = tileEntity = hostTile.func_145831_w().func_175625_s(hostTile.func_174877_v().func_177972_a(orientation));
        this.tank = null;
        this.externalSystem = null;
        if (tileEntity == null) {
            this.externalHandler = null;
            return;
        }
        if (tileEntity.hasCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, this.node.getFacing().func_176734_d())) {
            IStorageMonitorable monitor2 = null;
            this.externalSystem = (IStorageMonitorableAccessor)tileEntity.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, this.node.getFacing().func_176734_d());
            monitor2 = this.externalSystem.getInventory((IActionSource)new MachineSource(this.node));
            if (monitor2 == null) {
                return;
            }
            IMEMonitor fluidInventory2 = monitor2.getInventory((IStorageChannel)StorageChannels.FLUID());
            if (fluidInventory2 == null) {
                return;
            }
            fluidInventory2.addListener((IMEMonitorHandlerReceiver)this, null);
        } else if (this.externalHandler == null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.node.getFacing().func_176734_d())) {
            this.tank = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.node.getFacing().func_176734_d());
        }
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, IActionSource actionSource) {
        IGridNode gridNode = this.node.getGridNode();
        if (gridNode != null) {
            IGrid grid = gridNode.getGrid();
            if (grid != null) {
                grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                gridNode.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(this.node.getGridBlock().getFluidMonitor(), (IStorageChannel)StorageChannels.FLUID()));
            }
            this.node.getHost().markForUpdate();
        }
    }

    @Override
    public void setAccessRestriction(AccessRestriction access) {
        this.access = access;
    }

    @Override
    public void setInverted(boolean _inverted) {
        this.inverted = _inverted;
    }

    @Override
    public void setPrioritizedFluids(Fluid[] _fluids) {
        this.prioritizedFluids.clear();
        for (Fluid fluid : _fluids) {
            if (fluid == null) continue;
            this.prioritizedFluids.add(fluid);
        }
    }

    public boolean validForPass(int i) {
        return true;
    }
}

