/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.config;

import fathertoast.specialmobs.config.Config;
import fathertoast.specialmobs.config.EnvironmentListConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;

public abstract class TargetEnvironment
implements Comparable<TargetEnvironment> {
    private final int priority;
    private final float value;

    public static TargetEnvironment read(String line) {
        float value;
        String[] itemList = line.split("=", 2);
        if (itemList.length < 2) {
            Config.log.error("Ignoring config line '{}' - contains no value parameter", (Object)line);
            return null;
        }
        try {
            value = Float.parseFloat(itemList[1].trim());
        }
        catch (Exception ex) {
            Config.log.error("Exception occurred while reading config line '{}'", (Object)line, (Object)ex);
            return null;
        }
        String[] target = itemList[0].trim().split("/", 2);
        if (target.length < 2) {
            Config.log.error("Ignoring config line '{}' - must declare environment (e.g., 'biome:' or 'dimension:')", (Object)line);
        } else {
            if (target[0].equalsIgnoreCase("biome")) {
                if (!target[1].endsWith("*")) {
                    return new TargetBiome(0, value, target[1]);
                }
                return new TargetBiomeGroup(1, value, target[1].substring(target[1].length() - 1));
            }
            if (target[0].equalsIgnoreCase("dimension")) {
                return new TargetDimension(2, value, target[1]);
            }
            Config.log.error("Ignoring config line '{}' - unrecognized environment '{}'", (Object)line, (Object)target[0]);
        }
        return null;
    }

    TargetEnvironment(int scope, float val) {
        this.priority = scope;
        this.value = val;
    }

    public float getValue() {
        return this.value;
    }

    public abstract boolean applies(EnvironmentListConfig.LocationInfo var1);

    @Override
    public int compareTo(TargetEnvironment other) {
        return this.priority - other.priority;
    }

    public String toString() {
        return "=" + this.value;
    }

    public static class TargetDimension
    extends TargetEnvironment {
        private final String dimensionName;
        private final int intId;

        public TargetDimension(DimensionType dimensionType, float val) {
            super(-1, val);
            this.dimensionName = dimensionType.func_186065_b();
            this.intId = dimensionType.func_186068_a();
        }

        TargetDimension(int scope, float val, String dimensionId) {
            super(scope, val);
            DimensionType dimType = null;
            for (DimensionType type : DimensionType.values()) {
                if (!type.func_186065_b().equalsIgnoreCase(dimensionId)) continue;
                dimType = type;
                break;
            }
            if (dimType != null) {
                this.dimensionName = dimType.func_186065_b();
                this.intId = dimType.func_186068_a();
            } else {
                String dimName = null;
                int id = -70457;
                try {
                    id = Integer.parseInt(dimensionId);
                    for (DimensionType type : DimensionType.values()) {
                        if (type.func_186068_a() != id) continue;
                        dimType = type;
                        break;
                    }
                    if (dimType != null) {
                        dimName = dimType.func_186065_b();
                        Config.log.warn("Numerical id (dimension/{}) used for dimension with string id 'dimension/{}'! Please avoid using numerical ids.", (Object)id, (Object)dimName);
                    } else {
                        Config.log.info("Dimension with numerical id 'dimension/{}' is invalid or not yet registered. Please set the dimension's mod before this mod in the load order. Also stop using numerical ids, you hooligan.", (Object)id);
                    }
                }
                catch (NumberFormatException ex) {
                    dimName = dimensionId;
                    Config.log.info("Dimension 'dimension/{}' is invalid or not yet registered. Please set the dimension's mod before this mod in the load order.", (Object)dimName);
                }
                this.dimensionName = dimName;
                this.intId = id;
            }
        }

        @Override
        public boolean applies(EnvironmentListConfig.LocationInfo location) {
            return this.dimensionName != null && location.dimType != null ? this.dimensionName.equals(location.dimType.func_186065_b()) : this.intId == location.dimId;
        }

        @Override
        public String toString() {
            return "dimension/" + this.dimensionName + super.toString();
        }
    }

    public static class TargetBiomeGroup
    extends TargetEnvironment {
        private final String registryNamePrefix;

        public TargetBiomeGroup(String prefix, float val) {
            super(-1, val);
            this.registryNamePrefix = new ResourceLocation(prefix).toString();
        }

        TargetBiomeGroup(int scope, float val, String biomeId) {
            super(scope, val);
            if (biomeId.isEmpty()) {
                Config.log.warn("Detected empty biome group string 'biome/*' - this matches all biomes in the 'minecraft:' namespace. Please use 'biome/minecraft:*' instead if this is your intended purpose!");
            }
            this.registryNamePrefix = new ResourceLocation(biomeId).toString();
        }

        @Override
        public boolean applies(EnvironmentListConfig.LocationInfo location) {
            return location.biomeName.toString().startsWith(this.registryNamePrefix);
        }

        @Override
        public String toString() {
            return "biome/" + this.registryNamePrefix + "*" + super.toString();
        }
    }

    public static class TargetBiome
    extends TargetEnvironment {
        private final ResourceLocation registryName;
        private final int intId;

        public TargetBiome(Biome biome, float val) {
            super(-1, val);
            this.registryName = biome.getRegistryName();
            this.intId = Biome.field_185377_q.func_148757_b((Object)biome);
        }

        TargetBiome(int scope, float val, String biomeId) {
            super(scope, val);
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeId));
            if (biome != null) {
                this.registryName = biome.getRegistryName();
                this.intId = Biome.field_185377_q.func_148757_b((Object)biome);
            } else {
                ResourceLocation regName = null;
                int id = -1;
                try {
                    id = Integer.parseInt(biomeId);
                    biome = (Biome)Biome.field_185377_q.func_148754_a(id);
                    if (biome != null) {
                        regName = (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome);
                        Config.log.warn("Numerical id (biome/{}) used for biome with string id 'biome/{}'! Please avoid using numerical ids.", (Object)id, (Object)regName);
                    } else {
                        Config.log.info("Biome with numerical id 'biome/{}' is invalid or not yet registered. Please set the biome's mod before this mod in the load order. Also stop using numerical ids, you hooligan.", (Object)id);
                    }
                }
                catch (NumberFormatException ex) {
                    regName = new ResourceLocation(biomeId);
                    Config.log.info("Biome 'biome/{}' is invalid or not yet registered. Please set the biome's mod before this mod in the load order.", (Object)regName);
                }
                this.registryName = regName;
                this.intId = id;
            }
        }

        @Override
        public boolean applies(EnvironmentListConfig.LocationInfo location) {
            return this.registryName != null ? this.registryName.equals((Object)location.biomeName) : this.intId == Biome.field_185377_q.func_148757_b((Object)location.biome);
        }

        @Override
        public String toString() {
            return "biome/" + this.registryName + super.toString();
        }
    }
}

