/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.tile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reborncore.common.tile.TileLegacyMachineBase;

public class FluidConfiguration
implements INBTSerializable<NBTTagCompound> {
    HashMap<EnumFacing, FluidConfig> sideMap = new HashMap();
    boolean input;
    boolean output;

    public FluidConfiguration() {
        Arrays.stream(EnumFacing.field_82609_l).forEach(facing -> this.sideMap.put((EnumFacing)facing, new FluidConfig((EnumFacing)facing)));
    }

    public FluidConfiguration(NBTTagCompound tagCompound) {
        this.deserializeNBT(tagCompound);
    }

    public FluidConfig getSideDetail(EnumFacing side) {
        if (side == null) {
            return this.sideMap.get(EnumFacing.NORTH);
        }
        return this.sideMap.get(side);
    }

    public List<FluidConfig> getAllSides() {
        return new ArrayList<FluidConfig>(this.sideMap.values());
    }

    public void updateFluidConfig(FluidConfig config) {
        FluidConfig toEdit = this.sideMap.get(config.side);
        toEdit.ioConfig = config.ioConfig;
    }

    public void update(TileLegacyMachineBase machineBase) {
        if (!this.input && !this.output) {
            return;
        }
        if (machineBase.getTank() == null || machineBase.func_145831_w().func_82737_E() % (long)machineBase.slotTransferSpeed() != 0L) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IFluidHandler fluidHandler;
            FluidConfig fluidConfig = this.getSideDetail(facing);
            if (fluidConfig == null || !fluidConfig.getIoConfig().isEnabled() || (fluidHandler = this.getFluidHandler(machineBase, facing)) == null) continue;
            if (this.autoInput() && fluidConfig.getIoConfig().isInsert()) {
                FluidUtil.tryFluidTransfer((IFluidHandler)machineBase.getTank(), (IFluidHandler)fluidHandler, (int)machineBase.fluidTransferAmount(), (boolean)true);
            }
            if (!this.autoOutput() || !fluidConfig.getIoConfig().isExtact()) continue;
            FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)machineBase.getTank(), (int)machineBase.fluidTransferAmount(), (boolean)true);
        }
    }

    private IFluidHandler getFluidHandler(TileLegacyMachineBase machine, EnumFacing facing) {
        BlockPos pos = machine.func_174877_v().func_177972_a(facing);
        TileEntity tileEntity = machine.func_145831_w().func_175625_s(pos);
        if (tileEntity == null) {
            return null;
        }
        return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
    }

    public boolean autoInput() {
        return this.input;
    }

    public boolean autoOutput() {
        return this.output;
    }

    public void setInput(boolean input) {
        this.input = input;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        Arrays.stream(EnumFacing.field_82609_l).forEach(facing -> compound.func_74782_a("side_" + facing.ordinal(), (NBTBase)this.sideMap.get(facing).serializeNBT()));
        compound.func_74757_a("input", this.input);
        compound.func_74757_a("output", this.output);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.sideMap.clear();
        Arrays.stream(EnumFacing.field_82609_l).forEach(facing -> {
            NBTTagCompound compound = nbt.func_74775_l("side_" + facing.ordinal());
            FluidConfig config = new FluidConfig(compound);
            this.sideMap.put((EnumFacing)facing, config);
        });
        this.input = nbt.func_74767_n("input");
        this.output = nbt.func_74767_n("output");
    }

    public static enum ExtractConfig {
        NONE(false, false),
        INPUT(false, true),
        OUTPUT(true, false),
        ALL(true, true);

        boolean extact;
        boolean insert;

        private ExtractConfig(boolean extact, boolean insert) {
            this.extact = extact;
            this.insert = insert;
        }

        public boolean isExtact() {
            return this.extact;
        }

        public boolean isInsert() {
            return this.insert;
        }

        public boolean isEnabled() {
            return this.extact || this.insert;
        }

        public ExtractConfig getNext() {
            int i = this.ordinal() + 1;
            if (i >= ExtractConfig.values().length) {
                i = 0;
            }
            return ExtractConfig.values()[i];
        }
    }

    public static class FluidConfig
    implements INBTSerializable<NBTTagCompound> {
        EnumFacing side;
        ExtractConfig ioConfig;

        public FluidConfig(EnumFacing side) {
            this.side = side;
            this.ioConfig = ExtractConfig.ALL;
        }

        public FluidConfig(EnumFacing side, ExtractConfig ioConfig) {
            this.side = side;
            this.ioConfig = ioConfig;
        }

        public FluidConfig(NBTTagCompound tagCompound) {
            this.deserializeNBT(tagCompound);
        }

        public EnumFacing getSide() {
            return this.side;
        }

        public ExtractConfig getIoConfig() {
            return this.ioConfig;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("side", this.side.ordinal());
            tagCompound.func_74768_a("config", this.ioConfig.ordinal());
            return tagCompound;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.side = EnumFacing.field_82609_l[nbt.func_74762_e("side")];
            this.ioConfig = ExtractConfig.values()[nbt.func_74762_e("config")];
        }
    }
}

