/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.handler;

import codechicken.chunkloader.manager.ChunkLoaderManager;
import codechicken.chunkloader.manager.PlayerChunkViewerManager;
import codechicken.lib.util.ServerUtils;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ChunkLoaderEventHandler {
    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PlayerChunkViewerManager.instance().update();
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K) {
            ChunkLoaderManager.onTickEnd((WorldServer)event.world);
            PlayerChunkViewerManager.instance().calculateChunkChanges((WorldServer)event.world);
        }
    }

    @SubscribeEvent
    public void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerChunkViewerManager.instance().logouts.add(event.player.func_70005_c_());
    }

    @SubscribeEvent
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        ChunkLoaderManager.load((WorldServer)event.getWorld());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            ChunkLoaderManager.load((WorldServer)event.getWorld());
            ChunkLoaderManager.loadWorld((WorldServer)event.getWorld());
            PlayerChunkViewerManager.instance().dimChanges.add(new PlayerChunkViewerManager.DimensionChange((WorldServer)event.getWorld(), true));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            if (ServerUtils.mc().func_71278_l()) {
                ChunkLoaderManager.onWorldUnload(event.getWorld());
                PlayerChunkViewerManager.instance().dimChanges.add(new PlayerChunkViewerManager.DimensionChange((WorldServer)event.getWorld(), false));
            } else {
                PlayerChunkViewerManager.onServerShutdown();
                ChunkLoaderManager.onServerShutdown();
            }
        }
    }

    @SubscribeEvent
    public void onChunkForce(ForgeChunkManager.ForceChunkEvent event) {
        PlayerChunkViewerManager.instance().ticketChanges.add(new PlayerChunkViewerManager.TicketChange(event.getTicket(), event.getLocation(), true));
    }

    @SubscribeEvent
    public void onChunkUnForce(ForgeChunkManager.UnforceChunkEvent event) {
        PlayerChunkViewerManager.instance().ticketChanges.add(new PlayerChunkViewerManager.TicketChange(event.getTicket(), event.getLocation(), false));
    }
}

