/*
 * Decompiled with CFR 0.152.
 */
package thaumicperiphery.render;

import baubles.api.BaublesApi;
import baubles.api.render.IRenderBauble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.lib.UtilsFX;
import thaumicperiphery.Config;
import thaumicperiphery.ModContent;
import thaumicperiphery.render.ModelPauldron;

public class LayerExtraBaubles
implements LayerRenderer<EntityPlayer> {
    protected final RenderPlayer renderer;
    protected static final ResourceLocation girdle_mundane = new ResourceLocation("thaumicperiphery", "textures/model/girdle_mundane.png");
    protected static final ResourceLocation girdle_fancy = new ResourceLocation("thaumicperiphery", "textures/model/girdle_fancy.png");
    public static final ResourceLocation amulet_mundane = new ResourceLocation("thaumicperiphery", "textures/model/amulet_mundane.png");
    public static final ResourceLocation amulet_fancy = new ResourceLocation("thaumicperiphery", "textures/model/amulet_fancy.png");
    public static final ResourceLocation amulet_vis_stone = new ResourceLocation("thaumicperiphery", "textures/model/amulet_vis_stone.png");
    public static final ResourceLocation amulet_vis = new ResourceLocation("thaumicperiphery", "textures/model/amulet_vis.png");
    public static TextureAtlasSprite visAmuletSprite;
    public static final ResourceLocation pauldron;
    public static final ResourceLocation pauldron_repulsion;
    public static final ResourceLocation focus_pouch;
    protected static ModelBiped model;
    protected static ModelPauldron modelPauldron;
    protected static ModelRenderer pouchModel;

    public LayerExtraBaubles(RenderPlayer renderPlayer) {
        this.renderer = renderPlayer;
    }

    public void doRenderLayer(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch, float scale) {
        ItemStack body;
        if (!baubles.common.Config.renderBaubles || player.func_70660_b(MobEffects.field_76441_p) != null) {
            return;
        }
        int i = player.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        if (Config.tcBaubleRenderer) {
            ItemStack amulet;
            ItemStack belt = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(3);
            if (!belt.func_190926_b()) {
                if (belt.func_77973_b() == ItemsTC.baubles && !LayerExtraBaubles.hasPhantomInk(belt)) {
                    this.renderBelt(player, partialTicks, belt.func_77960_j() == 6 ? girdle_fancy : girdle_mundane);
                } else if (belt.func_77973_b() == ItemsTC.focusPouch && !LayerExtraBaubles.hasPhantomInk(belt)) {
                    this.renderPouch(player, partialTicks, focus_pouch);
                }
            }
            if (!(amulet = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(0)).func_190926_b()) {
                if (amulet.func_77973_b() == ItemsTC.baubles && !LayerExtraBaubles.hasPhantomInk(amulet)) {
                    this.renderAmulet(player, partialTicks, 5, 5, amulet.func_77960_j() == 4 ? amulet_fancy : amulet_mundane, null);
                } else if (amulet.func_77973_b() == ItemsTC.amuletVis && !LayerExtraBaubles.hasPhantomInk(amulet)) {
                    boolean found = amulet.func_77960_j() == 0;
                    this.renderAmulet(player, partialTicks, found ? 5 : 6, 6, found ? amulet_vis_stone : amulet_vis, found ? null : visAmuletSprite);
                }
            }
        }
        if (!(body = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(5)).func_190926_b()) {
            if (body.func_77973_b() == ModContent.pauldron_repulsion && !LayerExtraBaubles.hasPhantomInk(body)) {
                this.renderPauldron(player, limbSwing, limbSwingAmount, partialTicks, age, netHeadYaw, headPitch, scale, pauldron_repulsion);
            } else if (body.func_77973_b() == ModContent.pauldron && !LayerExtraBaubles.hasPhantomInk(body)) {
                this.renderPauldron(player, limbSwing, limbSwingAmount, partialTicks, age, netHeadYaw, headPitch, scale, pauldron);
            }
        }
    }

    protected void renderBelt(EntityPlayer player, float partialTicks, ResourceLocation belt) {
        GlStateManager.func_179094_E();
        GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(belt);
        IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
        GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        float s = 0.065625f;
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        if (model == null) {
            model = new ModelBiped();
        }
        LayerExtraBaubles.model.field_78115_e.func_78785_a(1.0f);
        GlStateManager.func_179121_F();
    }

    protected void renderAmulet(EntityPlayer player, float partialTicks, int width, int height, ResourceLocation amulet, TextureAtlasSprite amuletSprite) {
        GlStateManager.func_179094_E();
        GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(amulet);
        IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
        GlStateManager.func_179109_b((float)0.0f, (float)-5.0E-4f, (float)0.0f);
        float s = 0.065625f;
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        if (model == null) {
            model = new ModelBiped();
        }
        LayerExtraBaubles.model.field_78115_e.func_78785_a(1.0f);
        GlStateManager.func_179152_a((float)(0.5f * (float)width), (float)(-0.5f * (float)height), (float)2.5f);
        GlStateManager.func_179109_b((float)-0.5f, (float)(-1.0f - (float)(14 - height) / 16.0f), (float)-0.725f);
        if (amuletSprite != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            float minU = amuletSprite.func_94209_e();
            float maxU = amuletSprite.func_94212_f();
            float minV = amuletSprite.func_94206_g();
            float maxV = amuletSprite.func_94210_h();
            float diffU = maxU - minU;
            float diffV = maxV - minV;
            maxU = minU + diffU * ((float)width / 16.0f);
            maxV = minV + diffV * ((float)height / 16.0f);
            LayerExtraBaubles.renderIconIn3D(Tessellator.func_178181_a(), minU, minV, maxU, maxV, width, height, 0.25f);
        } else {
            UtilsFX.renderTextureIn3D((float)(1.0f - (float)width / 128.0f), (float)0.0f, (float)1.0f, (float)((float)height / 64.0f), (int)width, (int)height, (float)0.25f);
        }
        GlStateManager.func_179121_F();
    }

    protected void renderPauldron(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch, float scale, ResourceLocation texture) {
        GlStateManager.func_179094_E();
        GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        float s = 0.0625f;
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        if (modelPauldron == null) {
            modelPauldron = new ModelPauldron(0.125f);
        }
        modelPauldron.func_178686_a((ModelBase)this.renderer.func_177087_b());
        modelPauldron.func_78088_a((Entity)player, limbSwing, limbSwingAmount, age, netHeadYaw, headPitch, 1.0f);
        GlStateManager.func_179121_F();
    }

    protected void renderPouch(EntityPlayer player, float partialTicks, ResourceLocation texture) {
        GlStateManager.func_179094_E();
        GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
        GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        float s = 0.065625f;
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        if (model == null) {
            model = new ModelBiped();
        }
        if (pouchModel == null) {
            pouchModel = new ModelRenderer((ModelBase)model, 0, 11);
            pouchModel.func_78789_a(1.25f, 6.5f, -3.0f, 3, 3, 1);
        }
        LayerExtraBaubles.model.field_78115_e.func_78785_a(1.0f);
        pouchModel.func_78785_a(1.0f);
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return false;
    }

    public static boolean hasPhantomInk(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("phantomInk");
    }

    public static void renderIconIn3D(Tessellator tess, float minU, float minV, float maxU, float maxV, int width, int height, float thickness) {
        float f9;
        float f8;
        float f7;
        int k;
        BufferBuilder wr = tess.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        wr.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)minU, (double)maxV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        wr.func_181662_b(1.0, 0.0, 0.0).func_187315_a((double)maxU, (double)maxV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        wr.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)maxU, (double)minV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        wr.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)minU, (double)minV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        tess.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        wr.func_181662_b(0.0, 1.0, (double)(0.0f - thickness)).func_187315_a((double)minU, (double)minV).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        wr.func_181662_b(1.0, 1.0, (double)(0.0f - thickness)).func_187315_a((double)maxU, (double)minV).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        wr.func_181662_b(1.0, 0.0, (double)(0.0f - thickness)).func_187315_a((double)maxU, (double)maxV).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        wr.func_181662_b(0.0, 0.0, (double)(0.0f - thickness)).func_187315_a((double)minU, (double)maxV).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        tess.func_78381_a();
        float f5 = 0.5f * (minU - maxU) / (float)width;
        float f6 = 0.5f * (maxV - minV) / (float)height;
        wr.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (k = 0; k < width; ++k) {
            f7 = (float)k / (float)width;
            f8 = minU + (maxU - minU) * f7 - f5;
            wr.func_181662_b((double)f7, 0.0, (double)(0.0f - thickness)).func_187315_a((double)f8, (double)maxV).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            wr.func_181662_b((double)f7, 0.0, 0.0).func_187315_a((double)f8, (double)maxV).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            wr.func_181662_b((double)f7, 1.0, 0.0).func_187315_a((double)f8, (double)minV).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            wr.func_181662_b((double)f7, 1.0, (double)(0.0f - thickness)).func_187315_a((double)f8, (double)minV).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        }
        tess.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (k = 0; k < width; ++k) {
            f7 = (float)k / (float)width;
            f8 = minU + (maxU - minU) * f7 - f5;
            f9 = f7 + 1.0f / (float)width;
            wr.func_181662_b((double)f9, 1.0, (double)(0.0f - thickness)).func_187315_a((double)f8, (double)minV).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            wr.func_181662_b((double)f9, 1.0, 0.0).func_187315_a((double)f8, (double)minV).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            wr.func_181662_b((double)f9, 0.0, 0.0).func_187315_a((double)f8, (double)maxV).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            wr.func_181662_b((double)f9, 0.0, (double)(0.0f - thickness)).func_187315_a((double)f8, (double)maxV).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        }
        tess.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (k = 0; k < height; ++k) {
            f7 = (float)k / (float)height;
            f8 = maxV + (minV - maxV) * f7 - f6;
            f9 = f7 + 1.0f / (float)height;
            wr.func_181662_b(0.0, (double)f9, 0.0).func_187315_a((double)minU, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            wr.func_181662_b(1.0, (double)f9, 0.0).func_187315_a((double)maxU, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            wr.func_181662_b(1.0, (double)f9, (double)(0.0f - thickness)).func_187315_a((double)maxU, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            wr.func_181662_b(0.0, (double)f9, (double)(0.0f - thickness)).func_187315_a((double)minU, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        }
        tess.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (k = 0; k < height; ++k) {
            f7 = (float)k / (float)height;
            f8 = maxV + (minV - maxV) * f7 - f6;
            wr.func_181662_b(1.0, (double)f7, 0.0).func_187315_a((double)maxU, (double)f8).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            wr.func_181662_b(0.0, (double)f7, 0.0).func_187315_a((double)minU, (double)f8).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            wr.func_181662_b(0.0, (double)f7, (double)(0.0f - thickness)).func_187315_a((double)minU, (double)f8).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            wr.func_181662_b(1.0, (double)f7, (double)(0.0f - thickness)).func_187315_a((double)maxU, (double)f8).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        }
        tess.func_78381_a();
    }

    static {
        pauldron = new ResourceLocation("thaumicperiphery", "textures/model/pauldron.png");
        pauldron_repulsion = new ResourceLocation("thaumicperiphery", "textures/model/pauldron_repulsion.png");
        focus_pouch = new ResourceLocation("thaumicperiphery", "textures/model/focus_pouch.png");
    }
}

