/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.item.OpenGlassesNBT;

import java.util.HashSet;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class OpenGlassesNotificationsNBT {
    public static void addLinkRequest(ItemStack glassesStack, UUID hostUUID) {
        OpenGlassesNotificationsNBT.removeLinkRequest(glassesStack, hostUUID);
        HashSet<NBTTagCompound> list = OpenGlassesNotificationsNBT.getNotifications(glassesStack);
        NBTTagCompound notificationNBT = new NBTTagCompound();
        notificationNBT.func_186854_a("host", hostUUID);
        notificationNBT.func_74768_a("type", NotifiactionType.LINKREQUEST.ordinal());
        list.add(notificationNBT);
        OpenGlassesNotificationsNBT.writeNotificationsToNBT(glassesStack, list);
    }

    public static void writeNotificationsToNBT(ItemStack glassesStack, HashSet<NBTTagCompound> notifications) {
        NBTTagCompound notificationsNBT = new NBTTagCompound();
        int i = 0;
        for (NBTTagCompound tag : notifications) {
            notificationsNBT.func_74782_a("n" + i, (NBTBase)tag);
            ++i;
        }
        glassesStack.func_77978_p().func_74782_a("notifications", (NBTBase)notificationsNBT);
    }

    public static HashSet<NBTTagCompound> getNotifications(ItemStack glassesStack) {
        HashSet<NBTTagCompound> list = new HashSet<NBTTagCompound>();
        NBTTagCompound nbt = glassesStack.func_77978_p();
        NBTTagCompound notificationsNBT = nbt.func_74764_b("notifications") ? nbt.func_74775_l("notifications") : new NBTTagCompound();
        int i = 0;
        while (notificationsNBT.func_74764_b("n" + i)) {
            list.add(notificationsNBT.func_74775_l("n" + i));
            ++i;
        }
        return list;
    }

    public static void removeLinkRequest(ItemStack glassesStack, UUID hostUUID) {
        NBTTagCompound linkRequest = OpenGlassesNotificationsNBT.getLinkRequest(glassesStack, hostUUID);
        HashSet<NBTTagCompound> list = OpenGlassesNotificationsNBT.getNotifications(glassesStack);
        if (linkRequest != null) {
            list.remove(linkRequest);
            OpenGlassesNotificationsNBT.writeNotificationsToNBT(glassesStack, list);
        }
    }

    public static NBTTagCompound getLinkRequest(ItemStack glassesStack, UUID hostUUID) {
        for (NBTTagCompound tag : OpenGlassesNotificationsNBT.getNotifications(glassesStack)) {
            switch (NotifiactionType.values()[tag.func_74762_e("type")]) {
                case LINKREQUEST: {
                    if (!hostUUID.equals(tag.func_186857_a("host"))) break;
                    return tag;
                }
            }
        }
        return null;
    }

    public static enum NotifiactionType {
        LINKREQUEST;

    }
}

