/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.common.protection.Protection;
import pcl.opensecurity.networking.PacketProtectionSync;

public class OSBreakEvent {
    public OSBreakEvent() {
        if (OpenSecurity.debug) {
            OpenSecurity.logger.info("Registering BreakEvent");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer().func_184812_l_()) {
            return;
        }
        if (Protection.isProtected((Entity)event.getPlayer(), Protection.UserAction.mine, event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDetonate(ExplosionEvent.Detonate event) {
        ArrayList<BlockPos> removeBlocks = new ArrayList<BlockPos>();
        for (BlockPos blockPos : event.getAffectedBlocks()) {
            if (!Protection.isProtected(event.getWorld(), Protection.UserAction.explode, blockPos)) continue;
            removeBlocks.add(blockPos);
        }
        event.getAffectedBlocks().removeAll(removeBlocks);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        this.syncProtectionData(event.player.field_70170_p, (EntityPlayerMP)event.player);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        this.syncProtectionData(event.player.field_70170_p, (EntityPlayerMP)event.player);
    }

    private void syncProtectionData(World world, EntityPlayerMP player) {
        PacketProtectionSync packet = new PacketProtectionSync(world);
        OpenSecurity.network.sendTo((IMessage)packet, player);
    }
}

