/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop;

import engineers.workshop.client.GuiHandler;
import engineers.workshop.common.Config;
import engineers.workshop.common.items.ItemUpgrade;
import engineers.workshop.common.items.Upgrade;
import engineers.workshop.common.network.DataPacket;
import engineers.workshop.common.table.BlockTable;
import engineers.workshop.common.util.Logger;
import engineers.workshop.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import reborncore.RebornCore;
import reborncore.common.network.RegisterPacketEvent;
import reborncore.common.util.RebornCraftingHelper;

@Mod(modid="engineersworkshop", name="Engineers Workshop Reborn", dependencies="required-after:reborncore", certificateFingerprint="8727a3141c8ec7f173b87aa78b9b9807867c4e6b", acceptedMinecraftVersions="[1.12,1.12.2]")
public class EngineersWorkshop {
    @SidedProxy(clientSide="engineers.workshop.proxy.ClientProxy", serverSide="engineers.workshop.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="engineersworkshop")
    public static EngineersWorkshop instance;
    public static BlockTable blockTable;
    public static Item itemUpgrade;
    public static CreativeTabs tabWorkshop;

    public static void loadRecipes() {
        RebornCraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack((Block)blockTable), (Object[])new Object[]{"PPP", "CUC", "CCC", Character.valueOf('P'), Blocks.field_150344_f, Character.valueOf('C'), Blocks.field_150347_e, Character.valueOf('U'), Upgrade.BLANK.getItemStack()});
        EngineersWorkshop.addRecipe(Upgrade.BLANK, "SP", "PS", Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('P'), Blocks.field_150344_f);
        EngineersWorkshop.addRecipe(Upgrade.STORAGE, "C", "U", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('U'), Upgrade.BLANK.getItemStack());
        EngineersWorkshop.addRecipe(Upgrade.AUTO_CRAFTER, "PPP", "CTC", "CUC", Character.valueOf('P'), Blocks.field_150344_f, Character.valueOf('C'), Blocks.field_150347_e, Character.valueOf('T'), Blocks.field_150331_J, Character.valueOf('U'), Upgrade.BLANK.getItemStack());
        EngineersWorkshop.addRecipe(Upgrade.SPEED, "IRI", "LUL", "IRI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('L'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('U'), Upgrade.BLANK.getItemStack());
        EngineersWorkshop.addRecipe(Upgrade.QUEUE, "PPP", "IUI", "PPP", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('P'), Blocks.field_150344_f, Character.valueOf('U'), Upgrade.BLANK.getItemStack());
        EngineersWorkshop.addRecipe(Upgrade.AUTO_TRANSFER, "GGG", "HUH", "GGG", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('U'), Upgrade.BLANK.getItemStack());
        EngineersWorkshop.addRecipe(Upgrade.FILTER, "III", "GBG", "IUI", Character.valueOf('G'), Blocks.field_150445_bS, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('U'), Upgrade.BLANK.getItemStack());
        EngineersWorkshop.addRecipe(Upgrade.CHARGED, "IRI", "IUI", "IRI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('U'), Upgrade.BLANK.getItemStack());
        EngineersWorkshop.addRecipe(Upgrade.TRANSFER, "III", "GRG", "GUG", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Blocks.field_150451_bX, Character.valueOf('U'), Upgrade.BLANK.getItemStack());
        EngineersWorkshop.addRecipe(Upgrade.AXE, "FAF", "RUR", "III", Character.valueOf('F'), Items.field_151145_ak, Character.valueOf('A'), Items.field_151036_c, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('U'), Upgrade.BLANK.getItemStack(), Character.valueOf('I'), Blocks.field_150411_aY);
    }

    private static void addRecipe(Upgrade upgrade, Object ... recipe) {
        if (upgrade.isEnabled()) {
            RebornCraftingHelper.addShapedOreRecipe((ItemStack)upgrade.getItemStack(), (Object[])recipe);
            Logger.info((Object)((Object)upgrade) + " recipe loaded.");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.loadConfig(event.getSuggestedConfigurationFile());
        blockTable = new BlockTable();
        itemUpgrade = new ItemUpgrade();
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.preInit(event);
        EngineersWorkshop.loadRecipes();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
    }

    @SubscribeEvent
    public void packetEvent(RegisterPacketEvent event) {
        event.registerPacket(DataPacket.class, Side.SERVER);
        event.registerPacket(DataPacket.class, Side.CLIENT);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        RebornCore.proxy.invalidFingerprints.add("Invalid fingerprint detected for Engineers Workshop Reborn!");
    }

    static {
        tabWorkshop = new CreativeTabs("engineersworkshop"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)blockTable);
            }
        };
    }
}

