/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fathertoast.specialmobs.SpecialMobsMod;
import fathertoast.specialmobs.bestiary.EnumMobFamily;
import fathertoast.specialmobs.loot.LootTableBuilder;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Method;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;

@ParametersAreNonnullByDefault
public class LootTableHelper {
    private static final Gson GSON_LOOT_TABLES = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).setPrettyPrinting().create();

    public static void generateBaseLootTables(File configDir) {
        File runDir = configDir.getParentFile();
        if (!"run".equals(runDir.getName())) {
            return;
        }
        File projectDir = runDir.getParentFile();
        File lootTablesDir = new File(projectDir, "src/main/resources/assets/specialmobs/loot_tables/entities/");
        if (!lootTablesDir.exists()) {
            return;
        }
        SpecialMobsMod.log().warn("Generating base loot tables...");
        long startTime = System.nanoTime();
        SpecialMobsMod.log().warn("Loot table directory: '{}'", (Object)lootTablesDir.getAbsolutePath());
        LootTableHelper.deleteAllLootTables(lootTablesDir);
        LootTableHelper.createAllLootTables(lootTablesDir);
        long estimatedTime = System.nanoTime() - startTime;
        SpecialMobsMod.log().warn("Generated base loot tables in {} ms", (Object)((double)estimatedTime / 1000000.0));
    }

    private static void deleteAllLootTables(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    LootTableHelper.deleteAllLootTables(file);
                }
                if (file.delete()) continue;
                SpecialMobsMod.log().error("Failed to delete file: '{}'", (Object)file.getPath());
            }
        }
    }

    private static void createAllLootTables(File lootTablesDir) {
        lootTablesDir.mkdirs();
        for (EnumMobFamily family : EnumMobFamily.values()) {
            File familyDir = new File(lootTablesDir, family.name.toLowerCase() + "/");
            familyDir.mkdirs();
            for (EnumMobFamily.Species variant : family.variants) {
                File lootTableFile = new File(familyDir, variant.name.toLowerCase() + ".json");
                try {
                    LootTableBuilder lootTableBuilder = new LootTableBuilder();
                    Method speciesLootBuilder = variant.variantClass.getMethod("BUILD_LOOT_TABLE", LootTableBuilder.class);
                    speciesLootBuilder.invoke(null, lootTableBuilder);
                    lootTableFile.createNewFile();
                    FileWriter out = new FileWriter(lootTableFile);
                    GSON_LOOT_TABLES.toJson((Object)lootTableBuilder.toLootTable(), LootTable.class, (Appendable)out);
                    out.close();
                }
                catch (Exception ex) {
                    SpecialMobsMod.log().error("Failed to generate loot table: '{}'", (Object)lootTableFile.getPath(), (Object)ex);
                }
            }
        }
    }
}

