/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.slime;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.config.Config;
import fathertoast.specialmobs.entity.ISpecialMob;
import fathertoast.specialmobs.entity.MobHelper;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class Entity_SpecialSlime
extends EntitySlime
implements ISpecialMob {
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(Entity_SpecialSlime.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/slime/slime.png")};
    protected int slimeExperienceValue = 0;
    private SpecialMobData specialData;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(8306542);
        return info;
    }

    static String GET_TEXTURE_PATH(String type) {
        return "specialmobs:textures/entity/slime/" + type + ".png";
    }

    static void ADD_BASE_LOOT(LootTableBuilder loot) {
        loot.addLootTable("main", "Base loot", LootTableList.field_186378_ac);
    }

    public Entity_SpecialSlime(World world) {
        super(world);
    }

    protected final EntitySlime func_70802_j() {
        EntitySlime newSlime = this.getSplitSlime();
        if (newSlime instanceof ISpecialMob) {
            ISpecialMob specialSlime = (ISpecialMob)newSlime;
            specialSlime.getSpecialData().copyDataFrom((EntityLiving)this, false);
        }
        return newSlime;
    }

    protected EntitySlime getSplitSlime() {
        return new Entity_SpecialSlime(this.field_70170_p);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.initTypeAI();
    }

    protected void initTypeAI() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<Entity_SpecialSlime>(this, SCALE);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        float prevMax = this.func_110138_aP();
        this.applyTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
        this.setExperience(this.slimeExperienceValue);
    }

    protected void applyTypeAttributes() {
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        int size = this.func_70809_q();
        this.func_70105_a((float)size * this.typeSizeMultiplier(), (float)size * this.typeSizeMultiplier());
    }

    protected void func_70799_a(int size, boolean resetHealth) {
        super.func_70799_a(size, resetHealth);
        this.func_70105_a((float)size * this.typeSizeMultiplier(), (float)size * this.typeSizeMultiplier());
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Math.max((double)(size * size), 2.0));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)super.func_70805_n());
        this.adjustTypeAttributesForSize(size);
        if (resetHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.setExperience(this.slimeExperienceValue);
    }

    protected float typeSizeMultiplier() {
        return 0.51f;
    }

    protected void adjustTypeAttributesForSize(int size) {
    }

    protected ResourceLocation func_184647_J() {
        return this.func_189101_db() ? LootTableList.field_186378_ac : LootTableList.field_186419_a;
    }

    @Override
    public final SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public final int getExperience() {
        return this.slimeExperienceValue;
    }

    @Override
    public final void setExperience(int xp) {
        this.slimeExperienceValue = xp;
        this.field_70728_aV = this.func_70809_q() + xp;
    }

    @Override
    public final void setImmuneToFire(boolean immune) {
        this.field_70178_ae = immune;
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected void onTypeAttack(Entity target) {
    }

    protected void func_175451_e(EntityLivingBase target) {
        double reachSq = this.field_70130_N * this.field_70130_N + target.field_70130_N * target.field_70130_N;
        if (this.func_70685_l((Entity)target) && this.func_70068_e((Entity)target) < reachSq && this.func_70652_k((Entity)target)) {
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected int func_70805_n() {
        return (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    protected boolean func_70800_m() {
        return Config.get().SLIMES.TINY_SLIME_DAMAGE || super.func_70800_m();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public boolean func_70652_k(Entity target) {
        if (MobHelper.attackEntityAsMob((EntityLivingBase)this, target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    public float func_70047_e() {
        return super.func_70047_e();
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_70015_d(time);
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs()) {
            super.func_70110_aj();
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }
}

