/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.common.item.ItemManaGun;

public class GunModel
implements IBakedModel {
    private final IBakedModel originalModel;
    private final ItemOverrideList itemHandler = new ItemOverrideList((List)ImmutableList.of()){

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel model, ItemStack stack, World world, EntityLivingBase entity) {
            ItemStack lens = ItemManaGun.getLens(stack);
            if (!lens.func_190926_b()) {
                IBakedModel lensModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(lens);
                return GunModel.this.getModel(lensModel);
            }
            return GunModel.this;
        }
    };
    private final IdentityHashMap<IBakedModel, CompositeBakedModel> cache = new IdentityHashMap();

    public GunModel(IBakedModel originalModel) {
        this.originalModel = (IBakedModel)Preconditions.checkNotNull((Object)originalModel);
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.itemHandler;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.originalModel.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.originalModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.originalModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.originalModel.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.originalModel.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.originalModel.func_177552_f();
    }

    private CompositeBakedModel getModel(IBakedModel lens) {
        CompositeBakedModel model = this.cache.get(lens);
        if (model == null) {
            model = new CompositeBakedModel(lens, this.originalModel);
            this.cache.put(lens, model);
        }
        return model;
    }

    protected static BakedQuad transform(BakedQuad quad, final TRSRTransformation transform) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        VertexTransformer consumer = new VertexTransformer((IVertexConsumer)builder){

            public void put(int element, float ... data) {
                VertexFormatElement formatElement = DefaultVertexFormats.field_176599_b.func_177348_c(element);
                switch (formatElement.func_177375_c()) {
                    case POSITION: {
                        float[] newData = new float[4];
                        Vector4f vec = new Vector4f(data);
                        transform.getMatrix().transform((Tuple4f)vec);
                        vec.get(newData);
                        this.parent.put(element, newData);
                        break;
                    }
                    default: {
                        this.parent.put(element, data);
                    }
                }
            }
        };
        quad.pipe((IVertexConsumer)consumer);
        return builder.build();
    }

    private static class CompositeBakedModel
    implements IBakedModel {
        private final IBakedModel gun;
        private final List<BakedQuad> genQuads;
        private final Map<EnumFacing, List<BakedQuad>> faceQuads = new EnumMap<EnumFacing, List<BakedQuad>>(EnumFacing.class);

        CompositeBakedModel(IBakedModel lens, IBakedModel gun) {
            this.gun = gun;
            ImmutableList.Builder genBuilder = ImmutableList.builder();
            TRSRTransformation transform = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(-0.4f, 0.25f, 0.0f), null, new Vector3f(0.625f, 0.625f, 0.625f), TRSRTransformation.quatFromXYZ((float)0.0f, (float)1.5707964f, (float)0.0f)));
            for (Object e : EnumFacing.field_82609_l) {
                this.faceQuads.put((EnumFacing)e, new ArrayList());
            }
            for (BakedQuad quad : lens.func_188616_a(null, null, 0L)) {
                genBuilder.add((Object)GunModel.transform(quad, transform));
            }
            for (Object e : EnumFacing.field_82609_l) {
                this.faceQuads.get(e).addAll(lens.func_188616_a(null, e, 0L).stream().map(input -> GunModel.transform(input, transform)).collect(Collectors.toList()));
            }
            genBuilder.addAll((Iterable)gun.func_188616_a(null, null, 0L));
            for (Object e : EnumFacing.field_82609_l) {
                this.faceQuads.get(e).addAll(gun.func_188616_a(null, e, 0L));
            }
            this.genQuads = genBuilder.build();
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing face, long rand) {
            return face == null ? this.genQuads : this.faceQuads.get(face);
        }

        public boolean func_177555_b() {
            return this.gun.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.gun.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.gun.func_188618_c();
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.gun.func_177554_e();
        }

        @Nonnull
        public ItemCameraTransforms func_177552_f() {
            return this.gun.func_177552_f();
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
            Pair pair = this.gun.handlePerspective(cameraTransformType);
            if (pair != null && pair.getRight() != null) {
                return Pair.of((Object)this, (Object)pair.getRight());
            }
            return Pair.of((Object)this, (Object)TRSRTransformation.identity().getMatrix());
        }
    }
}

