/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.common;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.RenderType;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLOverlay;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLWorld;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IItem;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemIcon
extends WidgetGLWorld
implements IItem {
    private ItemStack itmStack = null;
    private IBakedModel ibakedmodel = null;

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        if (this.itmStack != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)this.itmStack.func_77973_b().getRegistryName().toString());
            buff.writeInt(this.itmStack.func_77960_j());
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)"none");
        }
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        String item = ByteBufUtils.readUTF8String((ByteBuf)buff);
        if (!item.equals("none")) {
            this.setItem(item, buff.readInt());
        }
    }

    @Override
    public boolean setItem(ItemStack newItem) {
        if (newItem == null || newItem.func_77973_b() == null) {
            return false;
        }
        this.itmStack = newItem;
        this.ibakedmodel = null;
        return true;
    }

    @Override
    public boolean setItem(String newItem, int meta) {
        return this.setItem(new ItemStack(Item.func_111206_d((String)newItem), 1, meta));
    }

    @Override
    public Item getItem() {
        return this.itmStack.func_77973_b();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderableItemIcon();
    }

    private class RenderableItemIcon
    extends WidgetGLOverlay.RenderableGLWidget {
        private RenderableItemIcon() {
            super(ItemIcon.this);
        }

        @Override
        public void render(EntityPlayer player, Vec3d renderOffset, long conditionStates) {
            if (ItemIcon.this.itmStack == null) {
                return;
            }
            if (ItemIcon.this.ibakedmodel == null) {
                ItemIcon.this.ibakedmodel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(ItemIcon.this.itmStack);
            }
            TextureManager tm = Minecraft.func_71410_x().func_110434_K();
            tm.func_110577_a(TextureMap.field_110575_b);
            tm.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179137_b((double)renderOffset.field_72450_a, (double)renderOffset.field_72448_b, (double)renderOffset.field_72449_c);
            int alphaColor = this.preRender(conditionStates);
            this.applyModifiers(conditionStates);
            if (ItemIcon.this.rendertype == RenderType.WorldLocated) {
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                if (ItemIcon.this.faceWidgetToPlayer) {
                    GlStateManager.func_179114_b((float)player.field_70177_z, (float)0.0f, (float)-1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            } else {
                this.applyAlignments();
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            for (EnumFacing facing : EnumFacing.values()) {
                this.renderQuads(vertexbuffer, ItemIcon.this.ibakedmodel.func_188616_a(null, facing, 0L), alphaColor);
            }
            this.renderQuads(vertexbuffer, ItemIcon.this.ibakedmodel.func_188616_a(null, null, 0L), alphaColor);
            tessellator.func_78381_a();
            this.postRender();
        }

        private void applyAlignments() {
            switch (this.getHorizontalAlign()) {
                case CENTER: {
                    GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)0.0f);
                    break;
                }
                case LEFT: {
                    GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                }
            }
            switch (this.getVerticalAlign()) {
                case MIDDLE: {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
                    break;
                }
                case TOP: {
                    GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                }
            }
        }

        private void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color) {
            int j = quads.size();
            for (int i = 0; i < j; ++i) {
                LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)quads.get(i), (int)color);
            }
        }
    }
}

