/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.client.thermalvision;

import ben_mkiv.rendertoolkit.client.thermalvision.ShaderHelper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;

public final class VazkiiShaderHelper {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    static int thermalColorShader = 0;
    private static boolean lighting;

    static void initShaders() {
        if (Minecraft.func_71410_x().func_110442_L() instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(manager -> {
                if (thermalColorShader != 0) {
                    ARBShaderObjects.glDeleteObjectARB((int)thermalColorShader);
                }
                thermalColorShader = 0;
                VazkiiShaderHelper.loadShaders();
            });
        }
    }

    private static void loadShaders() {
        if (!VazkiiShaderHelper.useShaders()) {
            return;
        }
        thermalColorShader = VazkiiShaderHelper.createProgram(null, "/assets/rendertoolkit/shaders/program/thermal_color.fsh");
    }

    static void useShader(int shader, ShaderCallback callback) {
        if (!VazkiiShaderHelper.useShaders() || shader == 0) {
            return;
        }
        lighting = GL11.glGetBoolean((int)2896);
        GlStateManager.func_179140_f();
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (callback != null) {
            callback.call(shader);
        }
    }

    static void releaseShader() {
        if (lighting) {
            GlStateManager.func_179145_e();
        }
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    private static boolean useShaders() {
        return OpenGlHelper.field_148824_g;
    }

    private static int createProgram(String vert, String frag) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            vertId = VazkiiShaderHelper.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = VazkiiShaderHelper.createShader(frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            System.out.println(VazkiiShaderHelper.getLogInfo(program));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            System.out.println(VazkiiShaderHelper.getLogInfo(program));
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)VazkiiShaderHelper.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + VazkiiShaderHelper.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String getLogInfo(int shader) {
        return ARBShaderObjects.glGetInfoLogARB((int)shader, (int)ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35716));
    }

    private static String readFileAsString(String filename) throws Exception {
        InputStream in = ShaderHelper.class.getResourceAsStream(filename);
        if (in == null) {
            return "";
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    @FunctionalInterface
    public static interface ShaderCallback {
        public void call(int var1);
    }
}

