/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import appeng.api.AEApi;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AELog;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import appeng.util.iterators.AEInvIterator;
import appeng.util.iterators.InvIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class AppEngInternalAEInventory
implements IItemHandlerModifiable,
Iterable<ItemStack> {
    private final IAEAppEngInventory te;
    private final IAEItemStack[] inv;
    private final int size;
    private int maxStack;
    private boolean dirtyFlag = false;

    public AppEngInternalAEInventory(IAEAppEngInventory te, int s) {
        this.te = te;
        this.size = s;
        this.maxStack = 64;
        this.inv = new IAEItemStack[s];
    }

    public void setMaxStackSize(int s) {
        this.maxStack = s;
    }

    public IAEItemStack getAEStackInSlot(int var1) {
        return this.inv[var1];
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = new NBTTagCompound();
        this.writeToNBT(c);
        data.func_74782_a(name, (NBTBase)c);
    }

    private void writeToNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = new NBTTagCompound();
                if (this.inv[x] != null) {
                    this.inv[x].writeToNBT(c);
                }
                target.func_74782_a("#" + x, (NBTBase)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = data.func_74775_l(name);
        if (c != null) {
            this.readFromNBT(c);
        }
    }

    private void readFromNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = target.func_74775_l("#" + x);
                if (c == null) continue;
                this.inv[x] = AEItemStack.fromNBT(c);
                continue;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    public int getSlots() {
        return this.size;
    }

    public ItemStack getStackInSlot(int var1) {
        if (this.inv[var1] == null) {
            return ItemStack.field_190927_a;
        }
        return this.inv[var1].createItemStack();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.inv[slot] = (IAEItemStack)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.fireOnChangeInventory(slot, InvOperation.INSERT, ItemStack.field_190927_a, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.inv[slot] != null) {
            ItemStack split = this.getStackInSlot(slot);
            if (amount >= split.func_190916_E()) {
                if (!simulate) {
                    this.inv[slot] = null;
                    this.fireOnChangeInventory(slot, InvOperation.EXTRACT, split, ItemStack.field_190927_a);
                }
                return split;
            }
            if (!simulate) {
                split.func_190917_f(-amount);
                this.fireOnChangeInventory(slot, InvOperation.EXTRACT, ItemHandlerHelper.copyStackWithSize((ItemStack)split, (int)amount), ItemStack.field_190927_a);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)split, (int)amount);
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack newItemStack) {
        ItemStack oldStack = this.getStackInSlot(slot).func_77946_l();
        this.inv[slot] = (IAEItemStack)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(newItemStack);
        if (this.te != null && Platform.isServer()) {
            ItemStack newStack = newItemStack.func_77946_l();
            InvOperation op = InvOperation.SET;
            if (ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack)) {
                if (newStack.func_190916_E() > oldStack.func_190916_E()) {
                    newStack.func_190918_g(oldStack.func_190916_E());
                    oldStack = ItemStack.field_190927_a;
                    op = InvOperation.INSERT;
                } else {
                    oldStack.func_190918_g(newStack.func_190916_E());
                    newStack = ItemStack.field_190927_a;
                    op = InvOperation.EXTRACT;
                }
            }
            this.fireOnChangeInventory(slot, op, oldStack, newStack);
        }
    }

    private void fireOnChangeInventory(int slot, InvOperation op, ItemStack removed, ItemStack inserted) {
        if (this.te != null && Platform.isServer() && !this.dirtyFlag) {
            this.dirtyFlag = true;
            this.te.onChangeInventory((IItemHandler)this, slot, op, removed, inserted);
            this.te.saveChanges();
            this.dirtyFlag = false;
        }
    }

    public int getSlotLimit(int slot) {
        return this.maxStack > 64 ? 64 : this.maxStack;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new InvIterator((IItemHandler)this);
    }

    public Iterator<IAEItemStack> getNewAEIterator() {
        return new AEInvIterator(this);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }
}

