## 3D World Widget
![](https://i.imgur.com/s0cEoup.png)
### this widget requires [sneaking](Glasses#sneaking) + [swimming](Glasses#swimming) upgrades

## EntityTracker3D
```lua
widget = component.glasses.addEntityTracker3D()
-- adds a EntityTracker3D to the 3D World Space
```
```lua
widget.loadOBJ(String:waveFrontObjectData)
-- loads the model, which is displayed at entities, from the parsed object data

widget.setTrackingType(String:trackingtype, Integer:radius)
-- trackingtype - [NONE, ALL, UNIQUE, ITEM, LIVING, PLAYER, NEUTRAL, HOSTILE]
-- radius - area around the player to search for entities

widget.setTrackingFilter(String:type, Integer:metaindex)
-- type - item/creature name
-- metaindex - metadata used for items/blocks

widget.setTrackingEntity(String:uniqueid)
-- uniqueid - entitys unique id
-- sets the uuid for the unique filter, "none" or empty String disables the filter
```

### demo
```lua
-- this example is part of the openglasses demo lootdisk, which is available ingame

-- load some mesh as marker
fh = io.open("/usr/wavefrontObjects/cubeMatrix.obj", "r")
wavefrontObj = fh:read("*a")
fh:close()

-- load glasses terminal and remove old widgets
glassesTerminal = require("component").glasses
glassesTerminal.removeAll()


-- add a entity tracker which filters for living creatures
entityTracker = glassesTerminal.addEntityTracker3D()
entityTracker.loadOBJ(wavefrontObj)
entityTracker.setTrackingType("living", 32)
entityTracker.addTranslation(0, 0.5, 0)
```

### examples
```lua
widget.setTrackingType("NEUTRAL", 32)
-- tracks all neutral entities in a radius of 32 blocks (players and animals)
```
```lua
widget.setTrackingFilter("sheep")
-- searches for sheeps in a radius of 32 blocks
```
```lua
widget.setTrackingType("ITEM", 32)
widget.setTrackingFilter("minecraft:cobblestone", 0)
-- searches for cobblestone items on the ground
```
```lua
widget.setTrackingType("ALL", 32)
-- tracks everything in a radius of 32 blocks
```

### methods
* [default](Widget_Methods_default)
  * [getID](Widget_Methods_default#getID)
  * [removeWidget](Widget_Methods_default#removeWidget)
  * [getRenderPosition](Widget_Methods_getRenderPosition)
* [private](Widget_Methods_private)
  * [getOwner](Widget_Methods_private#getOwner)
  * [getOwnerUUID](Widget_Methods_private#getOwnerUUID)
  * [setOwner](Widget_Methods_private#setOwner)
* [visibility](Widget_Methods_visibility)
  * [getLookingAt](Widget3D_Methods_visibility#getLookingAt)
  * [setLookingAt](Widget3D_Methods_visibility#setLookingAt)
  * [getViewDistance](Widget3D_Methods_visibility#getViewDistance)
  * [setViewDistance](Widget3D_Methods_visibility#setViewDistance)
  * [isVisible](Widget_Methods_visibility#isVisible)
  * [setVisible](Widget_Methods_visibility#setVisible)
  * [isVisibleThroughObjects](Widget3D_Methods_visibility#isVisibleThroughObjects)
  * [setVisibleThroughObjects](Widget3D_Methods_visibility#setVisibleThroughObjects)
* [Modifier Methods](WidgetModifiers)
  * [setFaceWidgetToPlayer](WidgetModifier_setFaceWidgetToPlayer)
  * [addColor](WidgetModifiers#addColor)
  * [addRotation](WidgetModifiers#addRotation)
  * [addScale](WidgetModifiers#addScale)
  * [addTranslation](WidgetModifiers#addTranslation)
  * [getModifiers](WidgetModifierMethods#getModifiers)
  * [removeModifier](WidgetModifierMethods#removeModifier)
  * [setCondition](WidgetModifierConditions)
* [Modifier Animation](WidgetModifiers#animation)
  * [setEasing](WidgetModifiers#seteasing)
  * [removeEasing](WidgetModifiers#removeeasing)