/*
 * Decompiled with CFR 0.152.
 */
package toast.lavaMonsters;

import java.util.HashMap;
import java.util.Random;
import net.minecraftforge.common.config.Configuration;
import toast.lavaMonsters._LavaMonsters;

public abstract class Properties {
    private static final HashMap<String, Object> map = new HashMap();
    public static final String GENERAL = "_general";
    public static final String SPAWNING = "spawning";

    public static void init(Configuration config) {
        config.load();
        Properties.add(config, GENERAL, "animated_texture", true, "If true, lava monsters will have animated textures.");
        Properties.add(config, GENERAL, "monster_armor", 0, "The amount of armor lava monsters have.");
        Properties.add(config, GENERAL, "monster_health", 16.0, "Lava monsters' maximum health.");
        Properties.add(config, GENERAL, "monster_attack_cooldown", 80, "Ticks a monster must wait after attacking before it can start winding up again.");
        Properties.add(config, GENERAL, "monster_attack_shots", 3, "Number of fireballs shot with each attack.");
        Properties.add(config, GENERAL, "monster_attack_spacing", 6, "Ticks between each fireball shot in an attack.");
        Properties.add(config, GENERAL, "monster_attack_windup", 60, "Ticks it takes before a monster can start an attack.");
        Properties.add(config, SPAWNING, "Nether_spawn", true, "If true, lava monsters will spawn in the Nether.");
        Properties.add(config, SPAWNING, "depth_hazard", false, "If true, lava monsters will not spawn above layer 16.");
        Properties.add(config, SPAWNING, "flowing_lava", false, "If true, lava monsters do not require a source block to spawn.");
        Properties.add(config, SPAWNING, "shallow_lava", false, "If true, lava monsters will be able to spawn in lava one block deep.");
        Properties.add(config, SPAWNING, "spawn_chance", 0.05, "The chance for a lava monster spawn attempt to be successful.");
        Properties.add(config, SPAWNING, "spawn_frequency", 10, "The number of ticks between each lava monster spawn attempt.");
        config.addCustomCategoryComment(GENERAL, "General and/or miscellaneous options.");
        config.addCustomCategoryComment(SPAWNING, "Options dictating the spawning algorithm for lava monsters.");
        config.save();
    }

    public static Random random() {
        return _LavaMonsters.random;
    }

    public static void debugException(String message) {
        _LavaMonsters.debugException(message);
    }

    public static void add(Configuration config, String category, String field, String defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getString());
    }

    public static void add(Configuration config, String category, String field, int defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getInt(defaultValue));
    }

    public static void add(Configuration config, String category, String field, boolean defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getBoolean(defaultValue));
    }

    public static void add(Configuration config, String category, String field, double defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getDouble(defaultValue));
    }

    public static Object getProperty(String category, String field) {
        return map.get(category + "@" + field);
    }

    public static String getString(String category, String field) {
        return Properties.getProperty(category, field).toString();
    }

    public static boolean getBoolean(String category, String field) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof Integer) {
            return Properties.random().nextInt(((Number)property).intValue()) == 0;
        }
        if (property instanceof Double) {
            return Properties.random().nextDouble() < ((Number)property).doubleValue();
        }
        Properties.debugException("Tried to get boolean for invalid property! @" + property == null ? "(null)" : property.getClass().getName());
        return false;
    }

    public static int getInt(String category, String field) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof Boolean) {
            return (Boolean)property != false ? 1 : 0;
        }
        Properties.debugException("Tried to get int for invalid property! @" + property == null ? "(null)" : property.getClass().getName());
        return 0;
    }

    public static double getDouble(String category, String field) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Number) {
            return ((Number)property).doubleValue();
        }
        if (property instanceof Boolean) {
            return (Boolean)property != false ? 1.0 : 0.0;
        }
        Properties.debugException("Tried to get double for invalid property! @" + property == null ? "(null)" : property.getClass().getName());
        return 0.0;
    }
}

