/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.util.HashMap;
import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.common.tileentity.TileEntityOSBase;

public class TileEntityEntityDetector
extends TileEntityOSBase {
    private int range = OpenSecurity.entityDetectorMaxRange;

    public TileEntityEntityDetector() {
        super("os_entdetector");
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector((double)(5 * OpenSecurity.entityDetectorMaxRange)).create();
    }

    public TileEntityEntityDetector(EnvironmentHost host) {
        super("os_entdetector", host);
    }

    private HashMap<String, Object> info(Entity entity, BlockPos offset) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        double rangeToEntity = entity.func_70011_f((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        String name = entity instanceof EntityPlayer ? ((EntityPlayer)entity).getDisplayNameString() : entity.func_70005_c_();
        BlockPos entityLocalPosition = entity.func_180425_c().func_177973_b((Vec3i)offset);
        value.put("name", name);
        value.put("range", rangeToEntity);
        value.put("x", entityLocalPosition.func_177958_n());
        value.put("y", entityLocalPosition.func_177956_o());
        value.put("z", entityLocalPosition.func_177952_p());
        this.node.sendToReachable("computer.signal", new Object[]{"entityDetect", name, rangeToEntity, entityLocalPosition.func_177958_n(), entityLocalPosition.func_177956_o(), entityLocalPosition.func_177952_p()});
        return value;
    }

    private Map<Integer, HashMap<String, Object>> scan(boolean players, BlockPos offset) {
        HashMap<Integer, HashMap<String, Object>> output = new HashMap<Integer, HashMap<String, Object>>();
        int index = 1;
        for (Entity entity : this.func_145831_w().func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v(), this.func_174877_v()).func_186662_g((double)this.range))) {
            if (players && entity instanceof EntityPlayer) {
                output.put(index++, this.info(entity, offset));
                continue;
            }
            if (players || entity instanceof EntityPlayer) continue;
            output.put(index++, this.info(entity, offset));
        }
        return output;
    }

    @Callback(doc="function(optional:int:range):table; pushes a signal \"entityDetect\" for each player in range, optional set range.")
    public Object[] scanPlayers(Context context, Arguments args) {
        this.range = Math.min(OpenSecurity.entityDetectorMaxRange, args.optInteger(0, this.range));
        if (!this.consumeEnergy(this.range)) {
            return new Object[]{false, "Not enough power in OC Network."};
        }
        return new Object[]{this.scan(true, this.func_174877_v())};
    }

    @Callback(doc="function(optional:int:range):table; pushes a signal \"entityDetect\" for each entity in range (excluding players), optional set range.")
    public Object[] scanEntities(Context context, Arguments args) {
        this.range = Math.min(OpenSecurity.entityDetectorMaxRange, args.optInteger(0, this.range));
        if (!this.consumeEnergy(this.range)) {
            return new Object[]{false, "Not enough power in OC Network."};
        }
        return new Object[]{this.scan(false, this.func_174877_v())};
    }

    private boolean consumeEnergy(int range) {
        return this.node.changeBuffer((double)(-5 * range)) == 0.0;
    }
}

