/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.client.particles.ParticleCloud;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import com.bobmowzie.mowziesmobs.server.item.ItemBarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemEarthTalisman;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemSpear;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerAttackMob;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerSolarBeam;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerSummonSunstrike;
import com.bobmowzie.mowziesmobs.server.message.MessageUnfreezeEntity;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageLeftMouseDown;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageLeftMouseUp;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageRightMouseDown;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageRightMouseUp;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.property.MowzieLivingProperties;
import com.bobmowzie.mowziesmobs.server.property.MowziePlayerProperties;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.bobmowzie.mowziesmobs.server.world.MowzieWorldGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public enum ServerEventHandler {
    INSTANCE;

    private static final int ICE;
    private static final int SUNSTRIKE_COOLDOWN = 55;
    private static final int SOLARBEAM_COOLDOWN = 110;

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityZombie) {
            ((EntityCreature)entity).field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityFoliaath.class, 0, true, false, null));
            ((EntityCreature)entity).field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityBarakoa.class, 0, true, false, null));
            ((EntityCreature)entity).field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityBarako.class, 0, true, false, null));
        }
        if (entity instanceof EntitySkeleton) {
            ((EntityCreature)entity).field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityBarakoa.class, 0, true, false, null));
            ((EntityCreature)entity).field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityBarako.class, 0, true, false, null));
        }
        if (entity instanceof EntityOcelot) {
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityFoliaath.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof EntityParrot) {
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityFoliaath.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof EntityAnimal) {
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityBarakoa.class, 6.0f, 1.0, 1.2));
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityFrostmaw.class, 10.0f, 1.0, 1.2));
        }
        if (entity instanceof EntityVillager) {
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityBarakoa.class, 6.0f, 1.0, 1.2));
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityFrostmaw.class, 10.0f, 1.0, 1.2));
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            MowzieLivingProperties property = (MowzieLivingProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entity, MowzieLivingProperties.class);
            if (property != null) {
                Item headItemStack;
                if (property.freezeProgress >= 1.0f) {
                    entity.func_70690_d(new PotionEffect((Potion)PotionHandler.FROZEN, 50, 1, false, false));
                    property.freezeProgress = 1.0f;
                } else if (property.freezeProgress > 0.0f) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 9, MathHelper.func_76141_d((float)(property.freezeProgress * 5.0f + 1.0f)), false, false));
                }
                if (entity.func_70644_a((Potion)PotionHandler.FROZEN) && !property.prevFrozen) {
                    property.onFreeze(entity);
                }
                if (!entity.field_70170_p.field_72995_K && (headItemStack = entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b()) instanceof ItemBarakoaMask) {
                    ItemBarakoaMask mask = (ItemBarakoaMask)headItemStack;
                    entity.func_70690_d(new PotionEffect(mask.getPotion(), 45, 0, true, false));
                }
            }
            if (entity.func_70660_b((Potion)PotionHandler.POISON_RESIST) != null && entity.func_70660_b(MobEffects.field_76436_u) != null) {
                entity.func_184596_c(MobEffects.field_76436_u);
            }
            if (entity.func_70644_a((Potion)PotionHandler.FROZEN)) {
                if (entity.func_70660_b((Potion)PotionHandler.FROZEN).func_76459_b() <= 0) {
                    entity.func_184596_c((Potion)PotionHandler.FROZEN);
                }
                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 9, 50, false, false));
                entity.func_70095_a(false);
                if (entity.field_70170_p.field_72995_K && entity.field_70173_aa % 2 == 0) {
                    double cloudX = entity.field_70165_t + (double)entity.field_70130_N * Math.random() - (double)(entity.field_70130_N / 2.0f);
                    double cloudZ = entity.field_70161_v + (double)entity.field_70130_N * Math.random() - (double)(entity.field_70130_N / 2.0f);
                    double cloudY = entity.field_70163_u + (double)entity.field_70131_O * Math.random();
                    MMParticle.CLOUD.spawn(entity.field_70170_p, cloudX, cloudY, cloudZ, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(new Object[]{0.0, -0.01, 0.0, 0.75, 0.75, 1.0, 1, 15.0, 25, ParticleCloud.EnumCloudBehavior.CONSTANT}));
                    double snowX = entity.field_70165_t + (double)entity.field_70130_N * Math.random() - (double)(entity.field_70130_N / 2.0f);
                    double snowZ = entity.field_70161_v + (double)entity.field_70130_N * Math.random() - (double)(entity.field_70130_N / 2.0f);
                    double snowY = entity.field_70163_u + (double)entity.field_70131_O * Math.random();
                    MMParticle.SNOWFLAKE.spawn(entity.field_70170_p, snowX, snowY, snowZ, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(0.0, -0.01, 0.0));
                }
            } else if (property != null && property.frozenController != null && !property.frozenController.field_70128_L) {
                entity.func_110145_l((Entity)property.frozenController);
                entity.func_70107_b(property.frozenController.field_70165_t, property.frozenController.field_70163_u, property.frozenController.field_70161_v);
                property.frozenController.func_70106_y();
                entity.func_184185_a(MMSounds.ENTITY_FROSTMAW_FROZEN_CRASH, 1.0f, 0.5f);
                if (entity.field_70170_p.field_72995_K) {
                    int particleCount = (int)(10.0f + 1.0f * entity.field_70131_O * entity.field_70130_N * entity.field_70130_N);
                    for (int i = 0; i < particleCount; ++i) {
                        double particleX = entity.field_70165_t + (double)entity.field_70130_N * Math.random() - (double)(entity.field_70130_N / 2.0f);
                        double particleZ = entity.field_70161_v + (double)entity.field_70130_N * Math.random() - (double)(entity.field_70130_N / 2.0f);
                        double particleY = entity.field_70163_u + (double)entity.field_70131_O * Math.random() + (double)0.3f;
                        entity.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, particleX, particleY, particleZ, 0.0, 0.0, 0.0, new int[]{ICE});
                    }
                }
                if (entity instanceof EntityLiving && ((EntityLiving)entity).func_175446_cd() && property.prevHasAI) {
                    ((EntityLiving)entity).func_94061_f(false);
                }
            }
            if (property != null) {
                property.freezeProgress = (float)((double)property.freezeProgress - 0.1);
                if (property.freezeProgress < 0.0f) {
                    property.freezeProgress = 0.0f;
                }
                property.prevFrozen = entity.func_70644_a((Potion)PotionHandler.FROZEN);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player == null) {
            return;
        }
        EntityPlayer player = event.player;
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class);
        if (property != null) {
            property.update();
            if (property.untilSunstrike > 0) {
                --property.untilSunstrike;
            }
            if (property.untilAxeSwing > 0) {
                --property.untilAxeSwing;
            }
            if (event.side == Side.SERVER) {
                for (ItemStack itemStack : event.player.field_71071_by.field_70462_a) {
                    if (!(itemStack.func_77973_b() instanceof ItemEarthTalisman)) continue;
                    player.func_70690_d(new PotionEffect((Potion)PotionHandler.GEOMANCY, 0, 0, false, false));
                }
                if (player.func_184592_cb().func_77973_b() instanceof ItemEarthTalisman) {
                    player.func_70690_d(new PotionEffect((Potion)PotionHandler.GEOMANCY, 0, 0, false, false));
                }
                List<EntityBarakoanToPlayer> pack = property.tribePack;
                float theta = (float)Math.PI * 2 / (float)pack.size();
                for (int i = 0; i < pack.size(); ++i) {
                    EntityBarakoanToPlayer barakoan = (EntityBarakoanToPlayer)pack.get(i);
                    barakoan.index = i;
                    if (barakoan.func_70638_az() != null) continue;
                    barakoan.func_70661_as().func_75492_a(player.field_70165_t + (double)((float)property.tribePackRadius * MathHelper.func_76134_b((float)(theta * (float)i))), player.field_70163_u, player.field_70161_v + (double)((float)property.tribePackRadius * MathHelper.func_76126_a((float)(theta * (float)i))), 0.45);
                    if (!(player.func_70032_d((Entity)barakoan) > 20.0f) || !player.field_70122_E) continue;
                    barakoan.func_70107_b(player.field_70165_t + (double)((float)property.tribePackRadius * MathHelper.func_76134_b((float)(theta * (float)i))), player.field_70163_u, player.field_70161_v + (double)((float)property.tribePackRadius * MathHelper.func_76126_a((float)(theta * (float)i))));
                }
            }
            if (player.func_184614_ca().func_77973_b() != ItemHandler.ICE_CRYSTAL && player.func_184592_cb().func_77973_b() != ItemHandler.ICE_CRYSTAL && property.usingIceBreath && property.icebreath != null) {
                property.usingIceBreath = false;
                property.icebreath.func_70106_y();
            }
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (property.usingIceBreath || stack.func_77973_b() != ItemHandler.ICE_CRYSTAL) continue;
                stack.func_77964_b(Math.max(stack.func_77952_i() - 1, 0));
            }
            for (ItemStack stack : player.field_71071_by.field_184439_c) {
                if (property.usingIceBreath || stack.func_77973_b() != ItemHandler.ICE_CRYSTAL) continue;
                stack.func_77964_b(Math.max(stack.func_77952_i() - 1, 0));
            }
            if (event.side == Side.CLIENT) {
                if (Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d() && !property.mouseLeftDown) {
                    property.mouseLeftDown = true;
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessageLeftMouseDown());
                    for (int i = 0; i < property.powers.length; ++i) {
                        property.powers[i].onLeftMouseDown(player);
                    }
                }
                if (Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && !property.mouseRightDown) {
                    property.mouseRightDown = true;
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessageRightMouseDown());
                    for (int i = 0; i < property.powers.length; ++i) {
                        property.powers[i].onRightMouseDown(player);
                    }
                }
                if (!Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d()) {
                    property.mouseLeftDown = false;
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessageLeftMouseUp());
                    for (int i = 0; i < property.powers.length; ++i) {
                        property.powers[i].onLeftMouseUp(player);
                    }
                }
                if (!Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && property.mouseRightDown) {
                    property.mouseRightDown = false;
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessageRightMouseUp());
                    for (int i = 0; i < property.powers.length; ++i) {
                        property.powers[i].onRightMouseUp(player);
                    }
                }
            }
            if (player.func_70093_af() && !property.prevSneaking) {
                for (int i = 0; i < property.powers.length; ++i) {
                    property.powers[i].onSneakDown(player);
                }
            } else if (!player.func_70093_af() && property.prevSneaking) {
                for (int i = 0; i < property.powers.length; ++i) {
                    property.powers[i].onSneakUp(player);
                }
            }
            property.prevSneaking = player.func_70093_af();
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onUpdate(event);
            }
        }
    }

    private List<EntityLivingBase> getEntityLivingBaseNearby(EntityLivingBase user, double distanceX, double distanceY, double distanceZ, double radius) {
        List list = user.field_70170_p.func_72839_b((Entity)user, user.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        ArrayList nearEntities = list.stream().filter(entityNeighbor -> entityNeighbor instanceof EntityLivingBase && (double)user.func_70032_d(entityNeighbor) <= radius).map(entityNeighbor -> (EntityLivingBase)entityNeighbor).collect(Collectors.toCollection(ArrayList::new));
        return nearEntities;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
        EntityPlayer player = event.getEntityPlayer();
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class);
        if (property != null) {
            if (event.getWorld().field_72995_K && player.field_71071_by.func_70448_g().func_190926_b() && player.func_70644_a((Potion)PotionHandler.SUNS_BLESSING) && ((MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class)).untilSunstrike <= 0) {
                if (player.func_70093_af()) {
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerSolarBeam());
                    property.untilSunstrike = 110;
                } else {
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerSummonSunstrike());
                    property.untilSunstrike = 55;
                }
            }
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onRightClickEmpty(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class);
        if (property != null) {
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onRightClickEntity(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class);
        if (property != null) {
            if (event.getWorld().field_72995_K && player.field_71071_by.func_70448_g().func_190926_b() && player.func_70644_a((Potion)PotionHandler.SUNS_BLESSING) && ((MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class)).untilSunstrike <= 0) {
                if (player.func_70093_af()) {
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerSolarBeam());
                    property.untilSunstrike = 110;
                } else {
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerSummonSunstrike());
                    property.untilSunstrike = 55;
                }
            }
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onRightClickBlock(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        double range = 7.0;
        EntityPlayer player = event.getEntityPlayer();
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class);
        if (property != null) {
            EntityLivingBase entityHit;
            if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == ItemHandler.SPEAR && (entityHit = ItemSpear.raytraceEntities(player.func_130014_f_(), player, range)) != null) {
                MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerAttackMob(entityHit));
            }
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onLeftClickEmpty(event);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        MowziePlayerProperties property;
        MowzieLivingProperties properties;
        if (event.getSource().func_76347_k() && event.getEntityLiving().func_70644_a((Potion)PotionHandler.FROZEN) && (properties = (MowzieLivingProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowzieLivingProperties.class)) != null) {
            event.getEntityLiving().func_184596_c((Potion)PotionHandler.FROZEN);
            event.getEntityLiving().func_110145_l((Entity)properties.frozenController);
            if (!event.getEntity().field_70170_p.field_72995_K) {
                MowziesMobs.NETWORK_WRAPPER.sendToDimension((IMessage)new MessageUnfreezeEntity(event.getEntityLiving()), event.getEntityLiving().field_71093_bK);
            }
        }
        if (event.getEntity() instanceof EntityPlayer && (property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class)) != null) {
            int i;
            if (event.getEntity() instanceof EntityPlayer && event.getSource().func_76346_g() != null) {
                for (i = 0; i < property.getPackSize(); ++i) {
                    if (property.tribePack.get(i).func_70638_az() != null) continue;
                    property.tribePack.get(i).func_70624_b((EntityLivingBase)event.getSource().func_76346_g());
                }
            }
            for (i = 0; i < property.powers.length; ++i) {
                property.powers[i].onTakeDamage(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class);
        if (property != null) {
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onRightClickWithItem(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class);
        if (property != null) {
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onLeftClickBlock(event);
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        MowziePlayerProperties property;
        EntityLivingBase entity;
        MowzieLivingProperties property2;
        if (event.getEntity() instanceof EntityLivingBase && (property2 = (MowzieLivingProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)(entity = (EntityLivingBase)event.getEntity()), MowzieLivingProperties.class)) != null && entity.func_70644_a((Potion)PotionHandler.FROZEN) && entity.field_70122_E) {
            entity.field_70181_x = 0.0;
        }
        if (event.getEntity() instanceof EntityPlayer && (property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class)) != null) {
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onJump(event);
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttack(AttackEntityEvent event) {
        MowziePlayerProperties property;
        if (event.getEntityLiving().func_70644_a((Potion)PotionHandler.FROZEN)) {
            event.setCanceled(true);
        }
        if (event.getEntity() instanceof EntityPlayer && (property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class)) != null) {
            int i;
            for (i = 0; i < property.powers.length; ++i) {
                property.powers[i].onLeftClickEntity(event);
            }
            if (!(event.getTarget() instanceof EntityLivingBase)) {
                return;
            }
            if (event.getTarget() instanceof EntityBarakoanToPlayer) {
                return;
            }
            for (i = 0; i < property.getPackSize(); ++i) {
                property.tribePack.get(i).func_70624_b((EntityLivingBase)event.getTarget());
            }
        }
    }

    @SubscribeEvent
    public void onChat(ServerChatEvent event) {
        String[] words = event.getMessage().split("\\W");
        boolean dab = false;
        for (String word : words) {
            if (!word.equalsIgnoreCase("dab")) continue;
            dab = true;
            break;
        }
        if (dab) {
            float dist = 20.5f;
            EntityPlayerMP player = event.getPlayer();
            AxisAlignedBB bounds = player.func_174813_aQ().func_72314_b(20.5, 20.5, 20.5);
            List wroughtnauts = player.field_70170_p.func_72872_a(EntityWroughtnaut.class, bounds);
            for (EntityWroughtnaut wroughtnaut : wroughtnauts) {
                if (!wroughtnaut.isActive() || !(wroughtnaut.func_70092_e(player.field_70165_t, player.field_70163_u, player.field_70161_v) <= 420.25)) continue;
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)wroughtnaut, EntityWroughtnaut.DAB_ANIMATION);
            }
        }
    }

    @SubscribeEvent
    public void prePopulateWorld(PopulateChunkEvent.Pre event) {
        MowzieWorldGenerator.generatePrePopulate(event.getWorld(), event.getRand(), event.getChunkX(), event.getChunkZ());
    }

    static {
        ICE = Block.func_176210_f((IBlockState)Blocks.field_150432_aD.func_176223_P());
    }
}

