/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.FractionalDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDrawersComp
extends TileEntityDrawers {
    @CapabilityInject(value=IDrawerAttributes.class)
    static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = null;
    private GroupData groupData = new GroupData(3);
    private int capacity = 0;

    public TileEntityDrawersComp() {
        this.groupData.setCapabilityProvider(this);
        this.injectPortableData(this.groupData);
    }

    @Override
    public IDrawerGroup getGroup() {
        return this.groupData;
    }

    @Override
    protected void onAttributeChanged() {
        this.groupData.syncAttributes();
    }

    @Override
    public int getDrawerCapacity() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return super.getDrawerCapacity();
        }
        if (this.capacity == 0) {
            ConfigManager config = StorageDrawers.config;
            this.capacity = config.getBlockBaseStorage("compdrawers");
            if (this.capacity <= 0) {
                this.capacity = 1;
            }
        }
        return this.capacity;
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientUpdateCount(int slot, int count) {
        if (!this.func_145831_w().field_72995_K) {
            return;
        }
        Minecraft.func_71410_x().func_152344_a(() -> this.clientUpdateCountAsync(count));
    }

    @SideOnly(value=Side.CLIENT)
    private void clientUpdateCountAsync(int count) {
        this.groupData.setPooledCount(count);
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? super.func_70005_c_() : "storagedrawers.container.compDrawers";
    }

    private class GroupData
    extends FractionalDrawerGroup {
        public GroupData(int slotCount) {
            super(slotCount);
        }

        @Override
        protected World getWorld() {
            return TileEntityDrawersComp.this.func_145831_w();
        }

        @Override
        protected void log(String message) {
            if (!this.getWorld().field_72995_K && StorageDrawers.config.cache.debugTrace) {
                StorageDrawers.log.info(message);
            }
        }

        @Override
        protected int getStackCapacity() {
            return TileEntityDrawersComp.this.upgrades().getStorageMultiplier() * TileEntityDrawersComp.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                TileEntityDrawersComp.this.func_70296_d();
                TileEntityDrawersComp.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                CountUpdateMessage message = new CountUpdateMessage(TileEntityDrawersComp.this.func_174877_v(), 0, this.getPooledCount());
                NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(this.getWorld().field_73011_w.getDimension(), (double)TileEntityDrawersComp.this.func_174877_v().func_177958_n(), (double)TileEntityDrawersComp.this.func_174877_v().func_177956_o(), (double)TileEntityDrawersComp.this.func_174877_v().func_177952_p(), 500.0);
                StorageDrawers.network.sendToAllAround((IMessage)message, targetPoint);
                TileEntityDrawersComp.this.func_70296_d();
            }
        }

        @Override
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == DRAWER_ATTRIBUTES_CAPABILITY || super.hasCapability(capability, facing);
        }

        @Override
        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == DRAWER_ATTRIBUTES_CAPABILITY) {
                return (T)TileEntityDrawersComp.this.getDrawerAttributes();
            }
            return super.getCapability(capability, facing);
        }
    }
}

