# Widget Modifier Conditions

### Examples
```lua
-- add some color modifier to a widget
modifierIndex = widget.addColor(1, 0, 0, 0)
-- requires the user to sneak to activate the modifier
widget.setCondition(modifierIndex, "IS_SNEAKING", true)

-- disable the sneak condition
widget.setCondition(modifierIndex, "IS_SNEAKING", false)
```
conditions can be combined like in this example
```lua
-- require lightlevel between 10-14 to activate the modifier
modifierIndex = widget.addColor(1, 0, 0, 0)
widget.setCondition(modifierIndex, "IS_LIGHTLEVEL_MIN_10", true)
widget.setCondition(modifierIndex, "IS_LIGHTLEVEL_MAX_14", true)
```

## Conditions
### Light
* `IS_LIGHTLEVEL_MIN_[0-15]`
* `IS_LIGHTLEVEL_MAX_[0-15]`

requires [upgrade](Glasses#light)

### Weather
* `IS_WEATHER_RAIN`
* `IS_WEATHER_CLEAR`

requires [upgrade](Glasses#weather)

### Swimming
* `IS_SWIMMING`
* `IS_NOT_SWIMMING`

requires [upgrade](Glasses#swimming)

### Sneaking
* `IS_SNEAKING`
* `IS_NOT_SNEAKING`

requires [upgrade](Glasses#sneaking)

### OverlayActive
* `OVERLAY_ACTIVE`
* `OVERLAY_INACTIVE`

### EntityTracker
these conditions are only useful for the entity tracker
* `IS_FOCUSED_ENTITY`
* `IS_LIVING`
* `IS_PLAYER`
* `IS_NEUTRAL`
* `IS_HOSTILE`
* `IS_ITEM`