/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.fluid;

import codechicken.lib.fluid.FluidUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class ExtendedFluidTank
implements IFluidTank {
    private FluidStack fluid;
    private boolean changeType;
    private int capacity;

    public ExtendedFluidTank(FluidStack type, int capacity) {
        if (type == null) {
            type = FluidUtils.emptyFluid();
            this.changeType = true;
        }
        this.fluid = FluidUtils.copy(type, 0);
        this.capacity = capacity;
    }

    public ExtendedFluidTank(int capacity) {
        this(null, capacity);
    }

    public FluidStack getFluid() {
        return this.fluid.copy();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean canAccept(FluidStack type) {
        return type == null || this.fluid.amount == 0 && this.changeType || this.fluid.isFluidEqual(type);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!this.canAccept(resource)) {
            return 0;
        }
        int tofill = Math.min(this.getCapacity() - this.fluid.amount, resource.amount);
        if (doFill && tofill > 0) {
            if (!this.fluid.isFluidEqual(resource)) {
                this.fluid = FluidUtils.copy(resource, this.fluid.amount + tofill);
            } else {
                this.fluid.amount += tofill;
            }
            this.onLiquidChanged();
        }
        return tofill;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluid.amount == 0 || maxDrain <= 0) {
            return null;
        }
        int todrain = Math.min(maxDrain, this.fluid.amount);
        if (doDrain && todrain > 0) {
            this.fluid.amount -= todrain;
            this.onLiquidChanged();
        }
        return FluidUtils.copy(this.fluid, todrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.fluid)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public void onLiquidChanged() {
    }

    public void fromTag(NBTTagCompound tag) {
        this.fluid = FluidUtils.read(tag);
    }

    public NBTTagCompound toTag() {
        return FluidUtils.write(this.fluid, new NBTTagCompound());
    }

    public int getFluidAmount() {
        return this.fluid.amount;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }
}

