/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.utils;

import ben_mkiv.rendertoolkit.surface.WidgetCollection;
import com.bymarcin.openglasses.network.packet.HostInfoPacket;
import com.bymarcin.openglasses.surface.OCClientSurface;
import java.util.UUID;
import li.cil.oc.common.tileentity.Robot;
import li.cil.oc.common.tileentity.RobotProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class OpenGlassesHostClient
extends WidgetCollection {
    public Vec3d renderPosition = new Vec3d(0.0, 0.0, 0.0);
    public Entity renderEntity = null;
    public UUID renderEntityUUID = null;
    public int renderEntityID = -1;
    public int renderEntityDimension;
    public li.cil.oc.api.internal.Robot renderEntityRobot;
    public boolean absoluteRenderPosition = false;
    public UUID hostUUID;
    public String terminalName = "";
    public HostInfoPacket.HostType hostType = HostInfoPacket.HostType.TERMINAL;
    public boolean isInternal = false;
    private static final Vec3d renderOffsetTabletDrone = new Vec3d(0.5, 0.0, 0.5);
    public static final Vec3d renderOffsetRobotCaseMicroController = new Vec3d(0.5, 0.5, 0.5);

    public OpenGlassesHostClient(UUID hostUUID) {
        this.hostUUID = hostUUID;
    }

    public li.cil.oc.api.internal.Robot getRobotEntity() {
        TileEntity tile;
        if (this.renderEntityRobot == null && this.renderEntityDimension == Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() && (tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(this.renderPosition))) instanceof RobotProxy) {
            this.renderEntityRobot = ((RobotProxy)tile).robot();
        }
        return this.renderEntityRobot;
    }

    private Entity getRenderEntity() {
        switch (this.hostType) {
            case TABLET: 
            case DRONE: {
                if (this.renderEntity == null && this.renderEntityID != -1 && this.renderEntityDimension == Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w.getDimension()) {
                    this.renderEntity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.renderEntityID);
                }
                return this.renderEntity;
            }
        }
        return null;
    }

    private Vec3d getRobotLocation(li.cil.oc.api.internal.Robot robot, float partialTicks) {
        if (robot == null) {
            return this.renderPosition;
        }
        Robot casted = (Robot)robot;
        Vec3d offset = new Vec3d(0.0, 0.0, 0.0);
        if (casted != null && casted.isAnimatingMove()) {
            double remaining = (double)((float)casted.animationTicksLeft() - partialTicks) / (double)casted.animationTicksTotal();
            Vec3d location = new Vec3d((double)casted.position().x(), (double)casted.position().y(), (double)casted.position().z());
            Vec3d moveFrom = new Vec3d((Vec3i)casted.moveFrom().get()).func_178788_d(location);
            offset = moveFrom.func_186678_a(remaining);
        }
        this.renderPosition = new Vec3d(robot.xPosition(), robot.yPosition(), robot.zPosition()).func_178787_e(offset);
        return this.renderPosition;
    }

    public Vec3d getRenderPosition(float partialTicks) {
        switch (this.hostType) {
            case TABLET: 
            case DRONE: {
                return OCClientSurface.getEntityLocation(this.getRenderEntity(), partialTicks).func_178788_d(renderOffsetTabletDrone);
            }
            case ROBOT: {
                return this.getRobotLocation(this.getRobotEntity(), partialTicks).func_178788_d(renderOffsetRobotCaseMicroController);
            }
        }
        return this.renderPosition;
    }
}

