/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.gui;

import ben_mkiv.guitoolkit.client.widget.prettyElement;
import ben_mkiv.guitoolkit.client.widget.prettyGuiList;
import ben_mkiv.rendertoolkit.surface.ClientSurface;
import com.bymarcin.openglasses.gui.hostGuiElement;
import com.bymarcin.openglasses.item.upgrades.UpgradeNavigation;
import com.bymarcin.openglasses.network.packet.GlassesEventPacket;
import com.bymarcin.openglasses.surface.OCClientSurface;
import com.bymarcin.openglasses.utils.GlassesInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.Vec3d;

public class TerminalHostsList
extends prettyGuiList {
    private HashMap<Integer, ArrayList<String>> data = new HashMap();
    private HashMap<Integer, HashSet<prettyElement>> elements = new HashMap();
    private int elementCount = 0;

    TerminalHostsList(int width, int height, int top, int left, int entryHeight, int screenWidth, int screenHeight) {
        super(width, height, top, top + height, left, entryHeight, screenWidth, screenHeight);
    }

    public void add(Collection<GlassesInstance.HostClient> hosts) {
        ArrayList<GlassesInstance.HostClient> list = new ArrayList<GlassesInstance.HostClient>(hosts);
        Collections.sort(list, new SortHostClient());
        for (GlassesInstance.HostClient host : list) {
            this.add(host);
        }
    }

    public void add(GlassesInstance.HostClient host) {
        HashSet<hostGuiElement.hostAction> listElements = new HashSet<hostGuiElement.hostAction>();
        listElements.add(new hostGuiElement.GlassesEventButton(host.uuid, 170, 10, 60, 20, "clear link", GlassesEventPacket.EventType.CLEAR_LINK));
        listElements.add(new renderWorldButton(host));
        listElements.add(new renderOverlayButton(host));
        listElements.add(new worldEventsButton(host));
        listElements.add(new overlayEventsButton(host));
        ArrayList<String> text = new ArrayList<String>();
        if (host.getHost().terminalName.length() > 0) {
            text.add("'" + host.getHost().terminalName + "' (" + host.uuid.toString() + ")");
        } else {
            text.add(host.uuid.toString());
        }
        text.add("linked as " + host.ownerName);
        Vec3d renderPosition = host.getHost().getRenderPosition(0.5f);
        if (renderPosition.equals((Object)ClientSurface.vec3d000)) {
            text.add("distance: unknown");
        } else {
            text.add("distance: " + (int)Math.round(renderPosition.func_72438_d(Minecraft.func_71410_x().field_71439_g.func_174791_d())) + " blocks");
        }
        boolean renderAbsolute = host.getHost().absoluteRenderPosition;
        text.add("renderposition: " + (renderAbsolute ? "absolute" : "relative"));
        if (renderAbsolute && !UpgradeNavigation.hasUpgrade(OCClientSurface.glasses.get())) {
            text.add("\u00a7cworld widgets require navigation upgrade");
        }
        this.elements.put(this.elementCount, listElements);
        this.data.put(this.elementCount, text);
        ++this.elementCount;
    }

    void clear() {
        this.elementCount = 0;
        this.elements.clear();
        this.data.clear();
    }

    public int getSize() {
        return this.elementCount;
    }

    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        int textColor;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.elements.containsKey(slotIdx)) {
            for (prettyElement element : this.elements.get(slotIdx)) {
                element.setRenderY(slotTop);
                element.setRenderX(this.left);
                if (!(element instanceof GuiButton)) continue;
                ((GuiButton)element).field_146124_l = this.isSelected(slotIdx);
                ((GuiButton)element).func_191745_a(mc, this.mouseX, this.mouseY, mc.func_184121_ak());
            }
        }
        int n = textColor = this.isSelected(slotIdx) ? 0xFFFFFF : 0xDADADA;
        if (this.data.containsKey(slotIdx)) {
            for (String text : this.data.get(slotIdx)) {
                Minecraft.func_71410_x().field_71466_p.func_78276_b(" " + text, this.left, slotTop, textColor);
                slotTop += 10;
            }
        }
    }

    protected void elementClicked(int index, boolean doubleClick) {
        if (this.elements.containsKey(index)) {
            for (prettyElement element : this.elements.get(index)) {
                if (!(element instanceof hostGuiElement.hostAction) || !(element instanceof GuiButton) || !((GuiButton)element).field_146124_l || !((GuiButton)element).func_146115_a()) continue;
                element.clicked();
            }
        }
        super.elementClicked(index, doubleClick);
    }

    static class renderOverlayButton
    extends hostGuiElement.hostCheckbox
    implements hostGuiElement.hostAction {
        renderOverlayButton(GlassesInstance.HostClient host) {
            super(host.uuid, 3, 60, "render overlay", host.renderOverlay);
        }

        public void clicked() {
            this.sendEvent(this.isEnabled() ? GlassesEventPacket.EventType.DISABLE_OVERLAY_RENDER : GlassesEventPacket.EventType.ENABLE_OVERLAY_RENDER);
        }
    }

    static class renderWorldButton
    extends hostGuiElement.hostCheckbox
    implements hostGuiElement.hostAction {
        renderWorldButton(GlassesInstance.HostClient host) {
            super(host.uuid, 3, 45, "render world", host.renderWorld);
        }

        public void clicked() {
            this.sendEvent(this.isEnabled() ? GlassesEventPacket.EventType.DISABLE_WORLD_RENDER : GlassesEventPacket.EventType.ENABLE_WORLD_RENDER);
        }
    }

    static class overlayEventsButton
    extends hostGuiElement.hostCheckbox
    implements hostGuiElement.hostAction {
        overlayEventsButton(GlassesInstance.HostClient host) {
            super(host.uuid, 110, 60, "overlay events", host.sendOverlayEvents);
        }

        public void clicked() {
            this.sendEvent(this.isEnabled() ? GlassesEventPacket.EventType.DISABLE_OVERLAY_EVENTS : GlassesEventPacket.EventType.ENABLE_OVERLAY_EVENTS);
        }
    }

    static class worldEventsButton
    extends hostGuiElement.hostCheckbox
    implements hostGuiElement.hostAction {
        worldEventsButton(GlassesInstance.HostClient host) {
            super(host.uuid, 110, 45, "world events", host.sendWorldEvents);
        }

        public void clicked() {
            this.sendEvent(this.isEnabled() ? GlassesEventPacket.EventType.DISABLE_WORLD_EVENTS : GlassesEventPacket.EventType.ENABLE_WORLD_EVENTS);
        }
    }

    class SortHostClient
    implements Comparator<GlassesInstance.HostClient> {
        SortHostClient() {
        }

        @Override
        public int compare(GlassesInstance.HostClient a, GlassesInstance.HostClient b) {
            return a.uuid.compareTo(b.uuid);
        }
    }
}

