/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.guitoolkit.client.widget;

import ben_mkiv.guitoolkit.client.widget.prettyButton;
import ben_mkiv.guitoolkit.client.widget.prettyElement;
import java.util.ArrayList;
import org.lwjgl.input.Mouse;

public class prettyList
implements prettyElement {
    public ArrayList<ArrayList<prettyElement>> elements = new ArrayList();
    int scrollValue = 0;
    int x = 0;
    int y = 0;
    int displayElements = 5;
    int elementHeight;
    boolean visible = true;
    String name = "";

    public prettyList(String label) {
        this.name = label;
    }

    public prettyList(String label, int posX, int posY) {
        this(label);
        this.x = posX;
        this.y = posY;
    }

    public void add(ArrayList<prettyElement> entry) {
        int maxHeight = 0;
        for (prettyElement element : entry) {
            this.setX(Math.max(0, Math.min(this.getX(), element.getX())));
            this.setY(Math.max(0, Math.min(this.getY(), element.getY())));
            if (element instanceof prettyList) continue;
            maxHeight = Math.max(maxHeight, element.getY() + element.getHeight());
        }
        this.elementHeight = Math.max(this.elementHeight, maxHeight);
        this.elements.add(entry);
    }

    public prettyList getSubList(String name) {
        for (ArrayList<prettyElement> entry : this.elements) {
            if (!this.isList(entry) || !this.getList(entry).name.equals(name)) continue;
            return this.getList(entry);
        }
        return null;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getWidth() {
        int maxX = Integer.MIN_VALUE;
        for (ArrayList<prettyElement> el : this.elements) {
            for (prettyElement entry : el) {
                maxX = Math.max(maxX, entry.getX() + entry.getWidth());
            }
        }
        return maxX - this.getX();
    }

    @Override
    public int getHeight() {
        return this.elementHeight * this.displayElements;
    }

    @Override
    public void setY(int pos) {
        int offset = pos - this.y;
        for (ArrayList<prettyElement> el : this.elements) {
            for (prettyElement entry : el) {
                entry.setY(entry.getY() + offset);
            }
        }
        this.y = pos;
    }

    @Override
    public void setRenderX(int pos) {
        this.x = pos;
    }

    @Override
    public void setRenderY(int pos) {
        this.y = pos;
    }

    @Override
    public void setX(int pos) {
        int offset = pos - this.x;
        for (ArrayList<prettyElement> el : this.elements) {
            for (prettyElement entry : el) {
                entry.setX(entry.getX() + offset);
            }
        }
        this.x = pos;
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (!isVisible) {
            for (ArrayList<prettyElement> el : this.elements) {
                for (prettyElement entry : el) {
                    entry.setVisible(false);
                }
            }
        }
        this.visible = isVisible;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    public void add(prettyElement element) {
        ArrayList<prettyElement> list = new ArrayList<prettyElement>();
        list.add(element);
        this.add(list);
    }

    @Override
    public boolean isMouseOver() {
        for (ArrayList<prettyElement> entry : this.elements) {
            for (prettyElement element : entry) {
                if (!(element instanceof prettyButton) || !((prettyButton)element).func_146115_a()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void update() {
        int i;
        for (ArrayList<prettyElement> arrayList : this.elements) {
            if (!this.isList(arrayList)) continue;
            this.getList(arrayList).update();
        }
        if (!this.getVisible()) {
            return;
        }
        if (this.isMouseOver()) {
            this.scrollValue -= Integer.signum(Mouse.getDWheel());
        }
        this.scrollValue = Math.max(0, Math.min(this.scrollValue, this.elements.size() - this.displayElements));
        for (i = 0; i < this.scrollValue; ++i) {
            for (prettyElement element : this.elements.get(i)) {
                if (!(element instanceof prettyButton)) continue;
                element.setVisible(false);
            }
        }
        for (i = this.scrollValue + this.displayElements - 1; i < this.elements.size(); ++i) {
            for (prettyElement element : this.elements.get(i)) {
                if (!(element instanceof prettyButton)) continue;
                element.setVisible(false);
            }
        }
        i = this.scrollValue;
        boolean bl = false;
        while (i < this.elements.size() && i < this.scrollValue + this.displayElements) {
            void var2_9;
            for (prettyElement element : this.elements.get(i)) {
                element.setRenderY(this.elementHeight * var2_9);
                if (!(element instanceof prettyButton)) continue;
                element.setVisible(true);
            }
            ++i;
            ++var2_9;
        }
    }

    public boolean isList(ArrayList<prettyElement> listElement) {
        return listElement.get(0) instanceof prettyList;
    }

    public prettyList getList(ArrayList<prettyElement> listElement) {
        return this.isList(listElement) ? (prettyList)listElement.get(0) : null;
    }

    public int scrollUp() {
        return --this.scrollValue;
    }

    public int scrollDown() {
        return ++this.scrollValue;
    }

    public boolean canScroll() {
        return this.elements.size() > this.displayElements;
    }

    public boolean canScrollUp() {
        return this.scrollValue > 0;
    }

    public boolean canScrollDown() {
        return this.scrollValue < this.elements.size() - this.displayElements;
    }

    public void setScrollValue(int value) {
        this.scrollValue = value;
    }

    public int getScrollValue() {
        return this.scrollValue;
    }

    public void setDisplayElements(int count) {
        this.displayElements = count;
    }

    public int getDisplayElements() {
        return this.displayElements;
    }

    public void hideGroups() {
        this.hideGroups(0);
    }

    public void hideGroups(int maxLevel) {
        this.setVisible(false);
        if (maxLevel >= 0) {
            this.setVisible(true);
        }
        for (ArrayList<prettyElement> entry : this.elements) {
            if (!this.isList(entry)) continue;
            this.getList(entry).hideGroups(maxLevel - 1);
        }
    }
}

