/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GLContext;
import p455w0rdslib.LibShaders;

public class ShaderUtils {

    public static enum ShaderType {
        VERTEX(35633),
        FRAGMENT(35632);

        private final int type;

        private ShaderType(int type) {
            this.type = type;
        }

        public int getId() {
            return this.type;
        }
    }

    public static class Uniform {
        private final int location;
        private Object lastValue;

        public Uniform(int location, Object lastValue) {
            this.location = location;
            this.lastValue = lastValue;
        }

        private boolean equal(Object a, Object b) {
            if (a instanceof int[] && b instanceof int[]) {
                return Arrays.equals((int[])a, (int[])b);
            }
            if (a instanceof float[] && b instanceof float[]) {
                return Arrays.equals((float[])a, (float[])b);
            }
            return Objects.equal((Object)a, (Object)b);
        }

        public void setFloat(float val) {
            if (this.equal(Float.valueOf(val), this.lastValue)) {
                return;
            }
            GL20.glUniform1f((int)this.location, (float)val);
        }

        public void setInt(int val) {
            if (this.equal(val, this.lastValue)) {
                return;
            }
            GL20.glUniform1i((int)this.location, (int)val);
        }

        public void setFloat(float val1, float val2) {
            float[] val = new float[]{val1, val2};
            if (this.equal(val, this.lastValue)) {
                return;
            }
            GL20.glUniform2f((int)this.location, (float)val1, (float)val2);
            this.lastValue = val;
        }

        public void setInt(int val1, int val2) {
            int[] val = new int[]{val1, val2};
            if (this.equal(val, this.lastValue)) {
                return;
            }
            GL20.glUniform2i((int)this.location, (int)val1, (int)val2);
            this.lastValue = val;
        }

        public void setFloat(float val1, float val2, float val3) {
            float[] val = new float[]{val1, val2, val3};
            if (this.equal(val, this.lastValue)) {
                return;
            }
            GL20.glUniform3f((int)this.location, (float)val1, (float)val2, (float)val3);
            this.lastValue = val;
        }

        public void setInt(int val1, int val2, int val3) {
            int[] val = new int[]{val1, val2, val3};
            if (this.equal(val, this.lastValue)) {
                return;
            }
            GL20.glUniform3i((int)this.location, (int)val1, (int)val2, (int)val3);
            this.lastValue = val;
        }

        public void setFloat(float val1, float val2, float val3, float val4) {
            float[] val = new float[]{val1, val2, val3, val4};
            if (this.equal(val, this.lastValue)) {
                return;
            }
            GL20.glUniform4f((int)this.location, (float)val1, (float)val2, (float)val3, (float)val4);
            this.lastValue = val;
        }

        public void setInt(int val1, int val2, int val3, int val4) {
            int[] val = new int[]{val1, val2, val3, val4};
            if (this.equal(val, this.lastValue)) {
                return;
            }
            GL20.glUniform4i((int)this.location, (int)val1, (int)val2, (int)val3, (int)val4);
            this.lastValue = val;
        }

        public void setFloats(float[] floats) {
            FloatBuffer values = ByteBuffer.allocateDirect(floats.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            values.put(floats);
            GL20.glUniform1((int)this.location, (FloatBuffer)values);
        }
    }

    public static class Shader {
        public static final Shader NONE = new Shader(0);
        private final int program;
        private final Map<String, Uniform> uniforms = Maps.newConcurrentMap();

        public Shader(int program) {
            this.program = program;
        }

        public void refreshUniforms() {
            if (GLContext.getCapabilities().OpenGL31) {
                int numUniforms = GL20.glGetProgrami((int)this.program, (int)35718);
                for (int i = 0; i < numUniforms; ++i) {
                    String name = GL31.glGetActiveUniformName((int)this.program, (int)i, (int)32);
                    int idx = GL20.glGetUniformLocation((int)this.program, (CharSequence)name);
                    this.uniforms.put(name, new Uniform(idx, null));
                }
            }
        }

        public Uniform getUniform(String name) {
            int loc;
            if (!this.uniforms.containsKey(name) && (loc = GL20.glGetUniformLocation((int)this.program, (CharSequence)name)) != -1) {
                this.uniforms.put(name, new Uniform(loc, null));
            }
            return this.uniforms.get(name);
        }

        public void use() {
            LibShaders.setActiveShader(this);
            OpenGlHelper.func_153161_d((int)this.program);
        }

        public void delete() {
            OpenGlHelper.func_153187_e((int)this.program);
        }

        public int getId() {
            return this.program;
        }

        public boolean isActive() {
            return LibShaders.getActiveShader() == this;
        }
    }
}

