/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.capabilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.api.client.shader.Light;
import p455w0rdslib.util.CapabilityUtils;
import p455w0rdslib.util.RenderUtils;

public class CapabilityLightEmitter {
    public static final ResourceLocation CAP_LOCATION = new ResourceLocation("p455w0rdslib", "lights_cap");
    @CapabilityInject(value=ILightEmitter.class)
    public static Capability<ILightEmitter> LIGHT_EMITTER_CAPABILITY = null;
    private static final Capability.IStorage<ILightEmitter> STORAGE = new CapabilityUtils.EmptyStorage<ILightEmitter>();
    private static final Map<Item, Pair<Integer, Pair<Float, Float>>> ITEM_COLOR_MAP = new HashMap<Item, Pair<Integer, Pair<Float, Float>>>();
    private static final Map<Block, Pair<Integer, Pair<Float, Float>>> BLOCK_COLOR_MAP = new HashMap<Block, Pair<Integer, Pair<Float, Float>>>();

    public static void register() {
        CapabilityManager.INSTANCE.register(ILightEmitter.class, STORAGE, () -> new DummyLightEmitter());
    }

    public static boolean checkCap(Capability<?> capability) {
        return !LibGlobals.Mods.ALBEDO.isLoaded() && capability == LIGHT_EMITTER_CAPABILITY;
    }

    public static boolean hasCap(TileEntity tile) {
        return tile.hasCapability(LIGHT_EMITTER_CAPABILITY, null);
    }

    public static boolean hasCap(Entity entity) {
        return entity.hasCapability(LIGHT_EMITTER_CAPABILITY, null);
    }

    public static boolean hasCap(ItemStack stack) {
        return stack.hasCapability(LIGHT_EMITTER_CAPABILITY, null);
    }

    public static List<Light> getLights(TileEntity tile) {
        return CapabilityLightEmitter.hasCap(tile) ? ((ILightEmitter)tile.getCapability(LIGHT_EMITTER_CAPABILITY, null)).emitLight(new ArrayList<Light>(), tile) : Collections.emptyList();
    }

    public static List<Light> getLights(Entity entity) {
        return CapabilityLightEmitter.hasCap(entity) ? ((ILightEmitter)entity.getCapability(LIGHT_EMITTER_CAPABILITY, null)).emitLight(new ArrayList<Light>(), entity) : Collections.emptyList();
    }

    public static List<Light> getLights(ItemStack stack, Entity entity) {
        return CapabilityLightEmitter.hasCap(stack) ? ((ILightEmitter)stack.getCapability(LIGHT_EMITTER_CAPABILITY, null)).emitLight(new ArrayList<Light>(), entity) : Collections.emptyList();
    }

    public static ICapabilityProvider getDummyProvider() {
        return DummyLightProvider.DUMMY_INSTANCE;
    }

    public static <T> T getDummyCapability() {
        return (T)LIGHT_EMITTER_CAPABILITY.cast((Object)new DummyLightEmitter());
    }

    public static <T> T getVanillaStackCapability(ItemStack stack) {
        if ((Integer)CapabilityLightEmitter.getColorForStack(stack).getLeft() != 0) {
            return (T)LIGHT_EMITTER_CAPABILITY.cast((Object)new StackLightEmitter(stack){

                @Override
                public List<Light> emitLight(List<Light> lights, Entity entity) {
                    Vec3i c = RenderUtils.hexToRGB((Integer)CapabilityLightEmitter.getColorForStack(this.stack).getLeft());
                    lights.add(Light.builder().pos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v).color(c.func_177958_n(), c.func_177956_o(), c.func_177952_p(), ((Float)((Pair)CapabilityLightEmitter.getColorForStack(this.stack).getRight()).getRight()).floatValue()).radius(((Float)((Pair)CapabilityLightEmitter.getColorForStack(this.stack).getRight()).getLeft()).floatValue()).intensity(5.0f).build());
                    return lights;
                }
            });
        }
        return null;
    }

    public static ICapabilityProvider getVanillaStackProvider(final ItemStack stack) {
        return new ICapabilityProvider(){

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return CapabilityLightEmitter.checkCap(capability);
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return this.hasCapability(capability, null) ? (T)CapabilityLightEmitter.getVanillaStackCapability(stack) : null;
            }
        };
    }

    public static Pair<Integer, Pair<Float, Float>> getColorForBlock(Block block) {
        if (block != null && BLOCK_COLOR_MAP.containsKey(block)) {
            return BLOCK_COLOR_MAP.get(block);
        }
        return Pair.of((Object)0, (Object)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
    }

    public static Pair<Integer, Pair<Float, Float>> getColorForStack(ItemStack stack) {
        Block block;
        int meta;
        if (BLOCK_COLOR_MAP.isEmpty()) {
            CapabilityLightEmitter.genColorMap();
        }
        if ((meta = stack.func_77960_j()) >= 16) {
            meta = 0;
        }
        if ((block = Block.func_149634_a((Item)stack.func_77973_b())) != null && BLOCK_COLOR_MAP.containsKey(block)) {
            return BLOCK_COLOR_MAP.get(block);
        }
        if (ITEM_COLOR_MAP.containsKey(stack.func_77973_b())) {
            return ITEM_COLOR_MAP.get(stack.func_77973_b());
        }
        return Pair.of((Object)0, (Object)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
    }

    private static void genColorMap() {
        ITEM_COLOR_MAP.clear();
        BLOCK_COLOR_MAP.clear();
        BLOCK_COLOR_MAP.put(Blocks.field_150429_aA, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)-8978432, (Object)Pair.of((Object)Float.valueOf(4.0f), (Object)Float.valueOf(0.5f))));
        BLOCK_COLOR_MAP.put((Block)Blocks.field_150488_af, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)-8978432, (Object)Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f))));
        BLOCK_COLOR_MAP.put(Blocks.field_150478_aa, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)2005423360, (Object)Pair.of((Object)Float.valueOf(5.0f), (Object)Float.valueOf(0.5f))));
        BLOCK_COLOR_MAP.put(Blocks.field_150426_aN, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)-8947968, (Object)Pair.of((Object)Float.valueOf(4.0f), (Object)Float.valueOf(1.0f))));
        BLOCK_COLOR_MAP.put(Blocks.field_150428_aP, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)-13553408, (Object)Pair.of((Object)Float.valueOf(12.0f), (Object)Float.valueOf(0.25f))));
        BLOCK_COLOR_MAP.put(Blocks.field_150451_bX, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)0x770000, (Object)Pair.of((Object)Float.valueOf(4.0f), (Object)Float.valueOf(0.7f))));
        BLOCK_COLOR_MAP.put((Block)Blocks.field_150427_aO, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)-7399980, (Object)Pair.of((Object)Float.valueOf(3.0f), (Object)Float.valueOf(0.5f))));
        BLOCK_COLOR_MAP.put(Blocks.field_180398_cJ, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)0x77889999, (Object)Pair.of((Object)Float.valueOf(7.0f), (Object)Float.valueOf(0.5f))));
        BLOCK_COLOR_MAP.put((Block)Blocks.field_150480_ab, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)2005423360, (Object)Pair.of((Object)Float.valueOf(5.0f), (Object)Float.valueOf(0.5f))));
        ITEM_COLOR_MAP.put(Items.field_151129_at, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)-43776, (Object)Pair.of((Object)Float.valueOf(4.0f), (Object)Float.valueOf(1.0f))));
        ITEM_COLOR_MAP.put(Items.field_151137_ax, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)-8978432, (Object)Pair.of((Object)Float.valueOf(4.0f), (Object)Float.valueOf(0.25f))));
    }

    public static interface ILightEmitter {
        default public List<Light> emitLight(List<Light> lights, Entity entity) {
            return Collections.emptyList();
        }

        default public List<Light> emitLight(List<Light> lights, TileEntity entity) {
            return Collections.emptyList();
        }
    }

    public static class TileLightProvider
    extends DummyLightProvider {
        public TileLightProvider(TileEntity tile) {
            super(new TileLightEmitter(tile));
        }
    }

    public static class StackLightProvider
    extends DummyLightProvider {
        public StackLightProvider(ItemStack stack) {
            super(new StackLightEmitter(stack));
        }
    }

    public static class EntityLightProvider
    extends DummyLightProvider {
        public EntityLightProvider(Entity entity) {
            super(new EntityLightEmitter(entity));
        }
    }

    public static class TileLightEmitter
    extends DummyLightEmitter {
        TileEntity tile;

        public TileLightEmitter(TileEntity tile) {
            this.tile = tile;
        }
    }

    public static class StackLightEmitter
    extends DummyLightEmitter {
        ItemStack stack;

        public StackLightEmitter(ItemStack stack) {
            this.stack = stack;
        }
    }

    public static class EntityLightEmitter
    extends DummyLightEmitter {
        Entity entity;

        public EntityLightEmitter(Entity entity) {
            this.entity = entity;
        }
    }

    public static class DummyLightProvider
    implements ICapabilityProvider {
        ILightEmitter emitter;
        public static DummyLightProvider DUMMY_INSTANCE = new DummyLightProvider();

        private DummyLightProvider() {
            this((ILightEmitter)CapabilityLightEmitter.getDummyCapability());
        }

        public DummyLightProvider(ILightEmitter emitter) {
            this.emitter = emitter;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return CapabilityLightEmitter.checkCap(capability);
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, null) ? LIGHT_EMITTER_CAPABILITY.cast((Object)this.emitter) : null);
        }
    }

    private static class DummyLightEmitter
    implements ILightEmitter {
        private DummyLightEmitter() {
        }

        @Override
        public List<Light> emitLight(List<Light> lights, Entity entity) {
            return Collections.emptyList();
        }
    }
}

