/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.init;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import p455w0rd.danknull.DankNull;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.client.gui.GuiDankNull;
import p455w0rd.danknull.container.ContainerDankNull;
import p455w0rd.danknull.container.ContainerDankNullDock;
import p455w0rd.danknull.init.ModLogger;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.inventory.PlayerSlot;
import p455w0rd.danknull.util.DankNullUtils;

public class ModGuiHandler
implements IGuiHandler {
    public static void init() {
        ModLogger.info("Registering GUI Handler");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)"danknull", (IGuiHandler)new ModGuiHandler());
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (GUIType.VALUES[id]) {
            case DANKNULL: {
                PlayerSlot dankNull = DankNullUtils.getDankNullSlot(player);
                if (dankNull == null) {
                    return null;
                }
                InventoryDankNull inventory = new InventoryDankNull(dankNull, player);
                return new ContainerDankNull(player, inventory);
            }
            case DANKNULL_TE: {
                TileDankNullDock dankDock;
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (!(te instanceof TileDankNullDock) || (dankDock = (TileDankNullDock)te).getDankNull().func_190926_b()) break;
                return new ContainerDankNullDock(player, dankDock);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Container c = (Container)this.getServerGuiElement(id, player, world, x, y, z);
        if (c != null) {
            switch (GUIType.VALUES[id]) {
                case DANKNULL_TE: {
                    TileDankNullDock dankDock;
                    TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                    if (te instanceof TileDankNullDock && !(dankDock = (TileDankNullDock)te).getDankNull().func_190926_b()) {
                        InventoryDankNull inventory = DankNullUtils.getNewDankNullInventory(dankDock.getDankNull());
                        return new GuiDankNull(c, inventory, player);
                    }
                }
                case DANKNULL: {
                    PlayerSlot dankNull = DankNullUtils.getDankNullSlot(player);
                    if (dankNull == null) {
                        return null;
                    }
                    InventoryDankNull inventory = new InventoryDankNull(dankNull, player);
                    return new GuiDankNull(c, inventory, player);
                }
            }
        }
        return null;
    }

    public static void launchGui(GUIType type, EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            player.openGui((Object)DankNull.INSTANCE, type.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public static enum GUIType {
        DANKNULL,
        DANKNULL_TE;

        public static final GUIType[] VALUES;

        static {
            VALUES = new GUIType[]{DANKNULL, DANKNULL_TE};
        }
    }
}

