/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.immersivecables.util;

import de.sanandrew.mods.immersivecables.block.BlockCoil;
import de.sanandrew.mods.immersivecables.block.ae2.BlockRegistryAE2;
import de.sanandrew.mods.immersivecables.block.rs.BlockRegistryRS;
import de.sanandrew.mods.immersivecables.item.ItemBlockMeta;
import de.sanandrew.mods.immersivecables.item.ItemCoil;
import de.sanandrew.mods.immersivecables.util.ICConfiguration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="immersivecables")
public final class ItemBlockRegistry {
    public static final BlockCoil BLOCK_COIL = new BlockCoil();
    public static final ItemCoil WIRE_COIL = new ItemCoil();

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{BLOCK_COIL});
        if (ICConfiguration.isAe2Enabled()) {
            BlockRegistryAE2.registerBlocks(event);
        }
        if (ICConfiguration.isRsEnabled()) {
            BlockRegistryRS.registerBlocks(event);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)new ItemBlockMeta(BLOCK_COIL));
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{WIRE_COIL});
        if (ICConfiguration.isAe2Enabled()) {
            BlockRegistryAE2.registerItems(event);
        }
        if (ICConfiguration.isRsEnabled()) {
            BlockRegistryRS.registerItems(event);
        }
    }
}

