/*
 * Decompiled with CFR 0.152.
 */
package treechopper.proxy;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemAxe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import treechopper.common.config.ConfigurationHandler;
import treechopper.common.handler.TreeHandler;
import treechopper.proxy.PlayerInteract;

public class CommonProxy {
    public static Map<UUID, Boolean> m_PlayerPrintNames = new HashMap<UUID, Boolean>();
    protected static Map<UUID, PlayerInteract> m_PlayerData = new HashMap<UUID, PlayerInteract>();
    protected TreeHandler treeHandler;

    @SubscribeEvent
    public void InteractWithTree(PlayerInteractEvent interactEvent) {
        if (interactEvent.getSide().isClient() && m_PlayerPrintNames.containsKey(interactEvent.getEntityPlayer().getPersistentID()) && m_PlayerPrintNames.get(interactEvent.getEntityPlayer().getPersistentID()).booleanValue()) {
            interactEvent.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation(I18n.func_135052_a((String)"proxy.printBlock", (Object[])new Object[0]) + " " + interactEvent.getWorld().func_180495_p(interactEvent.getPos()).func_177230_c().func_149739_a(), new Object[0]));
            interactEvent.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation(I18n.func_135052_a((String)"proxy.printMainHand", (Object[])new Object[0]) + " " + interactEvent.getEntityPlayer().func_184614_ca().func_77977_a(), new Object[0]));
        }
        boolean shifting = true;
        if (!ConfigurationHandler.disableShift) {
            if (interactEvent.getEntityPlayer().func_70093_af() && !ConfigurationHandler.reverseShift) {
                shifting = false;
            }
            if (!interactEvent.getEntityPlayer().func_70093_af() && ConfigurationHandler.reverseShift) {
                shifting = false;
            }
        }
        if (this.CheckWoodenBlock(interactEvent.getWorld(), interactEvent.getPos()) && this.CheckItemInHand(interactEvent.getEntityPlayer()) && shifting) {
            int axeDurability = interactEvent.getEntityPlayer().func_184614_ca().func_77958_k() - interactEvent.getEntityPlayer().func_184614_ca().func_77952_i();
            if (m_PlayerData.containsKey(interactEvent.getEntityPlayer().getPersistentID()) && CommonProxy.m_PlayerData.get((Object)interactEvent.getEntityPlayer().getPersistentID()).m_BlockPos.equals((Object)interactEvent.getPos()) && CommonProxy.m_PlayerData.get((Object)interactEvent.getEntityPlayer().getPersistentID()).m_AxeDurability == axeDurability) {
                return;
            }
            this.treeHandler = new TreeHandler();
            int logCount = this.treeHandler.AnalyzeTree(interactEvent.getWorld(), interactEvent.getPos(), interactEvent.getEntityPlayer());
            if (interactEvent.getEntityPlayer().func_184614_ca().func_77984_f() && axeDurability < logCount) {
                m_PlayerData.remove(interactEvent.getEntityPlayer().getPersistentID());
                return;
            }
            if (logCount > 1) {
                m_PlayerData.put(interactEvent.getEntityPlayer().getPersistentID(), new PlayerInteract(interactEvent.getPos(), logCount, axeDurability));
            }
        } else {
            m_PlayerData.remove(interactEvent.getEntityPlayer().getPersistentID());
        }
    }

    @SubscribeEvent
    public void BreakingBlock(PlayerEvent.BreakSpeed breakSpeed) {
        if (m_PlayerData.containsKey(breakSpeed.getEntityPlayer().getPersistentID())) {
            BlockPos blockPos = CommonProxy.m_PlayerData.get((Object)breakSpeed.getEntityPlayer().getPersistentID()).m_BlockPos;
            if (blockPos.equals((Object)breakSpeed.getPos())) {
                breakSpeed.setNewSpeed(breakSpeed.getOriginalSpeed() / (CommonProxy.m_PlayerData.get((Object)breakSpeed.getEntityPlayer().getPersistentID()).m_LogCount / 2.0f));
            } else {
                breakSpeed.setNewSpeed(breakSpeed.getOriginalSpeed());
            }
        }
    }

    @SubscribeEvent
    public void DestroyWoodBlock(BlockEvent.BreakEvent breakEvent) {
        BlockPos blockPos;
        if (m_PlayerData.containsKey(breakEvent.getPlayer().getPersistentID()) && (blockPos = CommonProxy.m_PlayerData.get((Object)breakEvent.getPlayer().getPersistentID()).m_BlockPos).equals((Object)breakEvent.getPos())) {
            this.treeHandler.DestroyTree(breakEvent.getWorld(), breakEvent.getPlayer());
            if (!breakEvent.getPlayer().func_184812_l_() && breakEvent.getPlayer().func_184614_ca().func_77984_f()) {
                int axeDurability = breakEvent.getPlayer().func_184614_ca().func_77952_i() + (int)((double)CommonProxy.m_PlayerData.get((Object)breakEvent.getPlayer().getPersistentID()).m_LogCount * 1.5);
                breakEvent.getPlayer().func_184614_ca().func_77964_b(axeDurability);
            }
        }
    }

    protected boolean CheckWoodenBlock(World world, BlockPos blockPos) {
        if (ConfigurationHandler.blockWhiteList.contains(world.func_180495_p(blockPos).func_177230_c().func_149739_a())) {
            return true;
        }
        return world.func_180495_p(blockPos).func_177230_c().isWood((IBlockAccess)world, blockPos);
    }

    protected boolean CheckItemInHand(EntityPlayer entityPlayer) {
        boolean test;
        if (entityPlayer.func_184614_ca().func_190926_b()) {
            return false;
        }
        if (ConfigurationHandler.axeTypes.contains(entityPlayer.func_184614_ca().func_77973_b().func_77658_a())) {
            return true;
        }
        try {
            ItemAxe tmp = (ItemAxe)entityPlayer.func_184614_ca().func_77973_b();
            test = true;
        }
        catch (Exception e) {
            test = false;
        }
        return test;
    }
}

