/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pcl.openprinter.ContentRegistry;
import pcl.openprinter.OpenPrinter;
import pcl.openprinter.books.BiblioCraftBigBook;
import pcl.openprinter.books.VanillaBook;
import pcl.openprinter.items.PrintedPage;
import pcl.openprinter.items.PrinterInkBlack;
import pcl.openprinter.items.PrinterInkColor;
import pcl.openprinter.items.PrinterPaperRoll;
import pcl.openprinter.util.ItemUtils;

public class PrinterTE
extends TileEntity
implements ITickable,
Environment {
    private static final double PrinterFormatVersion = 2.0;
    private ComponentConnector node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    private boolean addedToNetwork = false;
    private ItemStackHandler inventoryOutput = new InventoryOutput();
    private ItemStackHandler inventoryScanner = new InventoryScanner();
    private ItemStackHandler inventoryMaterials = new InventoryMaterial();
    private List<String> lines = new ArrayList<String>();
    private List<String> align = new ArrayList<String>();
    private List<Integer> colors = new ArrayList<Integer>();
    private String pageTitle = "";

    public void removed() {
        ItemUtils.dropItems(this.inventoryScanner, this.field_145850_b, this.func_174877_v(), true, 10);
        ItemUtils.dropItems(this.inventoryMaterials, this.field_145850_b, this.func_174877_v(), true, 10);
        ItemUtils.dropItems(this.inventoryOutput, this.field_145850_b, this.func_174877_v(), true, 10);
    }

    private String getComponentName() {
        return "openprinter";
    }

    public Node node() {
        return this.node;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void onConnect(Node node) {
    }

    public void onDisconnect(Node node) {
    }

    public void func_73660_a() {
        if (!this.addedToNetwork) {
            this.addToNetwork();
        }
    }

    protected void addToNetwork() {
        if (!this.addedToNetwork) {
            this.addedToNetwork = true;
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    @Deprecated
    public void readOldInventoryFromNBT(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("Items")) {
            return;
        }
        NBTTagList var2 = nbt.func_150295_c("Items", (int)nbt.func_74732_a());
        block6: for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            switch (var5) {
                case 13: {
                    this.inventoryScanner.setStackInSlot(0, new ItemStack(var4));
                    continue block6;
                }
                case 0: {
                    this.inventoryMaterials.setStackInSlot(0, new ItemStack(var4));
                    continue block6;
                }
                case 1: {
                    this.inventoryMaterials.setStackInSlot(1, new ItemStack(var4));
                    continue block6;
                }
                case 2: {
                    this.inventoryMaterials.setStackInSlot(2, new ItemStack(var4));
                    continue block6;
                }
                default: {
                    var5 = (byte)(var5 - 3);
                    if (var5 <= 0 || var5 >= this.inventoryOutput.getSlots()) continue block6;
                    this.inventoryOutput.setStackInSlot((int)var5, new ItemStack(var4));
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
        if (nbt.func_74764_b("inventoryOutput")) {
            this.inventoryOutput.deserializeNBT(nbt.func_74775_l("inventoryOutput"));
            this.inventoryScanner.deserializeNBT(nbt.func_74775_l("inventoryScanner"));
            this.inventoryMaterials.deserializeNBT(nbt.func_74775_l("inventoryMaterials"));
        } else {
            this.readOldInventoryFromNBT(nbt);
        }
        if (nbt.func_74764_b("buffers")) {
            this.readBuffersFromNBT(nbt.func_74775_l("buffers"));
        }
    }

    private NBTTagCompound writeBuffersToNBT(NBTTagCompound nbt) {
        for (int i = 0; i < this.lines.size(); ++i) {
            NBTTagCompound lineNBT = new NBTTagCompound();
            lineNBT.func_74778_a("text", this.lines.get(i));
            lineNBT.func_74778_a("align", this.align.get(i));
            lineNBT.func_74768_a("color", this.colors.get(i).intValue());
            nbt.func_74782_a("line" + i, (NBTBase)lineNBT);
        }
        return nbt;
    }

    private void readBuffersFromNBT(NBTTagCompound nbt) {
        this.lines.clear();
        this.align.clear();
        this.colors.clear();
        int i = 0;
        while (nbt.func_74764_b("line" + i)) {
            NBTTagCompound lineNBT = nbt.func_74775_l("line" + i);
            this.lines.add(lineNBT.func_74779_i("text"));
            this.align.add(lineNBT.func_74779_i("align"));
            this.colors.add(lineNBT.func_74762_e("color"));
            ++i;
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        nbt.func_74782_a("inventoryScanner", (NBTBase)this.inventoryScanner.serializeNBT());
        nbt.func_74782_a("inventoryMaterials", (NBTBase)this.inventoryMaterials.serializeNBT());
        nbt.func_74782_a("inventoryOutput", (NBTBase)this.inventoryOutput.serializeNBT());
        nbt.func_74782_a("buffers", (NBTBase)this.writeBuffersToNBT(new NBTTagCompound()));
        return super.func_189515_b(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Callback
    public Object[] greet(Context context, Arguments args) {
        return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
    }

    @Callback(doc="function(Integer:lineNumber):String; -- scans the given line of a printed page")
    public Object[] scanLine(Context context, Arguments args) {
        if (!args.isInteger(0)) {
            return new Object[]{false, "first argument has to be a line number"};
        }
        ItemStack scannedPage = this.inventoryScanner.getStackInSlot(0);
        if (scannedPage.func_77973_b() instanceof PrintedPage && scannedPage.func_77942_o()) {
            return new Object[]{scannedPage.func_77978_p().func_74779_i("line" + args.checkInteger(0))};
        }
        return new Object[]{false};
    }

    @Callback(doc="function():table; -- scans a printed page")
    public Object[] scan(Context context, Arguments args) {
        ItemStack scannerInput = this.inventoryScanner.getStackInSlot(0);
        if (scannerInput.func_77973_b() instanceof PrintedPage) {
            return PrinterTE.readPrintedPage(scannerInput);
        }
        return new Object[]{false};
    }

    @Callback(doc="function():table; -- scans a book")
    public Object[] scanBook(Context context, Arguments args) {
        ItemStack scannerInput = this.inventoryScanner.getStackInSlot(0);
        if (scannerInput.func_77973_b() instanceof ItemWritableBook || scannerInput.func_77973_b() instanceof ItemWrittenBook) {
            return new VanillaBook().readFromStack(scannerInput);
        }
        if (scannerInput.func_77973_b().getRegistryName().toString().equals("bibliocraft:bigbook")) {
            return new BiblioCraftBigBook().readFromStack(scannerInput);
        }
        return new Object[]{false};
    }

    private static Object[] readPrintedPage(ItemStack printedPage) {
        if (!printedPage.func_77942_o()) {
            return new Object[]{false, "page doesnt have nbt data"};
        }
        String outPageTitle = null;
        HashMap<Integer, String> output = new HashMap<Integer, String>();
        if (printedPage.func_77978_p().func_74764_b("pageTitle")) {
            outPageTitle = printedPage.func_77978_p().func_74779_i("pageTitle");
        }
        for (int x = 0; x <= 20; ++x) {
            if (!printedPage.func_77978_p().func_74764_b("line" + x)) continue;
            output.put(x, printedPage.func_77978_p().func_74779_i("line" + x));
        }
        return new Object[]{outPageTitle, output};
    }

    @Callback(doc="function(String:title):boolean; -- prints a name tag")
    public Object[] printTag(Context context, Arguments args) throws Exception {
        if (!OpenPrinter.cfg.enableNameTag) {
            throw new Exception("Name Tag printing is disabled.");
        }
        if (!args.isString(0)) {
            throw new Exception("First argument has to be a valid String");
        }
        if (this.inventoryMaterials.getStackInSlot(0).func_190926_b()) {
            throw new Exception("Please load Black Ink.");
        }
        if (!this.inventoryMaterials.getStackInSlot(2).func_77973_b().equals(Items.field_151057_cb)) {
            throw new Exception("Please load Name Tags.");
        }
        int x = this.getEmptyOutputSlot();
        if (x == -1) {
            throw new Exception("no empty output slot");
        }
        ItemStack output = new ItemStack(Items.field_151057_cb);
        output.func_77982_d(new NBTTagCompound());
        NBTTagCompound nameTag = new NBTTagCompound();
        nameTag.func_74778_a("Name", args.checkString(0));
        output.func_77978_p().func_74782_a("display", (NBTBase)nameTag);
        this.damageMaterial((short)0, 1);
        this.damageMaterial((short)2, 1);
        this.inventoryOutput.setStackInSlot(x, output);
        return new Object[]{true};
    }

    private void damageMaterial(short materialSlot, int damage) {
        ItemStack slotItem = this.inventoryMaterials.getStackInSlot((int)materialSlot);
        if (slotItem.func_190916_E() > 1) {
            this.inventoryMaterials.extractItem((int)materialSlot, 1, false);
            return;
        }
        slotItem.func_77964_b(slotItem.func_77952_i() + damage);
        if (slotItem.func_77952_i() >= slotItem.func_77958_k()) {
            this.inventoryMaterials.setStackInSlot((int)materialSlot, ItemStack.field_190927_a);
        } else {
            this.inventoryMaterials.setStackInSlot((int)materialSlot, slotItem);
        }
    }

    private int getEmptyOutputSlot() {
        for (int slot = 0; slot < this.inventoryOutput.getSlots(); ++slot) {
            if (!this.inventoryOutput.getStackInSlot(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    @Callback(doc="function([Integer:copyCount]):boolean; -- prints the current page")
    public Object[] print(Context context, Arguments args) throws Exception {
        int copies = args.optInteger(0, 1);
        int copiesDone = 0;
        for (int i = 0; i < copies; ++i) {
            if (this.inventoryMaterials.getStackInSlot(0).func_190926_b() && this.inventoryMaterials.getStackInSlot(1).func_190926_b()) {
                throw new Exception("Please load Ink.");
            }
            if (this.inventoryMaterials.getStackInSlot(2).func_190926_b()) {
                throw new Exception("Please load Paper.");
            }
            int x = this.getEmptyOutputSlot();
            if (x == -1) {
                throw new Exception("no empty output slot");
            }
            ItemStack output = new ItemStack(ContentRegistry.printedPage);
            output.func_77982_d(new NBTTagCompound());
            if (this.pageTitle.length() > 0) {
                output.func_77978_p().func_74778_a("pageTitle", this.pageTitle);
                output.func_151001_c(this.pageTitle);
            }
            output.func_77978_p().func_74780_a("version", 2.0);
            int iter = 0;
            for (String s : this.lines) {
                output.func_77978_p().func_74778_a("line" + iter, this.lines.get(iter) + "\u221e" + this.colors.get(iter) + "\u221e" + this.align.get(iter));
                if (this.colors.get(iter) != 0) {
                    this.damageMaterial((short)1, 1);
                } else {
                    this.damageMaterial((short)0, 1);
                }
                if (this.lines.get(iter).matches(".*\u00a7[0-9a-f].*")) {
                    Pattern regex = Pattern.compile("\u00a7[0-9a-f]*");
                    Matcher matcher = regex.matcher(this.lines.get(iter));
                    while (matcher.find()) {
                        this.damageMaterial((short)1, 1);
                    }
                }
                ++iter;
            }
            this.damageMaterial((short)2, 1);
            this.inventoryOutput.setStackInSlot(x, output);
            ++copiesDone;
        }
        this.pageTitle = "";
        this.lines.clear();
        this.colors.clear();
        this.align.clear();
        return new Object[]{copiesDone == copies};
    }

    @Callback(doc="function(String:text[, Integer:color, String:alignment]):boolean; -- prints a line to the printer buffer")
    public Object[] writeln(Context context, Arguments args) throws Exception {
        if (!args.isString(0)) {
            throw new Exception("First argument has to be a valid String");
        }
        if (this.lines.size() >= 20) {
            throw new Exception("To many lines.");
        }
        int color = 0;
        String alignment = "left";
        if (args.count() == 2) {
            if (args.isInteger(1)) {
                color = args.checkInteger(1);
            } else if (args.isString(1)) {
                alignment = args.checkString(1);
            }
        }
        if (args.count() == 3) {
            if (args.isInteger(1)) {
                color = args.checkInteger(1);
            }
            if (args.isString(2)) {
                alignment = args.checkString(2);
            }
        }
        this.lines.add(args.checkString(0));
        this.colors.add(color);
        this.align.add(alignment);
        return new Object[]{true};
    }

    @Callback(doc="function(String:text):boolean; -- sets the page title")
    public Object[] setTitle(Context context, Arguments args) {
        this.pageTitle = args.optString(0, "");
        return new Object[]{true};
    }

    @Callback(doc="function():Integer; -- gets the current paper level")
    public Object[] getPaperLevel(Context context, Arguments args) {
        if (this.inventoryMaterials.getStackInSlot(2).func_190926_b()) {
            return new Object[]{0};
        }
        if (this.inventoryMaterials.getStackInSlot(2).func_77973_b() instanceof PrinterPaperRoll) {
            return new Object[]{256 - this.inventoryMaterials.getStackInSlot(2).func_77952_i()};
        }
        return new Object[]{this.inventoryMaterials.getStackInSlot(2).func_190916_E()};
    }

    @Callback(doc="function():Integer; -- gets the current black ink level")
    public Object[] getBlackInkLevel(Context context, Arguments args) {
        if (this.inventoryMaterials.getStackInSlot(0).func_190926_b()) {
            return new Object[]{0};
        }
        return new Object[]{OpenPrinter.cfg.printerInkUse - this.inventoryMaterials.getStackInSlot(0).func_77952_i()};
    }

    @Callback(doc="function():Integer; -- gets the current color ink level")
    public Object[] getColorInkLevel(Context context, Arguments args) {
        if (this.inventoryMaterials.getStackInSlot(1).func_190926_b()) {
            return new Object[]{false};
        }
        return new Object[]{OpenPrinter.cfg.printerInkUse - this.inventoryMaterials.getStackInSlot(1).func_77952_i()};
    }

    @Callback(doc="function(String:input):Integer; -- gets the character count for the given String", direct=true)
    public Object[] charCount(Context context, Arguments args) {
        return new Object[]{args.checkString(0).replaceAll("(?:\u00a7[0-9a-fk-or])+", "").length()};
    }

    @Callback(doc="function():boolean; -- clears the printer buffer")
    public Object[] clear(Context context, Arguments args) {
        this.lines.clear();
        this.colors.clear();
        this.align.clear();
        this.pageTitle = "";
        return new Object[]{true};
    }

    public void onMessage(Message arg0) {
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (EnumFacing.UP.equals((Object)facing)) {
                return (T)this.inventoryScanner;
            }
            if (EnumFacing.DOWN.equals((Object)facing)) {
                return (T)this.inventoryOutput;
            }
            return (T)this.inventoryMaterials;
        }
        return (T)super.getCapability(capability, facing);
    }

    class InventoryMaterial
    extends ItemStackHandler {
        static final short BLACK_INK_SLOT = 0;
        static final short COLOR_INK_SLOT = 1;
        static final short PAPER_SLOT = 2;

        InventoryMaterial() {
            super(3);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            switch (slot) {
                case 2: {
                    return stack.func_77973_b() instanceof PrinterPaperRoll || stack.func_77973_b().equals(Items.field_151121_aF) || stack.func_77973_b().equals(Items.field_151057_cb);
                }
                case 1: {
                    return stack.func_77973_b() instanceof PrinterInkColor;
                }
                case 0: {
                    return stack.func_77973_b() instanceof PrinterInkBlack;
                }
            }
            return false;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    }

    class InventoryScanner
    extends ItemStackHandler {
        InventoryScanner() {
            super(1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof PrintedPage || stack.func_77973_b().equals(Items.field_151164_bB) || stack.func_77973_b().equals(Items.field_151099_bA) || stack.func_77973_b().getRegistryName().toString().equals("bibliocraft:bigbook");
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    }

    class InventoryOutput
    extends ItemStackHandler {
        InventoryOutput() {
            super(9);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof PrintedPage;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    }
}

