/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.world.VillageEngineersHouse;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class IEVillagerHandler {
    private static final VillagerRegistry VILLAGER_REGISTRY = VillagerRegistry.instance();
    public static VillagerRegistry.VillagerProfession PROF_ENGINEER;
    @GameRegistry.ObjectHolder(value="minecraft:librarian")
    public static final VillagerRegistry.VillagerProfession LIBRARIAN;

    public static void initIEVillagerHouse() {
        if (!Config.IEConfig.villagerHouse) {
            return;
        }
        VILLAGER_REGISTRY.registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageEngineersHouse.VillageManager());
        MapGenStructureIO.func_143031_a(VillageEngineersHouse.class, (String)"immersiveengineering:EngineersHouse");
    }

    public static void initIEVillagerTrades() {
        if (!Config.IEConfig.enableVillagers) {
            return;
        }
        PROF_ENGINEER = new VillagerRegistry.VillagerProfession("immersiveengineering:engineer", "immersiveengineering:textures/models/villager_engineer.png", "immersiveengineering:textures/models/villager_engineer_zombie.png");
        ForgeRegistries.VILLAGER_PROFESSIONS.register((IForgeRegistryEntry)PROF_ENGINEER);
        if (LIBRARIAN != null) {
            LIBRARIAN.getCareer(1).addTrade(4, new EntityVillager.ITradeList[]{new OreveinMapForEmeralds()});
        }
        VillagerRegistry.VillagerCareer career_engineer = new VillagerRegistry.VillagerCareer(PROF_ENGINEER, "immersiveengineering.engineer");
        career_engineer.addTrade(1, new EntityVillager.ITradeList[]{new EmeraldForItemstack(new ItemStack((Item)IEContent.itemMaterial, 1, 0), new EntityVillager.PriceInfo(8, 16)), new ItemstackForEmerald(new ItemStack(IEContent.blockWoodenDecoration, 1, 1), new EntityVillager.PriceInfo(-10, -6)), new ItemstackForEmerald(new ItemStack(IEContent.blockClothDevice, 1, 1), new EntityVillager.PriceInfo(-3, -1))});
        career_engineer.addTrade(2, new EntityVillager.ITradeList[]{new EmeraldForItemstack(new ItemStack((Item)IEContent.itemMaterial, 1, 1), new EntityVillager.PriceInfo(2, 6)), new ItemstackForEmerald(new ItemStack(IEContent.blockMetalDecoration1, 1, 1), new EntityVillager.PriceInfo(-8, -4)), new ItemstackForEmerald(new ItemStack(IEContent.blockMetalDecoration1, 1, 5), new EntityVillager.PriceInfo(-8, -4))});
        career_engineer.addTrade(3, new EntityVillager.ITradeList[]{new EmeraldForItemstack(new ItemStack((Item)IEContent.itemMaterial, 1, 2), new EntityVillager.PriceInfo(2, 6)), new EmeraldForItemstack(new ItemStack((Item)IEContent.itemMaterial, 1, 7), new EntityVillager.PriceInfo(4, 8)), new ItemstackForEmerald(new ItemStack(IEContent.blockStoneDecoration, 1, 5), new EntityVillager.PriceInfo(-6, -2))});
        career_engineer.addTrade(4, new EntityVillager.ITradeList[]{new OreveinMapForEmeralds()});
        VillagerRegistry.VillagerCareer career_machinist = new VillagerRegistry.VillagerCareer(PROF_ENGINEER, "immersiveengineering.machinist");
        career_machinist.addTrade(1, new EntityVillager.ITradeList[]{new EmeraldForItemstack(new ItemStack((Item)IEContent.itemMaterial, 1, 6), new EntityVillager.PriceInfo(8, 16)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemTool, 1, 0), new EntityVillager.PriceInfo(4, 7))});
        career_machinist.addTrade(2, new EntityVillager.ITradeList[]{new EmeraldForItemstack(new ItemStack((Item)IEContent.itemMetal, 1, 0), new EntityVillager.PriceInfo(4, 6)), new EmeraldForItemstack(new ItemStack((Item)IEContent.itemMetal, 1, 1), new EntityVillager.PriceInfo(4, 6)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemMaterial, 1, 9), new EntityVillager.PriceInfo(1, 3))});
        career_machinist.addTrade(3, new EntityVillager.ITradeList[]{new ItemstackForEmerald(new ItemStack((Item)IEContent.itemToolbox, 1, 0), new EntityVillager.PriceInfo(6, 8)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemMaterial, 1, 10), new EntityVillager.PriceInfo(1, 3)), new ItemstackForEmerald(BlueprintCraftingRecipe.getTypedBlueprint("specialBullet"), new EntityVillager.PriceInfo(5, 9))});
        career_machinist.addTrade(4, new EntityVillager.ITradeList[]{new ItemstackForEmerald(new ItemStack((Item)IEContent.itemDrillhead, 1, 1), new EntityVillager.PriceInfo(28, 40)), new ItemstackForEmerald(IEContent.itemEarmuffs, new EntityVillager.PriceInfo(4, 9))});
        career_machinist.addTrade(5, new EntityVillager.ITradeList[]{new ItemstackForEmerald(new ItemStack((Item)IEContent.itemDrillhead, 1, 0), new EntityVillager.PriceInfo(32, 48)), new ItemstackForEmerald(BlueprintCraftingRecipe.getTypedBlueprint("electrode"), new EntityVillager.PriceInfo(12, 24))});
        VillagerRegistry.VillagerCareer career_electrician = new VillagerRegistry.VillagerCareer(PROF_ENGINEER, "immersiveengineering.electrician");
        career_electrician.addTrade(1, new EntityVillager.ITradeList[]{new EmeraldForItemstack(new ItemStack((Item)IEContent.itemMaterial, 1, 20), new EntityVillager.PriceInfo(8, 16)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemTool, 1, 1), new EntityVillager.PriceInfo(4, 7)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemWireCoil, 1, 0), new EntityVillager.PriceInfo(-4, -2))});
        career_electrician.addTrade(2, new EntityVillager.ITradeList[]{new EmeraldForItemstack(new ItemStack((Item)IEContent.itemMaterial, 1, 21), new EntityVillager.PriceInfo(6, 12)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemTool, 1, 2), new EntityVillager.PriceInfo(4, 7)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemWireCoil, 1, 1), new EntityVillager.PriceInfo(-4, -1))});
        career_electrician.addTrade(3, new EntityVillager.ITradeList[]{new EmeraldForItemstack(new ItemStack((Item)IEContent.itemMaterial, 1, 22), new EntityVillager.PriceInfo(4, 8)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemWireCoil, 1, 2), new EntityVillager.PriceInfo(-2, -1)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemToolUpgrades, 1, 6), new EntityVillager.PriceInfo(8, 12))});
        career_electrician.addTrade(4, new EntityVillager.ITradeList[]{new ItemstackForEmerald(new ItemStack((Item)IEContent.itemToolUpgrades, 1, 9), new EntityVillager.PriceInfo(8, 12)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemFluorescentTube), new EntityVillager.PriceInfo(8, 12)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemsFaradaySuit[0]), new EntityVillager.PriceInfo(5, 7)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemsFaradaySuit[1]), new EntityVillager.PriceInfo(9, 11)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemsFaradaySuit[2]), new EntityVillager.PriceInfo(5, 7)), new ItemstackForEmerald(new ItemStack((Item)IEContent.itemsFaradaySuit[3]), new EntityVillager.PriceInfo(11, 15))});
        VillagerRegistry.VillagerCareer career_outfitter = new VillagerRegistry.VillagerCareer(PROF_ENGINEER, "immersiveengineering.outfitter");
        ItemStack bag_common = new ItemStack((Item)IEContent.itemShaderBag);
        ItemNBTHelper.setString(bag_common, "rarity", EnumRarity.COMMON.toString());
        ItemStack bag_uncommon = new ItemStack((Item)IEContent.itemShaderBag);
        ItemNBTHelper.setString(bag_uncommon, "rarity", EnumRarity.UNCOMMON.toString());
        ItemStack bag_rare = new ItemStack((Item)IEContent.itemShaderBag);
        ItemNBTHelper.setString(bag_rare, "rarity", EnumRarity.RARE.toString());
        career_outfitter.addTrade(1, new EntityVillager.ITradeList[]{new ItemstackForEmerald(bag_common, new EntityVillager.PriceInfo(8, 16))});
        career_outfitter.addTrade(2, new EntityVillager.ITradeList[]{new ItemstackForEmerald(bag_uncommon, new EntityVillager.PriceInfo(12, 20))});
        career_outfitter.addTrade(3, new EntityVillager.ITradeList[]{new ItemstackForEmerald(bag_rare, new EntityVillager.PriceInfo(16, 24))});
    }

    static {
        LIBRARIAN = null;
    }

    private static class OreveinMapForEmeralds
    implements EntityVillager.ITradeList {
        public EntityVillager.PriceInfo value;

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            World world = merchant.func_190670_t_();
            BlockPos merchantPos = merchant.func_190671_u_();
            int cX = merchantPos.func_177958_n() >> 4;
            int cZ = merchantPos.func_177952_p() >> 4;
            DimensionChunkCoords chunkCoords = null;
            for (int i = 0; i < 8 && ExcavatorHandler.mineralCache.containsKey((Object)(chunkCoords = new DimensionChunkCoords(merchant.func_190670_t_().field_73011_w.getDimension(), cX + (random.nextInt(32) - 16) * 2, cZ + (random.nextInt(32) - 16) * 2))); ++i) {
                chunkCoords = null;
            }
            if (chunkCoords != null) {
                ExcavatorHandler.MineralWorldInfo mineralWorldInfo = ExcavatorHandler.getMineralWorldInfo(merchant.func_190670_t_(), chunkCoords, true);
                if (mineralWorldInfo == null || mineralWorldInfo.mineral == null) {
                    if (!world.field_72995_K) {
                        IELogger.error("Null " + (mineralWorldInfo == null ? "WorldInfo" : "Mineral") + " on building Cartographer trade.");
                    }
                    return;
                }
                BlockPos blockPos = new BlockPos(chunkCoords.func_180334_c() + 8, 64, chunkCoords.func_180333_d() + 8);
                ItemStack itemstack = ItemMap.func_190906_a((World)world, (double)blockPos.func_177958_n(), (double)blockPos.func_177952_p(), (byte)1, (boolean)true, (boolean)true);
                ItemMap.func_190905_a((World)world, (ItemStack)itemstack);
                MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockPos, (String)"ie:coresample_treasure", (MapDecoration.Type)MapDecoration.Type.TARGET_POINT);
                itemstack.func_190924_f("item.immersiveengineering.map_orevein.name");
                ItemNBTHelper.setLore(itemstack, mineralWorldInfo.mineral.name);
                recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 8 + random.nextInt(8)), new ItemStack((Item)IEContent.itemMetal), itemstack));
            }
        }
    }

    private static class ItemstackForEmerald
    implements EntityVillager.ITradeList {
        public ItemStack sellingItem;
        public EntityVillager.PriceInfo priceInfo;

        public ItemstackForEmerald(Item par1Item, EntityVillager.PriceInfo priceInfo) {
            this.sellingItem = new ItemStack(par1Item);
            this.priceInfo = priceInfo;
        }

        public ItemstackForEmerald(ItemStack stack, EntityVillager.PriceInfo priceInfo) {
            this.sellingItem = stack;
            this.priceInfo = priceInfo;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            ItemStack itemstack1;
            ItemStack itemstack;
            int i = 1;
            if (this.priceInfo != null) {
                i = this.priceInfo.func_179412_a(random);
            }
            if (i < 0) {
                itemstack = new ItemStack(Items.field_151166_bC);
                itemstack1 = Utils.copyStackWithAmount(this.sellingItem, -i);
            } else {
                itemstack = new ItemStack(Items.field_151166_bC, i, 0);
                itemstack1 = Utils.copyStackWithAmount(this.sellingItem, 1);
            }
            recipeList.add((Object)new MerchantRecipe(itemstack, itemstack1));
        }
    }

    private static class EmeraldForItemstack
    implements EntityVillager.ITradeList {
        public ItemStack buyingItem;
        public EntityVillager.PriceInfo buyAmounts;

        public EmeraldForItemstack(@Nonnull ItemStack item, @Nonnull EntityVillager.PriceInfo buyAmounts) {
            this.buyingItem = item;
            this.buyAmounts = buyAmounts;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            recipeList.add((Object)new MerchantRecipe(Utils.copyStackWithAmount(this.buyingItem, this.buyAmounts.func_179412_a(random)), Items.field_151166_bC));
        }
    }
}

