/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicterminal.network;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ItemViewCell;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperInvItemHandler;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.IPartitionList;
import ftblag.thaumicterminal.utils.TTUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;
import thaumcraft.common.blocks.world.ore.ShardType;

public class PacketTTRecipe
implements IMessage,
IMessageHandler<PacketTTRecipe, IMessage> {
    private NBTTagCompound tag;
    private ItemStack[][] recipee;

    public PacketTTRecipe() {
    }

    public PacketTTRecipe(NBTTagCompound tag) {
        this.tag = tag;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        int i = pb.readerIndex();
        byte b0 = pb.readByte();
        if (b0 == 0) {
            this.tag = null;
        } else {
            pb.readerIndex(i);
            try {
                this.tag = CompressedStreamTools.func_74796_a((InputStream)new ByteBufInputStream((ByteBuf)pb));
            }
            catch (IOException ioexception) {
                throw new EncoderException((Throwable)ioexception);
            }
        }
        if (this.tag != null) {
            this.recipee = new ItemStack[15][];
            System.out.println("ASsdd" + this.tag.func_186856_d());
            for (int x = 0; x < this.recipee.length; ++x) {
                NBTTagList list = this.tag.func_150295_c("#" + x, 10);
                if (list.func_74745_c() <= 0) continue;
                this.recipee[x] = new ItemStack[list.func_74745_c()];
                for (int y = 0; y < list.func_74745_c(); ++y) {
                    this.recipee[x][y] = new ItemStack(list.func_150305_b(y));
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        if (this.tag == null) {
            pb.writeByte(0);
        } else {
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.tag, (OutputStream)new ByteBufOutputStream((ByteBuf)pb));
            }
            catch (IOException ioexception) {
                throw new EncoderException((Throwable)ioexception);
            }
        }
    }

    public IMessage onMessage(PacketTTRecipe message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        player.func_71121_q().func_152344_a(() -> this.handle(message, player));
        return null;
    }

    private void handle(PacketTTRecipe message, EntityPlayerMP pmp) {
        ItemStack[][] recipe = message.recipee;
        Container con = pmp.field_71070_bA;
        if (!(con instanceof IContainerCraftingPacket)) {
            return;
        }
        IContainerCraftingPacket cct = (IContainerCraftingPacket)con;
        IGridNode node = cct.getNetworkNode();
        if (node == null) {
            return;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return;
        }
        IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
        IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        IItemHandler craftMatrix = cct.getInventoryByName("crafting");
        IItemHandler playerInventory = cct.getInventoryByName("player");
        if (inv != null && recipe != null && security != null) {
            IMEMonitor storage = inv.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IPartitionList filter = ItemViewCell.createFilter((ItemStack[])cct.getViewCells());
            for (int x = 0; x < 9; ++x) {
                ItemStack newItem;
                int slotTo = x;
                ItemStack currentItem = craftMatrix.getStackInSlot(slotTo);
                if (!currentItem.func_190926_b() && (newItem = this.canUseInSlot(recipe, x, currentItem)) != currentItem && security.hasPermission((EntityPlayer)pmp, SecurityPermissions.INJECT)) {
                    AEItemStack in = AEItemStack.fromItemStack((ItemStack)currentItem);
                    IAEItemStack out = cct.useRealItems() ? (IAEItemStack)Platform.poweredInsert((IEnergySource)energy, (IMEInventory)storage, (IAEStack)in, (IActionSource)cct.getActionSource()) : null;
                    currentItem = out != null ? out.createItemStack() : ItemStack.field_190927_a;
                }
                if (currentItem.func_190926_b() && recipe[x] != null) {
                    for (int y = 0; y < recipe[x].length && currentItem.func_190926_b(); ++y) {
                        ItemStack requestIS = recipe[x][y];
                        AEItemStack request = AEItemStack.fromItemStack((ItemStack)requestIS);
                        if (request == null) continue;
                        if ((filter == null || filter.isListed((IAEStack)request)) && security.hasPermission((EntityPlayer)pmp, SecurityPermissions.EXTRACT)) {
                            request.setStackSize(x > 8 ? (long)requestIS.func_190916_E() : 1L);
                            Object out = cct.useRealItems() ? (IAEItemStack)Platform.poweredExtraction((IEnergySource)energy, (IMEInventory)storage, (IAEStack)request, (IActionSource)cct.getActionSource()) : (!crafting.getCraftingFor((IAEItemStack)request, null, 0, null).isEmpty() ? request : (IAEItemStack)storage.extractItems((IAEStack)request, Actionable.SIMULATE, cct.getActionSource()));
                            if (out != null) {
                                currentItem = out.createItemStack();
                            }
                        }
                        if (!currentItem.func_190926_b()) continue;
                        AdaptorItemHandler ad = new AdaptorItemHandler(playerInventory);
                        currentItem = cct.useRealItems() ? ad.removeItems(x > 8 ? requestIS.func_190916_E() : 1, recipe[x][y], null) : ad.simulateRemove(x > 8 ? requestIS.func_190916_E() : 1, recipe[x][y], null);
                    }
                }
                ItemHandlerUtil.setStackInSlot((IItemHandler)craftMatrix, (int)slotTo, (ItemStack)currentItem);
            }
            block2: for (int i = 9; i < recipe.length; ++i) {
                if (recipe[i] == null) continue;
                ItemStack[] possibilities = recipe[i];
                boolean found = false;
                for (ItemStack possibility : possibilities) {
                    int slotTo = -1;
                    for (ShardType st : ShardType.values()) {
                        if (st.getMetadata() >= 6 || TTUtils.getAspect0(possibility) != st.getAspect()) continue;
                        slotTo = 9 + st.getMetadata();
                    }
                    if (slotTo == -1) {
                        throw new Error("Report to this to mod author!");
                    }
                    if (craftMatrix.getStackInSlot(slotTo).func_190916_E() >= possibility.func_190916_E()) continue;
                    int sizeOnGrid = craftMatrix.getStackInSlot(slotTo).func_190916_E();
                    AEItemStack request = AEItemStack.fromItemStack((ItemStack)possibility);
                    if (request == null) continue;
                    if ((filter == null || filter.isListed((IAEStack)request)) && security.hasPermission((EntityPlayer)pmp, SecurityPermissions.EXTRACT)) {
                        request.setStackSize(i > 8 ? (long)possibility.func_190916_E() : 1L);
                        Object out = cct.useRealItems() ? (IAEItemStack)Platform.poweredExtraction((IEnergySource)energy, (IMEInventory)storage, (IAEStack)request, (IActionSource)cct.getActionSource()) : (!crafting.getCraftingFor((IAEItemStack)request, null, 0, null).isEmpty() ? request : (IAEItemStack)storage.extractItems((IAEStack)request, Actionable.SIMULATE, cct.getActionSource()));
                        if (out != null) {
                            ItemStack tmp = out.createItemStack();
                            tmp.func_190920_e(tmp.func_190916_E() + sizeOnGrid);
                            ItemHandlerUtil.setStackInSlot((IItemHandler)craftMatrix, (int)slotTo, (ItemStack)tmp);
                            found = true;
                            continue block2;
                        }
                    }
                    if (found) continue;
                    AdaptorItemHandler ad = new AdaptorItemHandler(playerInventory);
                    ItemStack currentItem = cct.useRealItems() ? ad.removeItems(i > 8 ? possibility.func_190916_E() : 1, possibility, null) : ad.simulateRemove(i > 8 ? possibility.func_190916_E() : 1, possibility, null);
                    currentItem.func_190920_e(currentItem.func_190916_E() + sizeOnGrid);
                    ItemHandlerUtil.setStackInSlot((IItemHandler)craftMatrix, (int)slotTo, (ItemStack)currentItem);
                    continue block2;
                }
            }
            con.func_75130_a((IInventory)new WrapperInvItemHandler(craftMatrix));
        }
    }

    private ItemStack canUseInSlot(ItemStack[][] recipe, int slot, ItemStack is) {
        if (recipe[slot] != null) {
            for (ItemStack option : recipe[slot]) {
                if (!is.func_77969_a(option) || !TTUtils.isEqualNbt(is, option)) continue;
                return is;
            }
        }
        return ItemStack.field_190927_a;
    }
}

