/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity.logic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pcl.opensecurity.common.blocks.BlockSecureDoor;
import pcl.opensecurity.common.tileentity.TileEntitySecureDoor;

public class DoorController {
    public static Object[] setDoorPasswords(World world, BlockPos controller, String oldPass, String newPass) {
        ArrayList<Object[]> doorResponses = new ArrayList<Object[]>();
        for (Map.Entry<BlockPos, BlockDoor> doorSet : DoorController.getDoors(world, controller).entrySet()) {
            if (!(doorSet.getValue() instanceof BlockSecureDoor)) continue;
            TileEntitySecureDoor te = (TileEntitySecureDoor)world.func_175625_s(doorSet.getKey());
            TileEntitySecureDoor otherTE = (TileEntitySecureDoor)world.func_175625_s(BlockSecureDoor.getOtherDoorPart(world, doorSet.getKey()));
            if (te.getPass().isEmpty()) {
                te.setPassword(newPass);
                otherTE.setPassword(newPass);
                doorResponses.add(new Object[]{true, "Password set"});
                continue;
            }
            if (oldPass.equals(te.getPass())) {
                te.setPassword(newPass);
                otherTE.setPassword(newPass);
                doorResponses.add(new Object[]{true, "Password Changed"});
                continue;
            }
            doorResponses.add(new Object[]{false, "Password was not changed"});
        }
        if (doorResponses.size() == 0) {
            return new Object[]{false, "No Security door found"};
        }
        return new Object[]{doorResponses.toArray()};
    }

    public static Object[] setDoorStates(World world, BlockPos controller, boolean open, String password) {
        ArrayList<Object[]> doorResponses = new ArrayList<Object[]>();
        for (Map.Entry<BlockPos, BlockDoor> doorSet : DoorController.getDoors(world, controller).entrySet()) {
            if (doorSet.getValue() instanceof BlockSecureDoor) {
                TileEntitySecureDoor te = (TileEntitySecureDoor)world.func_175625_s(doorSet.getKey());
                if (password.equals(te.getPass())) {
                    doorSet.getValue().func_176512_a(world, doorSet.getKey(), open);
                    doorResponses.add(new Object[]{true});
                    continue;
                }
                doorResponses.add(new Object[]{false, "Password incorrect"});
                continue;
            }
            doorSet.getValue().func_176512_a(world, doorSet.getKey(), open);
            doorResponses.add(new Object[]{true});
        }
        if (doorResponses.size() == 0) {
            return new Object[]{false, "No Security door found"};
        }
        return new Object[]{doorResponses.toArray()};
    }

    public static Object[] isOpen(World world, BlockPos controller) {
        ArrayList<Boolean> states = new ArrayList<Boolean>();
        for (Map.Entry<BlockPos, BlockDoor> doorSet : DoorController.getDoors(world, controller).entrySet()) {
            states.add(BlockDoor.func_176514_f((IBlockAccess)world, (BlockPos)doorSet.getKey()));
        }
        return new Object[]{states.toArray()};
    }

    public static Object[] toggle(World world, BlockPos controller, String password) {
        Iterator<Map.Entry<BlockPos, BlockDoor>> iterator = DoorController.getDoors(world, controller).entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<BlockPos, BlockDoor> doorSet = iterator.next();
            return DoorController.setDoorStates(world, controller, !BlockDoor.func_176514_f((IBlockAccess)world, (BlockPos)doorSet.getKey()), password);
        }
        return new Object[]{false, "couldnt find any door"};
    }

    public static HashMap<BlockPos, BlockDoor> getDoors(World world, BlockPos pos) {
        return DoorController.getDoors(world, pos, true);
    }

    private static HashMap<BlockPos, BlockDoor> getDoors(World world, BlockPos pos, boolean searchMaindoor) {
        HashMap<BlockPos, BlockDoor> doors = new HashMap<BlockPos, BlockDoor>();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            BlockPos position;
            Block block;
            if (!searchMaindoor && (direction.equals((Object)EnumFacing.UP) || direction.equals((Object)EnumFacing.DOWN)) || !((block = world.func_180495_p(position = pos.func_177972_a(direction)).func_177230_c()) instanceof BlockDoor)) continue;
            doors.put(position, (BlockDoor)block);
            if (!searchMaindoor) continue;
            doors.putAll(DoorController.getDoors(world, position, false));
        }
        return doors;
    }
}

