/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pcl.opensecurity.common.blocks.BlockRolldoor;
import pcl.opensecurity.common.blocks.BlockRolldoorElement;
import pcl.opensecurity.common.interfaces.ICamo;
import pcl.opensecurity.common.tileentity.TileEntityOSCamoBase;
import pcl.opensecurity.common.tileentity.TileEntityRolldoorController;
import pcl.opensecurity.common.tileentity.logic.RolldoorHelper;

public class TileEntityRolldoor
extends TileEntityOSCamoBase
implements ICamo {
    public static final int MAX_LENGTH = 16;
    private int height = 0;
    private AxisAlignedBB bb = Block.field_185505_j;
    private WeakReference<TileEntityRolldoorController> controller;
    private BlockPos origin;

    public TileEntityRolldoor() {
        super("os_rolldoor");
    }

    public void remove() {
        this.removeElements();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.height = nbt.func_74762_e("height");
        if (nbt.func_74764_b("origin")) {
            this.origin = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("origin"));
        }
        this.updateBB();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("height", this.height);
        if (this.origin != null) {
            nbt.func_74782_a("origin", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.origin));
        }
        return super.func_189515_b(nbt);
    }

    public void initialize() {
        TileEntityRolldoorController controller = RolldoorHelper.getAdjacentController(this.func_145831_w(), this.func_174877_v());
        if (controller == null) {
            TileEntityRolldoor tile;
            Iterator<TileEntityRolldoor> iterator = RolldoorHelper.getAdjacentRolldoors(this.func_145831_w(), this.func_174877_v()).values().iterator();
            while (iterator.hasNext() && (controller = (tile = iterator.next()).getController()) == null) {
            }
        }
        if (controller != null) {
            controller.initialize();
        }
        this.updateHeight();
    }

    public EnumFacing getFacing() {
        return BlockRolldoor.getFacing(this.func_145831_w().func_180495_p(this.func_174877_v()));
    }

    public void updateHeight() {
        this.height = 0;
        BlockPos pos = this.func_174877_v().func_177977_b();
        while ((this.func_145831_w().func_175623_d(pos) || this.func_145831_w().func_180495_p(pos).func_177230_c().equals(BlockRolldoorElement.DEFAULTITEM)) && this.height < 16) {
            if (this.func_145831_w().func_175623_d(pos)) {
                IBlockState state = BlockRolldoorElement.DEFAULTITEM.func_176223_P();
                state = state.func_177226_a((IProperty)BlockRolldoorElement.PROPERTYOFFSET, (Comparable)Integer.valueOf(this.height));
                this.func_145831_w().func_175656_a(pos, state);
            }
            pos = pos.func_177977_b();
            ++this.height;
        }
        this.updateBB();
        this.markDirtyClient();
    }

    private void updateBB() {
        this.bb = Block.field_185505_j.func_72321_a(0.0, (double)(-this.height()), 0.0);
    }

    private void removeElements() {
        this.height = 0;
        BlockPos pos = this.func_174877_v().func_177977_b();
        for (int element = 0; (this.func_145831_w().func_175623_d(pos) || this.func_145831_w().func_180495_p(pos).func_177230_c().equals(BlockRolldoorElement.DEFAULTITEM)) && element < 16; ++element) {
            if (this.func_145831_w().func_180495_p(pos).func_177230_c().equals(BlockRolldoorElement.DEFAULTITEM)) {
                this.func_145831_w().func_175698_g(pos);
            }
            pos = pos.func_177977_b();
        }
    }

    public int height() {
        return this.height;
    }

    public AxisAlignedBB getElementsBoundingBox() {
        return this.bb.func_186670_a(this.func_174877_v());
    }

    public void setOrigin(BlockPos pos) {
        this.origin = pos;
    }

    public TileEntityRolldoorController getController() {
        if (this.origin == null) {
            return null;
        }
        if (this.controller == null || this.controller.get() == null || ((TileEntityRolldoorController)this.controller.get()).func_145837_r()) {
            TileEntity tile = this.func_145831_w().func_175625_s(this.origin);
            if (tile instanceof TileEntityRolldoorController) {
                this.controller = new WeakReference<TileEntityRolldoorController>((TileEntityRolldoorController)tile);
            } else {
                return null;
            }
        }
        return (TileEntityRolldoorController)this.controller.get();
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

